/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.client.gui.GPSAreaToolScreen;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.drone.progwidgets.SavedDroneProgram;
import me.desht.pneumaticcraft.common.item.IGPSToolSync;
import me.desht.pneumaticcraft.common.item.ILeftClickableItem;
import me.desht.pneumaticcraft.common.item.IShiftScrollable;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketLeftClickEmpty;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.variables.GlobalVariableHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.apache.commons.lang3.Validate;

public class GPSAreaToolItem
extends Item
implements IPositionProvider,
IGPSToolSync,
ILeftClickableItem,
IShiftScrollable {
    public GPSAreaToolItem() {
        super(ModItems.defaultProps().component(ModDataComponents.SAVED_DRONE_PROGRAM, (Object)SavedDroneProgram.EMPTY).component(ModDataComponents.GPS_AREA_TOOL_INDEX, (Object)0));
    }

    public InteractionResult useOn(UseOnContext ctx) {
        if (ctx.getPlayer() != null) {
            Optional<BlockPos> optPos = GPSAreaToolItem.getGPSLocation(ctx.getPlayer(), ctx.getItemInHand(), 0);
            if (!ctx.getClickedPos().equals(optPos.orElse(null))) {
                GPSAreaToolItem.setGPSPosAndNotify(ctx.getPlayer(), ctx.getHand(), ctx.getClickedPos(), 0);
                ctx.getPlayer().playSound((SoundEvent)ModSounds.CHIRP.get(), 1.0f, 1.5f);
                GPSAreaToolItem.setActiveIndex(ctx.getPlayer(), ctx.getItemInHand(), 0);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (worldIn.isClientSide && !playerIn.isCrouching()) {
            GPSAreaToolScreen.showGUI(stack, handIn, 0);
        } else if (playerIn.isCrouching()) {
            GPSAreaToolItem.setActiveIndex(playerIn, stack, 0);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public static void setActiveIndex(Player player, ItemStack stack, int index) {
        Validate.isTrue((index == 0 || index == 1 ? 1 : 0) != 0);
        stack.set(ModDataComponents.GPS_AREA_TOOL_INDEX, (Object)index);
        String str = index == 0 ? String.valueOf(ChatFormatting.RED) + "P1" : String.valueOf(ChatFormatting.GREEN) + "P2";
        player.displayClientMessage((Component)stack.getDisplayName().copy().withStyle(ChatFormatting.AQUA).append(" ").append((Component)Component.translatable((String)"pneumaticcraft.message.gps_tool.activeIndex", (Object[])new Object[]{str}).withStyle(ChatFormatting.YELLOW)), true);
    }

    public static int getActiveIndex(ItemStack stack) {
        return (Integer)stack.getOrDefault(ModDataComponents.GPS_AREA_TOOL_INDEX, (Object)0);
    }

    public static void setGPSPosAndNotify(Player player, ItemStack stack, BlockPos pos, int index) {
        GPSAreaToolItem.setGPSLocation(player, stack, pos, null, index, true);
        if (player instanceof ServerPlayer) {
            GPSAreaToolItem.notifyPlayer(player, stack, pos, index, false);
        }
    }

    public static void setGPSPosAndNotify(Player player, InteractionHand hand, BlockPos pos, int index) {
        GPSAreaToolItem.setGPSPosAndNotify(player, player.getItemInHand(hand), pos, index);
    }

    private static void notifyPlayer(Player player, ItemStack stack, BlockPos pos, int index, boolean actionBar) {
        player.displayClientMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.AQUA) + String.format("[%s] ", stack.getHoverName().getString()))).append(GPSAreaToolItem.getMessageText(player.level(), pos, index)), actionBar);
    }

    private static Component getMessageText(Level worldIn, BlockPos pos, int index) {
        Component translated = PneumaticCraftUtils.getBlockNameAt(worldIn, pos);
        MutableComponent blockName = worldIn.isLoaded(pos) ? Component.literal((String)" (").append(translated).append(")") : Component.empty().plainCopy();
        String str = String.format("P%d%s: [%d, %d, %d]", index + 1, ChatFormatting.YELLOW, pos.getX(), pos.getY(), pos.getZ());
        return Component.literal((String)str).withStyle(index == 0 ? ChatFormatting.RED : ChatFormatting.GREEN).append((Component)blockName.withStyle(ChatFormatting.GREEN));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> infoList, TooltipFlag par4) {
        super.appendHoverText(stack, context, infoList, par4);
        ClientUtils.getOptionalClientLevel().ifPresent(level -> {
            ClientUtils.addGuiContextSensitiveTooltip(stack, infoList);
            int n = infoList.size();
            ProgWidgetArea area = GPSAreaToolItem.getArea(ClientUtils.getClientPlayer(), stack);
            for (int index = 0; index < 2; ++index) {
                int i = index;
                GPSAreaToolItem.getGPSLocation(ClientUtils.getClientPlayer(), stack, index).ifPresent(pos -> infoList.add(GPSAreaToolItem.getMessageText(level, pos, i)));
                String varName = area.getVarName(index);
                if (varName.isEmpty()) continue;
                infoList.add((Component)Component.literal((String)" ").append((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.gpsTool.variable", varName)));
            }
            if (infoList.size() - n >= 2) {
                area.addAreaTypeTooltip(infoList);
            }
        });
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean heldItem) {
        if (!world.isClientSide && entity instanceof Player) {
            Player p = (Player)entity;
            ProgWidgetArea area = GPSAreaToolItem.getArea(p, stack);
            for (int index = 0; index < 2; ++index) {
                BlockPos pos;
                BlockPos curPos;
                String varName = area.getVarName(index);
                if (varName.isEmpty() || (curPos = area.getPos(index).orElse(PneumaticCraftUtils.invalidPos())).equals((Object)(pos = GlobalVariableHelper.getInstance().getPos(entity.getUUID(), varName, PneumaticCraftUtils.invalidPos())))) continue;
                GPSAreaToolItem.setGPSLocation(p, stack, pos, area, index, false);
            }
        }
    }

    @Nonnull
    public static ProgWidgetArea getArea(UUID playerId, ItemStack stack) {
        IProgWidget iProgWidget;
        Validate.isTrue((boolean)(stack.getItem() instanceof GPSAreaToolItem));
        List<IProgWidget> widgets = SavedDroneProgram.loadProgWidgets(stack);
        if (!widgets.isEmpty() && (iProgWidget = widgets.getFirst()) instanceof ProgWidgetArea) {
            ProgWidgetArea area = (ProgWidgetArea)iProgWidget;
            area.setVariableProvider(GlobalVariableHelper.getInstance().getVariableProvider(), playerId);
            return area;
        }
        return new ProgWidgetArea();
    }

    public static ProgWidgetArea getArea(Player player, ItemStack stack) {
        return GPSAreaToolItem.getArea(player.getUUID(), stack);
    }

    public static Optional<BlockPos> getGPSLocation(Player player, ItemStack gpsTool, int index) {
        Validate.isTrue((index == 0 || index == 1 ? 1 : 0) != 0, (String)"index must be 0 or 1!", (Object[])new Object[0]);
        ProgWidgetArea area = GPSAreaToolItem.getArea(player, gpsTool);
        Optional<BlockPos> pos = area.getPos(index);
        String var = area.getVarName(index);
        if (!var.isEmpty() && !player.level().isClientSide) {
            BlockPos newPos = GlobalVariableHelper.getInstance().getPos(player.getUUID(), var);
            if (pos.isEmpty() || !pos.get().equals((Object)newPos)) {
                area.setPos(index, newPos);
                GPSAreaToolItem.setArea(gpsTool, area);
            }
            return Optional.of(newPos);
        }
        return pos;
    }

    private static void setGPSLocation(Player player, ItemStack gpsTool, BlockPos pos, ProgWidgetArea area, int index, boolean updateVar) {
        String varName;
        if (area == null) {
            area = GPSAreaToolItem.getArea(player, gpsTool);
        }
        area.setPos(index, pos);
        GPSAreaToolItem.setArea(gpsTool, area);
        if (updateVar && !(varName = area.getVarName(index)).isEmpty()) {
            GlobalVariableHelper.getInstance().setPos(player.getUUID(), varName, pos);
        }
    }

    public static void setVariable(Player player, ItemStack gpsTool, String variable, int index) {
        ProgWidgetArea area = GPSAreaToolItem.getArea(player, gpsTool);
        area.setVarName(index, variable);
        GPSAreaToolItem.setArea(gpsTool, area);
    }

    public static void setArea(ItemStack gpsTool, ProgWidgetArea area) {
        SavedDroneProgram.writeToItem(gpsTool, List.of(area));
    }

    public static String getVariable(Player player, ItemStack gpsTool, int index) {
        return GPSAreaToolItem.getArea(player, gpsTool).getVarName(index);
    }

    @Override
    public void syncVariables(ServerPlayer player, ItemStack stack) {
        ProgWidgetArea area = GPSAreaToolItem.getArea((Player)player, stack);
        String v1 = area.getVarName(0);
        String v2 = area.getVarName(1);
        if (GlobalVariableHelper.getInstance().hasPrefix(v1)) {
            PneumaticRegistry.getInstance().getMiscHelpers().syncGlobalVariable(player, v1);
        }
        if (GlobalVariableHelper.getInstance().hasPrefix(v2)) {
            PneumaticRegistry.getInstance().getMiscHelpers().syncGlobalVariable(player, v2);
        }
    }

    @Override
    public List<BlockPos> getStoredPositions(UUID playerId, @Nonnull ItemStack stack) {
        ProgWidgetArea widgetArea = GPSAreaToolItem.getArea(playerId, stack);
        return List.copyOf(widgetArea.getArea(new HashSet<BlockPos>()));
    }

    @Override
    public List<BlockPos> getRawStoredPositions(Player player, ItemStack stack) {
        ProgWidgetArea area = GPSAreaToolItem.getArea(player, stack);
        return ImmutableList.of((Object)area.getPos(0).orElse(BlockPos.ZERO), (Object)area.getPos(1).orElse(BlockPos.ZERO));
    }

    @Override
    public int getRenderColor(int index) {
        return 0x60FFFF00;
    }

    @Override
    public boolean disableDepthTest() {
        return false;
    }

    @Override
    public void syncFromClient(Player player, ItemStack stack, int index, BlockPos pos, String varName, boolean activeIndex) {
        GPSAreaToolItem.setVariable(player, stack, varName, index);
        GPSAreaToolItem.setGPSPosAndNotify(player, stack, pos, index);
        if (activeIndex) {
            GPSAreaToolItem.setActiveIndex(player, stack, index);
        }
        if (!varName.isEmpty()) {
            GlobalVariableHelper.getInstance().setPos(player.getUUID(), varName, pos);
        }
    }

    @Override
    public void onLeftClickEmpty(ServerPlayer sender) {
        if (sender.getMainHandItem().getItem() instanceof GPSAreaToolItem) {
            GPSAreaToolItem.setActiveIndex((Player)sender, sender.getMainHandItem(), 1);
        }
    }

    @Override
    public void onShiftScrolled(Player player, boolean forward, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getItem() instanceof GPSAreaToolItem) {
            int index = GPSAreaToolItem.getActiveIndex(stack);
            GPSAreaToolItem.getGPSLocation(player, stack, index).ifPresent(loc -> {
                Direction facing = Direction.orderedByNearest((Entity)player)[0];
                BlockPos newPos = loc.relative(forward ? facing : facing.getOpposite());
                GPSAreaToolItem.setGPSLocation(player, stack, newPos, null, index, true);
                GPSAreaToolItem.notifyPlayer(player, stack, newPos, index, true);
            });
        }
    }

    public static class EventHandler {
        @SubscribeEvent
        public static void onBlockLeftClick(PlayerInteractEvent.LeftClickBlock event) {
            if (event.getItemStack().getItem() == ModItems.GPS_AREA_TOOL.get()) {
                Optional<BlockPos> optPos = GPSAreaToolItem.getGPSLocation(event.getEntity(), event.getItemStack(), 1);
                if (!event.getPos().equals(optPos.orElse(null))) {
                    event.getEntity().playSound((SoundEvent)ModSounds.CHIRP.get(), 1.0f, 1.5f);
                    GPSAreaToolItem.setGPSPosAndNotify(event.getEntity(), event.getHand(), event.getPos(), 1);
                }
                GPSAreaToolItem.setActiveIndex(event.getEntity(), event.getItemStack(), 1);
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onLeftClickAir(PlayerInteractEvent.LeftClickEmpty event) {
            if (event.getItemStack().getItem() == ModItems.GPS_AREA_TOOL.get()) {
                if (!event.getEntity().isCrouching()) {
                    GPSAreaToolScreen.showGUI(event.getItemStack(), event.getHand(), 1);
                } else {
                    NetworkHandler.sendToServer(PacketLeftClickEmpty.INSTANCE);
                }
            }
        }
    }
}

