/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.block.entity.elevator.ElevatorCallerBlockEntity;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import org.joml.Matrix4f;

public class ElevatorCallerRenderer
implements BlockEntityRenderer<ElevatorCallerBlockEntity> {
    private static final float Z_OFFSET = 0.499f;
    private final Font font;

    public ElevatorCallerRenderer(BlockEntityRendererProvider.Context ctx) {
        this.font = ctx.getFont();
    }

    public void render(ElevatorCallerBlockEntity te, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.5, 1.5, 0.5);
        matrixStackIn.scale(1.0f, -1.0f, -1.0f);
        RenderUtils.rotateMatrixForDirection(matrixStackIn, te.getRotation());
        matrixStackIn.translate(-1.0f, 0.0f, -1.0f);
        Matrix4f posMat = matrixStackIn.last().pose();
        for (ElevatorCallerBlockEntity.ElevatorButton button : te.getFloors()) {
            VertexConsumer builder = bufferIn.getBuffer(ModRenderTypes.UNTEXTURED_QUAD);
            builder.addVertex(posMat, button.posX + 0.5f, button.posY + 0.5f, 0.499f).setColor(button.red, button.green, button.blue, 0.1f).setLight(0xF000A0);
            builder.addVertex(posMat, button.posX + 0.5f, button.posY + button.height + 0.5f, 0.499f).setColor(button.red, button.green, button.blue, 0.1f).setLight(0xF000A0);
            builder.addVertex(posMat, button.posX + button.width + 0.5f, button.posY + button.height + 0.5f, 0.499f).setColor(button.red, button.green, button.blue, 0.1f).setLight(0xF000A0);
            builder.addVertex(posMat, button.posX + button.width + 0.5f, button.posY + 0.5f, 0.499f).setColor(button.red, button.green, button.blue, 0.1f).setLight(0xF000A0);
            matrixStackIn.pushPose();
            matrixStackIn.translate((double)button.posX + 0.5, (double)button.posY + 0.5, 0.498);
            matrixStackIn.translate(button.width / 2.0f, button.height / 2.0f, 0.0f);
            float textScale = Math.min(button.width / 10.0f, button.height / 10.0f);
            matrixStackIn.scale(textScale, textScale, textScale);
            String string = button.buttonText;
            float f = (float)(-this.font.width(button.buttonText)) / 2.0f;
            Objects.requireNonNull(this.font);
            this.font.drawInBatch(string, f, (float)(-9) / 2.0f + 1.0f, -1, false, matrixStackIn.last().pose(), bufferIn, Font.DisplayMode.NORMAL, 50, 0xF000A0);
            matrixStackIn.popPose();
        }
        matrixStackIn.popPose();
    }
}

