/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.util;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.Collection;
import java.util.Comparator;
import me.desht.modularrouters.logic.settings.ModuleFlags;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class SetofItemStack
extends ObjectOpenCustomHashSet<ItemStack> {
    private static final Comparator<? super ItemStack> COMPARE_STACKS = Comparator.comparing(stack -> SetofItemStack.namespace(stack.getItem())).thenComparing(stack -> stack.getHoverName().getString());

    public SetofItemStack(ModuleFlags filterFlags) {
        super((Hash.Strategy)new ItemStackHashingStrategy(filterFlags));
    }

    public SetofItemStack(Collection<? extends ItemStack> collection, ModuleFlags filterFlags) {
        super(collection, (Hash.Strategy)new ItemStackHashingStrategy(filterFlags));
    }

    public static SetofItemStack fromItemHandler(IItemHandler handler, ModuleFlags filterFlags) {
        NonNullList itemStacks = NonNullList.create();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            itemStacks.add((Object)stack.copy());
        }
        return new SetofItemStack((Collection<? extends ItemStack>)itemStacks, filterFlags);
    }

    public Collection<ItemStack> sorted() {
        return this.stream().sorted(COMPARE_STACKS).toList();
    }

    private static String namespace(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).getNamespace();
    }

    private record ItemStackHashingStrategy(ModuleFlags filterFlags) implements Hash.Strategy<ItemStack>
    {
        public int hashCode(ItemStack object) {
            if (this.filterFlags.matchComponents()) {
                return ItemStack.hashItemAndComponents((ItemStack)object);
            }
            int hashCode = Item.getId((Item)object.getItem());
            return this.filterFlags.matchDamage() ? hashCode + 37 * object.getDamageValue() : hashCode;
        }

        public boolean equals(ItemStack o1, ItemStack o2) {
            return o1 == o2 || o1 != null && o2 != null && o1.getItem() == o2.getItem() && (!this.filterFlags.matchDamage() || o1.getDamageValue() == o2.getDamageValue()) && (!this.filterFlags.matchComponents() || ItemStack.isSameItemSameComponents((ItemStack)o1, (ItemStack)o2));
        }
    }
}

