/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.integration.XPCollection;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.logic.settings.RelativeDirection;
import me.desht.modularrouters.util.InventoryUtils;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public class CompiledVacuumModule
extends CompiledModule {
    public static final String NBT_XP_FLUID_TYPE = "XPFluidType";
    public static final String NBT_AUTO_EJECT = "AutoEject";
    private final VacuumSettings settings;
    private final boolean fastPickup;
    private final boolean xpMode;
    private final FluidStack xpJuiceStack;
    private BlockCapabilityCache<IFluidHandler, Direction> fluidReceiverCache = null;
    private int xpBuffered = 0;

    public CompiledVacuumModule(ModularRouterBlockEntity router, ItemStack stack) {
        super(router, stack);
        Fluid xpFluid;
        this.settings = (VacuumSettings)stack.getOrDefault(ModDataComponents.VACUUM_SETTINGS, (Object)VacuumSettings.DEFAULT);
        this.fastPickup = this.getAugmentCount((Supplier<Item>)ModItems.FAST_PICKUP_AUGMENT) > 0;
        boolean bl = this.xpMode = this.getAugmentCount((Supplier<Item>)ModItems.XP_VACUUM_AUGMENT) > 0;
        this.xpJuiceStack = this.xpMode ? ((xpFluid = this.settings.collectionType.getFluid()) == Fluids.EMPTY ? FluidStack.EMPTY : new FluidStack(xpFluid, 1000)) : FluidStack.EMPTY;
    }

    @Override
    public boolean execute(@Nonnull ModularRouterBlockEntity router) {
        if (this.xpMode) {
            return this.handleXpMode(router);
        }
        return this.handleItemMode(router);
    }

    @Override
    public void onNeighbourChange(ModularRouterBlockEntity router) {
        this.fluidReceiverCache = null;
    }

    @Override
    public List<ModuleTarget> setupTargets(ModularRouterBlockEntity router, ItemStack stack) {
        if (router == null) {
            return null;
        }
        RelativeDirection dir = this.getDirection();
        int offset = dir == RelativeDirection.NONE ? 0 : this.getRange() + 1;
        Direction facing = router.getAbsoluteFacing(dir);
        GlobalPos gPos = MiscUtil.makeGlobalPos(router.nonNullLevel(), router.getBlockPos().relative(facing, offset));
        return List.of(new ModuleTarget(gPos, facing));
    }

    @Override
    protected boolean isTargetValid(ModularRouterBlockEntity router, ModuleTarget target) {
        return true;
    }

    private boolean handleItemMode(ModularRouterBlockEntity router) {
        if (router.isBufferFull()) {
            return false;
        }
        ItemStack bufferStack = router.getBuffer().getStackInSlot(0);
        BlockPos centrePos = this.getTarget().gPos.pos();
        int range = this.getRange();
        List items = router.nonNullLevel().getEntitiesOfClass(ItemEntity.class, new AABB(centrePos).inflate((double)range));
        int toPickUp = this.getItemsPerTick(router);
        for (ItemEntity item : items) {
            if (!item.isAlive() || !this.fastPickup && item.hasPickUpDelay()) continue;
            ItemStack stackOnGround = item.getItem();
            if (!bufferStack.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)stackOnGround, (ItemStack)bufferStack) || !this.getFilter().test(stackOnGround)) continue;
            int inRouter = bufferStack.getCount();
            int spaceInRouter = this.getRegulationAmount() > 0 ? Math.min(stackOnGround.getMaxStackSize(), this.getRegulationAmount()) - inRouter : stackOnGround.getMaxStackSize() - inRouter;
            ItemStack vacuumed = stackOnGround.split(Math.min(this.getItemsPerTick(router), spaceInRouter));
            ItemStack excess = router.insertBuffer(vacuumed);
            int remaining = excess == null ? 0 : excess.getCount();
            stackOnGround.grow(remaining);
            int inserted = vacuumed.getCount() - remaining;
            toPickUp -= inserted;
            if (stackOnGround.isEmpty()) {
                item.remove(Entity.RemovalReason.DISCARDED);
            }
            if (inserted > 0 && ((Boolean)ConfigHolder.common.module.vacuumParticles.get()).booleanValue() && router.getUpgradeCount((UpgradeItem)ModItems.MUFFLER_UPGRADE.get()) < 2) {
                ((ServerLevel)router.nonNullLevel()).sendParticles((ParticleOptions)ParticleTypes.CLOUD, item.getX(), item.getY() + 0.25, item.getZ(), 2, 0.0, 0.0, 0.0, 0.0);
            }
            if (toPickUp > 0) continue;
            break;
        }
        return toPickUp < this.getItemsPerTick(router);
    }

    private boolean handleXpMode(ModularRouterBlockEntity router) {
        int spaceForXp;
        IFluidHandler fluidHandler = null;
        if (this.getXPCollectionType().isSolid()) {
            ItemStack inRouterStack = router.getBufferItemStack();
            if (!inRouterStack.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)inRouterStack, (ItemStack)this.getXPCollectionType().getIcon())) {
                return false;
            }
            spaceForXp = ((inRouterStack.isEmpty() ? this.getXPCollectionType().getIcon() : inRouterStack).getMaxStackSize() - inRouterStack.getCount()) * this.getXPCollectionType().getXpRatio();
        } else {
            fluidHandler = this.getFluidReceiver(router);
            if (fluidHandler == null) {
                fluidHandler = router.getFluidHandler();
            }
            spaceForXp = this.findSpaceForXPFluid(fluidHandler);
        }
        if (spaceForXp == 0) {
            return false;
        }
        List orbs = router.nonNullLevel().getEntitiesOfClass(ExperienceOrb.class, new AABB(this.getTarget().gPos.pos()).inflate((double)this.getRange()), Entity::isAlive);
        if (orbs.isEmpty()) {
            return false;
        }
        XPCollection.XPCollectionType xpCollectionType = this.getXPCollectionType();
        int initialSpaceForXp = spaceForXp;
        block0: for (ExperienceOrb orb : orbs) {
            for (int rate = this.getItemsPerTick(router); orb.getValue() <= spaceForXp && rate > 0; --rate) {
                if (xpCollectionType.isSolid()) {
                    this.xpBuffered += orb.getValue();
                    if (this.xpBuffered > xpCollectionType.getXpRatio()) {
                        int count = this.xpBuffered / xpCollectionType.getXpRatio();
                        ItemStack stack = xpCollectionType.getIcon().copyWithCount(count);
                        ItemStack excess = router.insertBuffer(stack);
                        this.xpBuffered -= stack.getCount() * xpCollectionType.getXpRatio();
                        if (!excess.isEmpty()) {
                            InventoryUtils.dropItems(router.nonNullLevel(), Vec3.atCenterOf((Vec3i)router.getBlockPos()), excess);
                        }
                    }
                } else if (!this.doFluidXPFill(orb, fluidHandler)) {
                    spaceForXp = 0;
                }
                spaceForXp -= orb.getValue();
                --orb.count;
                if (orb.count > 0) continue;
                orb.remove(Entity.RemovalReason.DISCARDED);
                continue block0;
            }
        }
        return initialSpaceForXp - spaceForXp > 0;
    }

    private IFluidHandler getFluidReceiver(ModularRouterBlockEntity router) {
        Direction[] directionArray;
        if (!this.xpMode || this.xpJuiceStack.isEmpty() || !((directionArray = router.getLevel()) instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)directionArray;
        if (this.fluidReceiverCache == null) {
            for (Direction face : MiscUtil.DIRECTIONS) {
                BlockPos pos = router.getBlockPos().relative(face);
                IFluidHandler handler = (IFluidHandler)serverLevel.getCapability(Capabilities.FluidHandler.BLOCK, pos, (Object)face.getOpposite());
                if (handler == null || handler.fill(this.xpJuiceStack, IFluidHandler.FluidAction.SIMULATE) <= 0) continue;
                this.fluidReceiverCache = BlockCapabilityCache.create((BlockCapability)Capabilities.FluidHandler.BLOCK, (ServerLevel)serverLevel, (BlockPos)pos, (Object)face.getOpposite(), () -> true, () -> {
                    this.fluidReceiverCache = null;
                });
                break;
            }
        }
        return this.fluidReceiverCache == null ? null : (IFluidHandler)this.fluidReceiverCache.getCapability();
    }

    private boolean doFluidXPFill(ExperienceOrb orb, @Nullable IFluidHandler xpHandler) {
        if (xpHandler == null) {
            return false;
        }
        FluidStack xpStack = new FluidStack(this.xpJuiceStack.getFluid(), orb.getValue() * this.getXPCollectionType().getXpRatio() + this.xpBuffered);
        int filled = xpHandler.fill(xpStack, IFluidHandler.FluidAction.EXECUTE);
        if (filled < xpStack.getAmount()) {
            this.xpBuffered = xpStack.getAmount() - filled;
            return false;
        }
        this.xpBuffered = 0;
        return true;
    }

    private int findSpaceForXPFluid(@Nullable IFluidHandler xpHandler) {
        int space = 0;
        if (xpHandler != null) {
            for (int idx = 0; idx < xpHandler.getTanks(); ++idx) {
                FluidStack fluidStack;
                if (!xpHandler.isFluidValid(idx, this.xpJuiceStack) || !(fluidStack = xpHandler.getFluidInTank(idx)).isEmpty() && fluidStack.getFluid() != this.getXPCollectionType().getFluid()) continue;
                space += (xpHandler.getTankCapacity(idx) - fluidStack.getAmount()) / this.getXPCollectionType().getXpRatio();
            }
        }
        return space;
    }

    public XPCollection.XPCollectionType getXPCollectionType() {
        return this.settings.collectionType;
    }

    public boolean isAutoEjecting() {
        return this.settings.autoEject;
    }

    public boolean isXpMode() {
        return this.xpMode;
    }

    public record VacuumSettings(boolean autoEject, XPCollection.XPCollectionType collectionType) {
        public static final VacuumSettings DEFAULT = new VacuumSettings(false, XPCollection.XPCollectionType.BOTTLE_O_ENCHANTING);
        public static final Codec<VacuumSettings> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.optionalFieldOf("auto_eject", (Object)false).forGetter(VacuumSettings::autoEject), (App)StringRepresentable.fromEnum(XPCollection.XPCollectionType::values).fieldOf("type").forGetter(VacuumSettings::collectionType)).apply((Applicative)builder, VacuumSettings::new));
        public static StreamCodec<FriendlyByteBuf, VacuumSettings> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, VacuumSettings::autoEject, (StreamCodec)NeoForgeStreamCodecs.enumCodec(XPCollection.XPCollectionType.class), VacuumSettings::collectionType, VacuumSettings::new);
    }
}

