/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.upgrade;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.TintColor;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.core.ModSounds;
import me.desht.modularrouters.item.IPlayerOwned;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import me.desht.modularrouters.util.TranslatableEnum;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;

public class SecurityUpgrade
extends UpgradeItem
implements IPlayerOwned {
    private static final int MAX_PLAYERS = 6;

    public SecurityUpgrade() {
        super(ModItems.defaultProps().component(ModDataComponents.SECURITY_LIST, (Object)SecurityList.DEFAULT));
    }

    @Override
    public void addExtraInformation(ItemStack itemstack, List<Component> list) {
        String owner = this.getOwnerProfile(itemstack).map(GameProfile::getName).orElse("-");
        list.add((Component)ClientUtil.xlate("modularrouters.itemText.security.owner", String.valueOf(ChatFormatting.AQUA) + owner));
        Set<String> names = SecurityUpgrade.getPlayerNames(itemstack);
        if (!names.isEmpty()) {
            list.add((Component)ClientUtil.xlate("modularrouters.itemText.security.count", names.size(), 6));
            list.addAll(names.stream().map(name -> " \u2022 " + String.valueOf(ChatFormatting.YELLOW) + name).sorted().map(Component::literal).toList());
        }
    }

    @Override
    public void onCompiled(ItemStack stack, ModularRouterBlockEntity router) {
        super.onCompiled(stack, router);
        router.addPermittedIds(this.getPlayerIDs(stack));
    }

    @Override
    public TintColor getItemTint() {
        return new TintColor(64, 64, 255);
    }

    private Set<UUID> getPlayerIDs(ItemStack stack) {
        return ((SecurityList)stack.getOrDefault(ModDataComponents.SECURITY_LIST, (Object)SecurityList.DEFAULT)).trusted().stream().map(tp -> tp.gameProfile().getId()).collect(Collectors.toSet());
    }

    private static Set<String> getPlayerNames(ItemStack stack) {
        return ((SecurityList)stack.getOrDefault(ModDataComponents.SECURITY_LIST, (Object)SecurityList.DEFAULT)).trusted().stream().map(tp -> tp.gameProfile().getName()).collect(Collectors.toSet());
    }

    private static Result addPlayer(ItemStack stack, GameProfile profile) {
        SecurityList securityList = (SecurityList)stack.getOrDefault(ModDataComponents.SECURITY_LIST, (Object)SecurityList.DEFAULT);
        if (securityList.trusted.size() >= 6) {
            return Result.FULL;
        }
        SecurityList newList = securityList.add(profile);
        if (newList.trusted.size() == securityList.trusted.size()) {
            return Result.ALREADY_ADDED;
        }
        stack.set(ModDataComponents.SECURITY_LIST, (Object)newList);
        return Result.ADDED;
    }

    private static Result removePlayer(ItemStack stack, GameProfile profile) {
        SecurityList securityList = (SecurityList)stack.getOrDefault(ModDataComponents.SECURITY_LIST, (Object)SecurityList.DEFAULT);
        SecurityList newList = securityList.remove(profile);
        if (newList.trusted.size() == securityList.trusted.size()) {
            return Result.NOT_PRESENT;
        }
        stack.set(ModDataComponents.SECURITY_LIST, (Object)newList);
        return Result.REMOVED;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!player.getCommandSenderWorld().isClientSide && player.isSteppingCarefully()) {
            this.setOwner(stack, player);
            Component displayName = (Component)Objects.requireNonNullElse(player.getDisplayName(), Component.literal((String)"?"));
            player.displayClientMessage((Component)Component.translatable((String)"modularrouters.itemText.security.owner", (Object[])new Object[]{displayName.getString()}), false);
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (entity instanceof Player) {
            Result res;
            Player targetPlayer = (Player)entity;
            GameProfile profile = targetPlayer.getGameProfile();
            Result result = res = player.isSteppingCarefully() ? SecurityUpgrade.removePlayer(stack, profile) : SecurityUpgrade.addPlayer(stack, profile);
            if (player.level().isClientSide) {
                player.playSound(res.isError() ? ModSounds.ERROR.get() : ModSounds.SUCCESS.get(), ((Double)ConfigHolder.common.sound.bleepVolume.get()).floatValue(), 1.0f);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)res.getTranslationKey(), (Object[])new Object[]{profile.getName()}), false);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public record SecurityList(List<ResolvableProfile> trusted) {
        public static final SecurityList DEFAULT = new SecurityList(List.of());
        public static final Codec<SecurityList> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResolvableProfile.CODEC.listOf(0, 6).fieldOf("trusted").forGetter(SecurityList::trusted)).apply((Applicative)builder, SecurityList::new));
        public static StreamCodec<FriendlyByteBuf, SecurityList> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResolvableProfile.STREAM_CODEC.apply(ByteBufCodecs.list((int)6)), SecurityList::trusted, SecurityList::new);

        public SecurityList add(GameProfile profile) {
            HashSet<ResolvableProfile> l = new HashSet<ResolvableProfile>(this.trusted);
            l.add(new ResolvableProfile(profile));
            return new SecurityList(List.copyOf(l));
        }

        public SecurityList remove(GameProfile profile) {
            List<ResolvableProfile> l = this.trusted.stream().filter(rp -> !rp.gameProfile().equals((Object)profile)).toList();
            return new SecurityList(l);
        }
    }

    static enum Result implements TranslatableEnum,
    StringRepresentable
    {
        ADDED("added"),
        REMOVED("removed"),
        FULL("full"),
        ALREADY_ADDED("already_added"),
        ERROR("error"),
        NOT_PRESENT("not_present");

        private final String name;

        private Result(String name) {
            this.name = name;
        }

        boolean isError() {
            return this != ADDED && this != REMOVED;
        }

        @Override
        public String getTranslationKey() {
            return "modularrouters.chatText.security." + this.getSerializedName();
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

