/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.integration.jei;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import me.desht.modularrouters.client.gui.ModularRouterScreen;
import me.desht.modularrouters.client.gui.filter.BulkItemFilterScreen;
import me.desht.modularrouters.client.gui.module.ModuleScreen;
import me.desht.modularrouters.integration.jei.BulkFilterScreenGhost;
import me.desht.modularrouters.integration.jei.ModuleScreenGhost;
import me.desht.modularrouters.item.augment.AugmentItem;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import me.desht.modularrouters.util.MiscUtil;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IIngredientAliasRegistration;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidUtil;

@JeiPlugin
public class JEIModularRoutersPlugin
implements IModPlugin {
    static final Map<IIngredientType<?>, Function<Object, ItemStack>> STACK_CREATORS = new IdentityHashMap();

    public static synchronized <T> void registerGhostStackCreator(IIngredientType<T> type, Function<T, ItemStack> creator) {
        STACK_CREATORS.put(type, object -> (ItemStack)creator.apply(object));
    }

    public JEIModularRoutersPlugin() {
        JEIModularRoutersPlugin.registerGhostStackCreator(VanillaTypes.ITEM_STACK, Function.identity());
        JEIModularRoutersPlugin.registerGhostStackCreator(NeoForgeTypes.FLUID_STACK, FluidUtil::getFilledBucket);
    }

    public ResourceLocation getPluginUid() {
        return MiscUtil.RL("default");
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGhostIngredientHandler(ModuleScreen.class, (IGhostIngredientHandler)new ModuleScreenGhost());
        registration.addGhostIngredientHandler(BulkItemFilterScreen.class, (IGhostIngredientHandler)new BulkFilterScreenGhost());
        registration.addGuiContainerHandler(ModularRouterScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<ModularRouterScreen>(this){

            public List<Rect2i> getGuiExtraAreas(ModularRouterScreen routerScreen) {
                return routerScreen.getExtraArea();
            }
        });
    }

    public void registerIngredientAliases(IIngredientAliasRegistration registration) {
        for (Item item : BuiltInRegistries.ITEM) {
            if (item instanceof ModuleItem) {
                registration.addAlias((IIngredientType)VanillaTypes.ITEM_STACK, (Object)item.getDefaultInstance(), "Modular Router Module");
                continue;
            }
            if (item instanceof UpgradeItem) {
                registration.addAlias((IIngredientType)VanillaTypes.ITEM_STACK, (Object)item.getDefaultInstance(), "Modular Router Upgrade");
                continue;
            }
            if (!(item instanceof AugmentItem)) continue;
            registration.addAlias((IIngredientType)VanillaTypes.ITEM_STACK, (Object)item.getDefaultInstance(), "Modular Router Module Augment");
        }
    }
}

