/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.container;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.container.FilterSlot;
import me.desht.modularrouters.container.ModuleMenu;
import me.desht.modularrouters.container.handler.BaseModuleHandler;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.core.ModMenuTypes;
import me.desht.modularrouters.util.MFLocator;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.neoforged.neoforge.items.IItemHandler;

public class Extruder2ModuleMenu
extends ModuleMenu {
    private static final int TEMPLATE_SLOTS = 9;

    Extruder2ModuleMenu(int windowId, Inventory inv, FriendlyByteBuf extra) {
        this(windowId, inv, MFLocator.fromNetwork(extra));
    }

    public Extruder2ModuleMenu(int windowId, Inventory inv, MFLocator locator) {
        super(ModMenuTypes.EXTRUDER2_MENU.get(), windowId, inv, locator);
        TemplateHandler handler = new TemplateHandler(locator.getModuleStack(inv.player), this.router);
        for (int i = 0; i < 9; ++i) {
            this.addSlot((Slot)new FilterSlot((IItemHandler)handler, i, 129 + 18 * (i % 3), 17 + 18 * (i / 3)));
        }
    }

    @Override
    protected void transferStackInExtraSlot(Player player, int index) {
        ((Slot)this.slots.get(index)).set(ItemStack.EMPTY);
    }

    @Override
    protected void slotClickExtraSlot(int slot, int dragType, ClickType clickTypeIn, Player player) {
        Slot s = (Slot)this.slots.get(slot);
        ItemStack stackOnCursor = this.getCarried();
        ItemStack stackInSlot = s.getItem().copy();
        if (clickTypeIn == ClickType.QUICK_MOVE) {
            s.set(ItemStack.EMPTY);
        } else if (!stackOnCursor.isEmpty() && !ItemStack.isSameItem((ItemStack)stackInSlot, (ItemStack)stackOnCursor) && s.mayPlace(stackOnCursor)) {
            ItemStack stack1 = stackOnCursor.copy();
            if (dragType == 1) {
                stack1.setCount(1);
            }
            s.set(stack1);
        } else if (!stackInSlot.isEmpty()) {
            if (dragType == 1) {
                stackInSlot.setCount(Math.min(stackInSlot.getMaxStackSize(), stackInSlot.getCount() + 1));
            } else if (dragType == 0) {
                stackInSlot.shrink(1);
            }
            s.set(stackInSlot);
            s.setChanged();
        }
    }

    private static boolean isItemOKForTemplate(ItemStack stack) {
        if (stack.isEmpty()) {
            return true;
        }
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem bi = (BlockItem)item;
            Block b = bi.getBlock();
            return b.defaultBlockState().getRenderShape() == RenderShape.MODEL && !BuiltInRegistries.BLOCK.getKey((Object)b).getNamespace().equals("chiselsandbits");
        }
        return true;
    }

    public static class TemplateHandler
    extends BaseModuleHandler {
        public TemplateHandler(ItemStack holderStack, ModularRouterBlockEntity router) {
            super(holderStack, router, 9, ModDataComponents.EXTRUDER2_TEMPLATE.get());
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return Extruder2ModuleMenu.isItemOKForTemplate(stack);
        }

        public List<ItemStack> toTemplate(int rangeLimit) {
            ItemStack stack1;
            ImmutableList.Builder b = new ImmutableList.Builder();
            for (int i = 0; i < this.getSlots() && this.stacks.size() < rangeLimit && !(stack1 = this.getStackInSlot(i)).isEmpty(); ++i) {
                for (int j = 0; j < stack1.getCount() && this.stacks.size() < rangeLimit; ++j) {
                    b.add((Object)stack1.copyWithCount(1));
                }
            }
            return b.build();
        }
    }
}

