/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.realtimers;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotMilker;
import vswe.stevescarts.entities.EntityMinecartModular;

public class ModuleMilker
extends ModuleBase {
    int cooldown = 0;
    int milkbuffer = 0;

    public ModuleMilker(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public void update() {
        super.update();
        if (this.cooldown <= 0) {
            if (!this.getCart().level().isClientSide && this.getCart().hasFuel()) {
                this.generateMilk();
                this.depositeMilk();
            }
            this.cooldown = 20;
        } else {
            --this.cooldown;
        }
    }

    private void depositeMilk() {
        if (this.milkbuffer > 0) {
            FluidStack ret = (FluidStack)FluidUtil.getFluidContained((ItemStack)new ItemStack((ItemLike)Items.MILK_BUCKET)).get();
            if (ret != null) {
                ret.setAmount(this.milkbuffer);
                this.milkbuffer -= this.getCart().fill(ret, IFluidHandler.FluidAction.EXECUTE);
            }
            if (this.milkbuffer == 1000) {
                for (int i = 0; i < this.getInventorySize(); ++i) {
                    ItemStack bucket = this.getStack(i);
                    if (bucket.isEmpty() || bucket.getItem() != Items.BUCKET) continue;
                    ItemStack milk = new ItemStack((ItemLike)Items.MILK_BUCKET);
                    this.getCart().addItemToChest(milk);
                    if (milk.getCount() > 0) continue;
                    this.milkbuffer = 0;
                    ItemStack itemStack = bucket;
                    itemStack.shrink(1);
                    if (itemStack.getCount() > 0) continue;
                    this.setStack(i, ItemStack.EMPTY);
                }
            }
        }
    }

    private void generateMilk() {
        Entity rider;
        if (this.milkbuffer < 1000 && !this.getCart().getPassengers().isEmpty() && (rider = (Entity)this.getCart().getPassengers().get(0)) != null && rider instanceof Cow) {
            this.milkbuffer = Math.min(this.milkbuffer + 75, 1000);
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected int getInventoryWidth() {
        return 2;
    }

    @Override
    protected SlotStevesCarts getSlot(int slotId, int x, int y) {
        return new SlotMilker(this.getCart(), slotId, 8 + x * 18, 23 + y * 18);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    protected void save(CompoundTag tagCompound, int id, HolderLookup.Provider provider) {
        tagCompound.putShort(this.generateNBTName("Milk", id), (short)this.milkbuffer);
    }

    @Override
    protected void load(CompoundTag tagCompound, int id, HolderLookup.Provider provider) {
        this.milkbuffer = tagCompound.getShort(this.generateNBTName("Milk", id));
    }
}

