/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.items;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.api.IModuleItem;
import vswe.stevescarts.api.modules.data.ModuleData;
import vswe.stevescarts.init.ModItemData;

public class ItemCartModule
extends Item
implements IModuleItem {
    public ModuleData moduleData;

    public ItemCartModule(ModuleData moduleData) {
        super(new Item.Properties());
        this.moduleData = moduleData;
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        return Component.translatable((String)("item.stevescarts." + this.moduleData.getRawName()));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        if (this.moduleData != null) {
            this.moduleData.addInformation(list, ModItemData.getTagCopy(stack));
            if (flag.isAdvanced()) {
                list.add((Component)Component.literal((String)("ID " + String.valueOf(this.moduleData.getID()))));
            }
        }
        super.appendHoverText(stack, context, list, flag);
    }

    @Override
    public ModuleData getModuleData() {
        return this.moduleData;
    }

    @Override
    public void addExtraDataToCart(CompoundTag save, @Nonnull ItemStack module, int i) {
        CompoundTag tag = ModItemData.getTagCopy(module);
        if (tag.contains("Data")) {
            save.putByte("Data" + i, tag.getByte("Data"));
        } else {
            IModuleItem itemCartModule = (IModuleItem)module.getItem();
            ModuleData data = itemCartModule.getModuleData();
            if (data.isUsingExtraData()) {
                save.putByte("Data" + i, data.getDefaultExtraData());
            }
        }
    }
}

