/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.helpers;

import vswe.stevescarts.api.modules.ModuleBase;

public class DropDownMenuItem {
    private final String name;
    private final int imageID;
    private final VALUETYPE type;
    private boolean isLarge;
    private boolean subOpen;
    private byte value;
    private final Class<? extends ModuleBase> moduleClass;
    private final Class<? extends ModuleBase> excludedClass;
    private int multiCount;
    private int intMinValue;
    private int intMaxValue;

    public DropDownMenuItem(String name, int imageID, VALUETYPE type, Class<? extends ModuleBase> moduleClass) {
        this(name, imageID, type, moduleClass, null);
    }

    public DropDownMenuItem(String name, int imageID, VALUETYPE type, Class<? extends ModuleBase> moduleClass, Class<? extends ModuleBase> excludedClass) {
        this.name = name;
        this.imageID = imageID;
        this.type = type;
        this.moduleClass = moduleClass;
        this.excludedClass = excludedClass;
        this.isLarge = false;
        this.subOpen = false;
        this.value = 0;
    }

    public String getName() {
        return this.name;
    }

    public Class<? extends ModuleBase> getModuleClass() {
        return this.moduleClass;
    }

    public Class<? extends ModuleBase> getExcludedClass() {
        return this.excludedClass;
    }

    public int getImageID() {
        return this.imageID;
    }

    public boolean hasSubmenu() {
        return this.type != VALUETYPE.BOOL;
    }

    public boolean getIsSubMenuOpen() {
        return this.subOpen;
    }

    public void setIsSubMenuOpen(boolean val) {
        this.subOpen = val;
    }

    public boolean getIsLarge() {
        return this.isLarge;
    }

    public void setIsLarge(boolean val) {
        this.isLarge = val;
    }

    public int[] getRect(int menuX, int menuY, int id) {
        if (this.getIsLarge()) {
            return new int[]{menuX, menuY + id * 20, 130, 20};
        }
        return new int[]{menuX, menuY + id * 20, 54, 20};
    }

    public int[] getSubRect(int menuX, int menuY, int id) {
        if (this.getIsSubMenuOpen()) {
            return new int[]{menuX - 43, menuY + id * 20 + 2, 52, 16};
        }
        return new int[]{menuX, menuY + id * 20 + 2, 9, 16};
    }

    public VALUETYPE getType() {
        return this.type;
    }

    public boolean getBOOL() {
        return this.value != 0;
    }

    public void setBOOL(boolean val) {
        this.value = (byte)(val ? 1 : 0);
    }

    public int getINT() {
        return this.value;
    }

    public void setINT(int val) {
        if (val < this.intMinValue) {
            val = this.intMinValue;
        } else if (val > this.intMaxValue) {
            val = this.intMaxValue;
        }
        this.value = (byte)val;
    }

    public void setMULTIBOOL(byte val) {
        this.value = val;
    }

    public void setMULTIBOOL(int i, boolean val) {
        this.value = (byte)(this.value & ~(1 << i) | (val ? 1 : 0) << i);
    }

    public byte getMULTIBOOL() {
        return this.value;
    }

    public boolean getMULTIBOOL(int i) {
        return (this.value & 1 << i) != 0;
    }

    public void setMULTIBOOLCount(int val) {
        if (val > 4) {
            val = 4;
        } else if (val < 2) {
            val = 2;
        }
        this.multiCount = val;
    }

    public int getMULTIBOOLCount() {
        return this.multiCount;
    }

    public void setINTLimit(int min, int max) {
        this.intMinValue = min;
        this.intMaxValue = max;
        this.setINT(this.getINT());
    }

    public static enum VALUETYPE {
        BOOL,
        INT,
        MULTIBOOL;

    }
}

