/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks.tileentities;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vswe.stevescarts.blocks.tileentities.TileEntityBase;
import vswe.stevescarts.containers.ContainerActivator;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.ActivatorOption;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.init.ModBlocks;
import vswe.stevescarts.modules.addons.ModuleChunkLoader;
import vswe.stevescarts.modules.addons.ModuleInvisible;
import vswe.stevescarts.modules.addons.ModuleShield;
import vswe.stevescarts.modules.realtimers.ModuleCage;
import vswe.stevescarts.modules.workers.ModuleRemover;
import vswe.stevescarts.modules.workers.tools.ModuleDrill;

public class TileEntityActivator
extends TileEntityBase
implements MenuProvider {
    private ArrayList<ActivatorOption> options;

    public TileEntityActivator(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.MODULE_TOGGLER_TILE.get(), blockPos, blockState);
        this.loadOptions();
    }

    private void loadOptions() {
        this.options = new ArrayList<ActivatorOption>();
        this.options.add(new ActivatorOption(Localization.GUI.TOGGLER.OPTION_DRILL, ModuleDrill.class));
        this.options.add(new ActivatorOption(Localization.GUI.TOGGLER.OPTION_SHIELD, ModuleShield.class));
        this.options.add(new ActivatorOption(Localization.GUI.TOGGLER.OPTION_INVISIBILITY, ModuleInvisible.class));
        this.options.add(new ActivatorOption(Localization.GUI.TOGGLER.OPTION_CHUNK, ModuleChunkLoader.class));
        this.options.add(new ActivatorOption(Localization.GUI.TOGGLER.OPTION_CAGE_AUTO, ModuleCage.class, 0));
        this.options.add(new ActivatorOption(Localization.GUI.TOGGLER.OPTION_CAGE, ModuleCage.class, 1));
        this.options.add(new ActivatorOption(Localization.GUI.TOGGLER.OPTION_REMOVER, ModuleRemover.class));
    }

    public ArrayList<ActivatorOption> getOptions() {
        return this.options;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        for (ActivatorOption option : this.options) {
            option.setOption(compoundTag.getByte(option.getName()));
        }
    }

    public void saveAdditional(@NotNull CompoundTag compoundNBT, HolderLookup.Provider provider) {
        super.saveAdditional(compoundNBT, provider);
        for (ActivatorOption option : this.options) {
            compoundNBT.putByte(option.getName(), (byte)option.getOption());
        }
    }

    public void receivePacket(int id, byte[] data, @Nullable ServerPlayer sender) {
        if (id == 0) {
            boolean leftClick = (data[0] & 1) == 0;
            int optionId = (data[0] & 0xFFFFFFFE) >> 1;
            if (optionId >= 0 && optionId < this.options.size()) {
                this.options.get(optionId).changeOption(leftClick);
                this.setChanged();
            }
        }
    }

    public void handleCart(EntityMinecartModular cart, boolean isOrange) {
        for (ActivatorOption option : this.options) {
            if (option.isDisabled()) continue;
            cart.handleActivator(option, isOrange);
        }
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"container.activator");
    }

    @javax.annotation.Nullable
    public AbstractContainerMenu createMenu(int id, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
        return new ContainerActivator(id, playerInventory, this, new SimpleContainerData(0));
    }
}

