/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vswe.stevescarts.blocks.tileentities.TileEntityBase;

public abstract class BlockContainerBase
extends BaseEntityBlock {
    public BlockContainerBase(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return (level1, blockPos, blockState, t) -> {
            if (t instanceof TileEntityBase) {
                TileEntityBase tile = (TileEntityBase)t;
                tile.tick();
            }
        };
    }

    public void onRemove(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState2, boolean b) {
        BlockEntity blockEntity;
        if (blockState != blockState2 && level.getBlockEntity(blockPos) != null && (blockEntity = level.getBlockEntity(blockPos)) instanceof Container) {
            Container container = (Container)blockEntity;
            Containers.dropContents((Level)level, (BlockPos)blockPos, (Container)container);
        }
        super.onRemove(blockState, level, blockPos, blockState2, b);
    }
}

