/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.feature.trunkplacers;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.UpwardsBranchingTrunkPlacer;

public class CenteredUpwardsBranchingTrunkPlacer
extends UpwardsBranchingTrunkPlacer {
    public static final MapCodec<CenteredUpwardsBranchingTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> CenteredUpwardsBranchingTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)instance).and(instance.group((App)IntProvider.POSITIVE_CODEC.fieldOf("extra_branch_steps").forGetter(trunkPlacer -> trunkPlacer.extraBranchSteps), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("place_branch_per_log_probability").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.placeBranchPerLogProbability)), (App)IntProvider.NON_NEGATIVE_CODEC.fieldOf("extra_branch_length").forGetter(trunkPlacer -> trunkPlacer.extraBranchLength))).apply((Applicative)instance, CenteredUpwardsBranchingTrunkPlacer::new));
    private final IntProvider extraBranchSteps;
    private final float placeBranchPerLogProbability;
    private final IntProvider extraBranchLength;

    public CenteredUpwardsBranchingTrunkPlacer(int height, int randA, int randB, IntProvider extraBranchSteps, float placeBranchPerLogProbability, IntProvider extraBranchLength) {
        super(height, randA, randB, extraBranchSteps, placeBranchPerLogProbability, extraBranchLength, (HolderSet)HolderSet.direct((Holder[])new Holder[0]));
        this.extraBranchSteps = extraBranchSteps;
        this.placeBranchPerLogProbability = placeBranchPerLogProbability;
        this.extraBranchLength = extraBranchLength;
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)TreeRegistrator.CENTERED_UPWARDS_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, int pFreeTreeHeight, BlockPos pPos, TreeConfiguration pConfig) {
        int bleed;
        ArrayList list = Lists.newArrayList();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int i = bleed = pFreeTreeHeight / 3; i < pFreeTreeHeight - bleed; ++i) {
            int j = pPos.getY() + i;
            if (this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)mutableBlockPos.set(pPos.getX(), j, pPos.getZ()), pConfig) && i < pFreeTreeHeight - 1 && pRandom.nextFloat() < this.placeBranchPerLogProbability) {
                Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(pRandom);
                int k = this.extraBranchLength.sample(pRandom);
                int l = Math.max(0, k - this.extraBranchLength.sample(pRandom) - 1);
                int i1 = this.extraBranchSteps.sample(pRandom);
                this.placeBranch(pLevel, pBlockSetter, pRandom, pFreeTreeHeight, pConfig, list, mutableBlockPos, j, direction, l, i1);
            }
            if (i != pFreeTreeHeight - 1) continue;
            list.add(new FoliagePlacer.FoliageAttachment((BlockPos)mutableBlockPos.set(pPos.getX(), j + 1, pPos.getZ()), 0, false));
        }
        return list;
    }
}

