/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.datagen.compat;

import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivetrees.datagen.recipe.TreetapRecipeBuilder;
import cy.jdkdigital.productivetrees.registry.TreeFinder;
import cy.jdkdigital.productivetrees.registry.TreeObject;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.registry.WoodObject;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import java.util.concurrent.CompletableFuture;
import mekanism.api.datagen.recipe.builder.SawmillRecipeBuilder;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;

public class CompatRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    String[] RESIN_TREES = new String[]{"bull_pine", "douglas_fir", "cedar", "loblolly_pine", "sweetgum"};

    public CompatRecipeProvider(PackOutput gen, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(gen, pRegistries);
    }

    public String getName() {
        return "Productive Tress Compat Recipes";
    }

    protected void buildRecipes(RecipeOutput pRecipeOutput) {
        Block THERMAL_SAWMILL = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)"thermal:sawmill"));
        Block THERMAL_INSOLATOR = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)"thermal:insolator"));
        Block THERMAL_EXTRACTOR = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)"thermal:tree_extractor"));
        TreeFinder.trees.forEach((id, treeObject) -> {
            this.buildCorailWoodcutterRecipes((WoodObject)treeObject, pRecipeOutput);
            this.buildMekanismWoodcutterRecipes((WoodObject)treeObject, pRecipeOutput);
            if (treeObject.getStyle().hiveStyle() != null) {
                this.buildHiveRecipe("productivebees", (WoodObject)treeObject, pRecipeOutput);
                this.buildBoxRecipe("productivebees", (WoodObject)treeObject, pRecipeOutput);
            }
            this.buildBotanyPotsRecipe((TreeObject)treeObject, pRecipeOutput);
        });
        this.buildCompatSawmillRecipes(pRecipeOutput);
        TreetapRecipeBuilder.direct((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"socotra_dragon_log")), new ItemStack((ItemLike)TreeRegistrator.DRACAENA_SAP.get()), new ItemStack((ItemLike)Items.GLASS_BOTTLE), "#9d0300", 1200).save(pRecipeOutput.withConditions(new ICondition[]{this.modLoaded("treetap")}), ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"treetap/dracaena_sap"));
        TreetapRecipeBuilder.direct((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"sandalwood_log")), new ItemStack((ItemLike)TreeRegistrator.SANDALWOOD_OIL.get()), new ItemStack((ItemLike)Items.GLASS_BOTTLE), "#f1eda6", 2400).save(pRecipeOutput.withConditions(new ICondition[]{this.modLoaded("treetap")}), ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"treetap/sandalwood_oil"));
        TreetapRecipeBuilder.direct((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"sugar_maple_log")), new ItemStack((ItemLike)TreeRegistrator.MAPLE_SAP_BUCKET.get()), new FluidStack((Fluid)TreeRegistrator.MAPLE_SAP.get(), 1000), 2400).save(pRecipeOutput.withConditions(new ICondition[]{this.modLoaded("treetap")}), ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"treetap/maple_sap"));
        TreetapRecipeBuilder.direct((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"date_palm_log")), new ItemStack((ItemLike)TreeRegistrator.DATE_PALM_JUICE.get()), new ItemStack((ItemLike)Items.GLASS_BOTTLE), "#cd7408", 2400).save(pRecipeOutput.withConditions(new ICondition[]{this.modLoaded("treetap")}), ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"treetap/date_palm_juice"));
    }

    private void buildCompatSawmillRecipes(RecipeOutput consumer) {
    }

    private void buildMekanismWoodcutterRecipes(WoodObject treeObject, RecipeOutput consumer) {
        TagKey logTag = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)(treeObject.getId().getPath() + "_logs")));
        SawmillRecipeBuilder.sawing((ItemStackIngredient)ItemStackIngredient.of((SizedIngredient)SizedIngredient.of((TagKey)logTag, (int)1)), (ItemStack)new ItemStack((ItemLike)TreeUtil.getBlock(treeObject.getId(), "_planks"), 6)).build(consumer.withConditions(new ICondition[]{new ModLoadedCondition("mekanism")}), ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("mekanism/sawmill/" + treeObject.getId().getPath())));
    }

    private void buildCorailWoodcutterRecipes(WoodObject treeObject, RecipeOutput consumer) {
    }

    private void buildBotanyPotsRecipe(TreeObject treeObject, RecipeOutput consumer) {
    }

    public void buildHiveRecipe(String modid, WoodObject treeObject, RecipeOutput consumer) {
        Block hive = (Block)BuiltInRegistries.BLOCK.get(treeObject.getId().withPath(p -> "advanced_" + p + "_beehive"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)hive).group("hives").pattern("WWW").pattern("CHC").pattern("FWS").define(Character.valueOf('W'), Ingredient.of((ItemLike[])new ItemLike[]{TreeUtil.getBlock(treeObject.getId(), "_planks")})).define(Character.valueOf('H'), Ingredient.of((TagKey)ModTags.Common.HIVES)).define(Character.valueOf('C'), Ingredient.of((TagKey)ModTags.Common.HONEYCOMBS)).define(Character.valueOf('F'), Ingredient.of((TagKey)ModTags.Common.CAMPFIRES)).define(Character.valueOf('S'), Ingredient.of((TagKey)Tags.Items.TOOLS_SHEAR)).unlockedBy("has_hive", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BEEHIVE})).save(consumer.withConditions(new ICondition[]{this.modLoaded(modid)}), ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("hives/" + BuiltInRegistries.BLOCK.getKey((Object)hive).getPath().replace("advanced_", ""))));
        this.buildHiveResetRecipes(modid, hive, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("hives/" + BuiltInRegistries.BLOCK.getKey((Object)hive).getPath().replace("advanced_", "") + "_clear")), consumer);
    }

    public void buildBoxRecipe(String modid, WoodObject treeObject, RecipeOutput consumer) {
        Block box = (Block)BuiltInRegistries.BLOCK.get(treeObject.getId().withPath(p -> "expansion_box_" + p));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)box).group("expansion_boxes").pattern("WWW").pattern("WCW").pattern("WWW").define(Character.valueOf('W'), (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_planks")).define(Character.valueOf('C'), Ingredient.of((TagKey)ModTags.Common.HONEYCOMBS)).unlockedBy("has_hive", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BEEHIVE})).save(consumer.withConditions(new ICondition[]{this.modLoaded(modid)}), ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("expansion_boxes/" + BuiltInRegistries.BLOCK.getKey((Object)box).getPath())));
    }

    private void buildHiveResetRecipes(String modid, Block hive, ResourceLocation location, RecipeOutput consumer) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)hive).group("hives").unlockedBy("has_hive", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BEEHIVE})).requires((ItemLike)hive).save(consumer.withConditions(new ICondition[]{this.modLoaded(modid)}), location);
    }
}

