/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.logs_analyser;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.KnownCrashReason;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.KnownCrashReasonMessage;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.Log;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogType;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogsList;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.advanced.ConnectorIncompatibleFabricMods;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.advanced.MixinApply;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.advanced.ModuleFind;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.advanced.ModuleResolution;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.codex.CodexAnalysis;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.codex.ErroringEntity;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.hs_err.AlLibAlcCleanup;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.hs_err.Atio6axx;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.hs_err.GPUDriverIssue;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.hs_err.Ig7icd64;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.hs_err.InsufficientMemory;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.hs_err.JavaTooHigh;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.hs_err.Jemalloc;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.hs_err.Jvm;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.hs_err.LibGLFWDotSo;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.hs_err.LibOpenALDotSo;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.hs_err.MacJDK;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.hs_err.MacOSIncompatibleShaderDriverIssue;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.hs_err.Nvoglv64;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.hs_err.nglMultiDrawElementsBaseVertex;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log.Create6Addons;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log.CtovWithoutLithostitched;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log.CurseForgeCorrupted;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log.DiskSpaceEnded;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log.DuplicatedMods;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log.EpicFightAddons;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log.FeatureOrderCycle;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log.GroovyModLoaderIPv6;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log.KubeJSDataPack;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log.LanguageProviderMismatch;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log.LegacyTooManyIds;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log.MissingEmbeddiumForOculus;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log.MissingIndium;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log.MissingUnsupportedDependencies;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log.ModernFixWatchDog;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log.NeoForgeVersion1_20_1;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log.Optifine;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log.OutOfMemoryError;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log.ResourceLocationException;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log.Rubidium;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log.ServerConfigCorrupted;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log.UnsupportedClassVersion;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log.UsedByAnotherProcess;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log.Version1_21;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.win_event.WasClosedByWindows;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class LogAnalyser {
    private static final List<KnownCrashReason> registeredReasons = new ArrayList<KnownCrashReason>();
    private static final List<CodexAnalysis> registeredCodexReasons = new ArrayList<CodexAnalysis>();
    private static boolean reasonsRegistered = false;
    public static final HashSet<LogType> CodexSupportedLogTypes = new HashSet<LogType>(){
        {
            this.add(LogType.LOG);
            this.add(LogType.CRASH_REPORT);
        }
    };

    public static void registerKnownCrashReason(KnownCrashReason reason) {
        registeredReasons.add(reason);
    }

    public static void registerCodexKnownCrashReason(CodexAnalysis reason) {
        registeredCodexReasons.add(reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void analyseLogs() {
        if (!CrashAssistantConfig.getBoolean((String)"analysis.enabled")) {
            return;
        }
        long startTime = System.currentTimeMillis();
        LogAnalyser.registerReasons();
        LogAnalyser.readLogsNeededForAnalysis();
        Class<KnownCrashReasonMessage> clazz = KnownCrashReasonMessage.class;
        synchronized (KnownCrashReasonMessage.class) {
            ExecutorService pool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            HashSet<String> disabledCrashReasons = new HashSet<String>(CrashAssistantConfig.getBlacklistedAnalysis());
            for (Log log : LogsList.getLogs()) {
                LogAnalyser.analyseLog(log, disabledCrashReasons, pool);
            }
            pool.shutdown();
            try {
                if (!pool.awaitTermination(5L, TimeUnit.MINUTES)) {
                    pool.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                CrashAssistantApp.LOGGER.error("Interrupted while awaiting termination of analysis tasks", (Throwable)e);
            }
            CrashAssistantApp.LOGGER.info("Analysis finished in {} ms", (Object)(System.currentTimeMillis() - startTime));
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void readLogsNeededForAnalysis() {
        if (!CrashAssistantConfig.getBoolean((String)"analysis.enabled")) {
            return;
        }
        long startTime = System.currentTimeMillis();
        LogAnalyser.registerReasons();
        Class<KnownCrashReasonMessage> clazz = KnownCrashReasonMessage.class;
        synchronized (KnownCrashReasonMessage.class) {
            ExecutorService pool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            for (Log log : LogsList.getLogs()) {
                if (registeredReasons.stream().noneMatch(reason -> reason.getLogTypes().contains((Object)log.getType()))) continue;
                pool.submit(() -> log.getReader().readLogFileSafe());
            }
            pool.shutdown();
            try {
                if (!pool.awaitTermination(5L, TimeUnit.MINUTES)) {
                    pool.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                CrashAssistantApp.LOGGER.error("Interrupted while awaiting termination of reading tasks", (Throwable)e);
            }
            for (Log log : LogsList.getLogs()) {
                log.getReader().destroyAllLinesCache();
            }
            CrashAssistantApp.LOGGER.info("Reading finished in {} ms", (Object)(System.currentTimeMillis() - startTime));
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    private static synchronized void analyseLog(Log log, HashSet<String> disabledCrashReasons, ExecutorService pool) {
        if (log.isAnalysed()) {
            return;
        }
        List registeredReasonsForThisLog = registeredReasons.stream().filter(reason -> reason.getLogTypes().contains((Object)log.getType()) && !disabledCrashReasons.contains(reason.getClass().getSimpleName())).collect(Collectors.toList());
        for (KnownCrashReason reason2 : registeredReasonsForThisLog) {
            pool.submit(() -> {
                if (reason2.matches(log)) {
                    ExecutorService executorService = pool;
                    synchronized (executorService) {
                        KnownCrashReasonMessage.addCrashReasonMessage(new KnownCrashReasonMessage(log, reason2));
                    }
                }
            });
        }
        log.setAnalysed(true);
    }

    public static synchronized String analyseCodexMessage(String message) {
        LogAnalyser.registerReasons();
        for (CodexAnalysis reason : registeredCodexReasons) {
            if (!reason.matches(message)) continue;
            return reason.getMessage();
        }
        return "";
    }

    public static synchronized void registerReasons() {
        if (reasonsRegistered) {
            return;
        }
        LogAnalyser.registerKnownCrashReason(new ConnectorIncompatibleFabricMods());
        LogAnalyser.registerKnownCrashReason(new MixinApply());
        LogAnalyser.registerKnownCrashReason(new ModuleFind());
        LogAnalyser.registerKnownCrashReason(new ModuleResolution());
        LogAnalyser.registerKnownCrashReason(new AlLibAlcCleanup());
        LogAnalyser.registerKnownCrashReason(new Atio6axx());
        LogAnalyser.registerKnownCrashReason(new GPUDriverIssue());
        LogAnalyser.registerKnownCrashReason(new Ig7icd64());
        LogAnalyser.registerKnownCrashReason(new InsufficientMemory());
        LogAnalyser.registerKnownCrashReason(new JavaTooHigh());
        LogAnalyser.registerKnownCrashReason(new Jemalloc());
        LogAnalyser.registerKnownCrashReason(new Jvm());
        LogAnalyser.registerKnownCrashReason(new LibGLFWDotSo());
        LogAnalyser.registerKnownCrashReason(new LibOpenALDotSo());
        LogAnalyser.registerKnownCrashReason(new MacJDK());
        LogAnalyser.registerKnownCrashReason(new MacOSIncompatibleShaderDriverIssue());
        LogAnalyser.registerKnownCrashReason(new nglMultiDrawElementsBaseVertex());
        LogAnalyser.registerKnownCrashReason(new Nvoglv64());
        LogAnalyser.registerKnownCrashReason(new Create6Addons());
        LogAnalyser.registerKnownCrashReason(new CtovWithoutLithostitched());
        LogAnalyser.registerKnownCrashReason(new CurseForgeCorrupted());
        LogAnalyser.registerKnownCrashReason(new DiskSpaceEnded());
        LogAnalyser.registerKnownCrashReason(new DuplicatedMods());
        LogAnalyser.registerKnownCrashReason(new EpicFightAddons());
        LogAnalyser.registerKnownCrashReason(new FeatureOrderCycle());
        LogAnalyser.registerKnownCrashReason(new GroovyModLoaderIPv6());
        LogAnalyser.registerKnownCrashReason(new KubeJSDataPack());
        LogAnalyser.registerKnownCrashReason(new LanguageProviderMismatch());
        LogAnalyser.registerKnownCrashReason(new LegacyTooManyIds());
        LogAnalyser.registerKnownCrashReason(new MissingEmbeddiumForOculus());
        LogAnalyser.registerKnownCrashReason(new MissingIndium());
        LogAnalyser.registerKnownCrashReason(new MissingUnsupportedDependencies());
        LogAnalyser.registerKnownCrashReason(new ModernFixWatchDog());
        LogAnalyser.registerKnownCrashReason(new NeoForgeVersion1_20_1());
        LogAnalyser.registerKnownCrashReason(new Optifine());
        LogAnalyser.registerKnownCrashReason(new OutOfMemoryError());
        LogAnalyser.registerKnownCrashReason(new ResourceLocationException());
        LogAnalyser.registerKnownCrashReason(new Rubidium());
        LogAnalyser.registerKnownCrashReason(new ServerConfigCorrupted());
        LogAnalyser.registerKnownCrashReason(new UnsupportedClassVersion());
        LogAnalyser.registerKnownCrashReason(new UsedByAnotherProcess());
        LogAnalyser.registerKnownCrashReason(new Version1_21());
        LogAnalyser.registerKnownCrashReason(new WasClosedByWindows());
        LogAnalyser.registerCodexKnownCrashReason(new ErroringEntity());
        reasonsRegistered = true;
    }
}

