/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.gui;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.exceptions.DeclinedException;
import dev.kostromdan.mods.crash_assistant.app.exceptions.UploadException;
import dev.kostromdan.mods.crash_assistant.app.gui.CrashAssistantGUI;
import dev.kostromdan.mods.crash_assistant.app.gui.FileListPanel;
import dev.kostromdan.mods.crash_assistant.app.gui.FilePanel;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.KnownCrashReason;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.KnownCrashReasonMessage;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.Log;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogType;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogsList;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log.OutOfMemoryError;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.hs_err_parser.HsErrParser;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.hs_err_parser.HsErrParsingResult;
import dev.kostromdan.mods.crash_assistant.app.utils.ClipboardUtils;
import dev.kostromdan.mods.crash_assistant.app.utils.FileUtils;
import dev.kostromdan.mods.crash_assistant.app.utils.IntelCorruptedProcessorChecker;
import dev.kostromdan.mods.crash_assistant.app.utils.TrustedDomainsHelper;
import dev.kostromdan.mods.crash_assistant.app.utils.uploading_apis.ApiProvider;
import dev.kostromdan.mods.crash_assistant.app.utils.uploading_apis.UploadLogResponse;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantConfig;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LinksProvider;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.AnsiColor;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.Mod;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListDiff;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListDiffStringBuilder;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListUtils;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;

public class ControlPanel {
    public static boolean stopMovingToTop = false;
    public static boolean uploadButtonsActivated = false;
    private static boolean uploadAllButtonWarningShown = false;
    private static JPanel panel;
    public static JDialog dialog;
    private final FileListPanel fileListPanel;
    public final JButton uploadAllButton;
    public final JButton requestHelpButton;
    private String generatedMsg = null;
    private JLabel modListLabel;
    private JButton showModListButton;

    public ControlPanel(final FileListPanel fileListPanel) {
        this.fileListPanel = fileListPanel;
        panel = new JPanel(new BorderLayout());
        JPanel labelButtonPanel = new JPanel();
        labelButtonPanel.setLayout(new BoxLayout(labelButtonPanel, 0));
        if (CrashAssistantConfig.getBoolean((String)"modpack_modlist.enabled")) {
            this.modListLabel = new JLabel(LanguageProvider.get((String)"gui.modlist_loading"));
            this.modListLabel.setMaximumSize(this.modListLabel.getPreferredSize());
            this.showModListButton = new JButton(LanguageProvider.get((String)"gui.show_modlist_diff_button"));
            this.showModListButton.setEnabled(false);
            this.showModListButton.setToolTipText(LanguageProvider.get((String)"gui.modlist_loading"));
            this.showModListButton.addActionListener(e -> this.showModList());
            this.showModListButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.showModListButton.getPreferredSize().height));
            labelButtonPanel.add(this.modListLabel);
            labelButtonPanel.add(Box.createHorizontalStrut(10));
            labelButtonPanel.add(this.showModListButton);
            labelButtonPanel.add(Box.createHorizontalGlue());
            labelButtonPanel.setBorder(BorderFactory.createTitledBorder(ModListDiff.getFirstString((boolean)false, (boolean)false, null)));
            panel.add((Component)labelButtonPanel, "North");
        }
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.uploadAllButton = new JButton(LanguageProvider.get((String)"gui.upload_all_button"));
        this.customizeButton(this.uploadAllButton, "upload_all");
        this.uploadAllButton.setText(LanguageProvider.get((String)"gui.upload_all_button"));
        this.uploadAllButton.addActionListener(e -> this.uploadAllFiles());
        this.uploadAllButton.setEnabled(false);
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(() -> {
                    double lestTime = (double)(CrashAssistantApp.terminatedProcessesLocationEndTime - Instant.now().toEpochMilli() + 100L) / 1000.0;
                    ControlPanel.this.uploadAllButton.setText(LanguageProvider.get((String)"gui.upload_all_button_delayed").replaceAll("\\$SECONDS\\$", String.format("%.3f", lestTime)));
                    if (Instant.now().toEpochMilli() >= CrashAssistantApp.terminatedProcessesLocationEndTime + 100L) {
                        ControlPanel.this.uploadAllButton.setText(LanguageProvider.get((String)"gui.upload_all_button"));
                        ControlPanel.this.uploadAllButton.setEnabled(true);
                        CrashAssistantGUI.resize();
                        Timer enableButtonsTimer = new Timer();
                        enableButtonsTimer.schedule(new TimerTask(this){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Class<ControlPanel> clazz = ControlPanel.class;
                                synchronized (ControlPanel.class) {
                                    uploadButtonsActivated = true;
                                    // ** MonitorExit[var1_1] (shouldn't be in output)
                                    SwingUtilities.invokeLater(() -> {
                                        for (FilePanel panel : fileListPanel2.filePanelList) {
                                            panel.setUploadButtonEnabled(true);
                                            panel.setWaiting(false);
                                        }
                                    });
                                    return;
                                }
                            }
                        }, 1000L);
                        this.cancel();
                    }
                });
            }
        }, 0L, 21L);
        gbc.gridy = 0;
        bottomPanel.add((Component)this.uploadAllButton, gbc);
        this.requestHelpButton = new JButton(LanguageProvider.get((String)"gui.request_help_button"));
        this.customizeButton(this.requestHelpButton, "request_help");
        this.requestHelpButton.addActionListener(e -> this.requestHelp());
        this.requestHelpButton.setToolTipText(PlatformHelp.getActualHelpLink());
        gbc.gridy = 1;
        bottomPanel.add((Component)this.requestHelpButton, gbc);
        panel.add((Component)bottomPanel, "South");
    }

    public void customizeButton(JButton button, String button_id) {
        button.setFont(button.getFont().deriveFont(1, CrashAssistantConfig.getInteger((String)("gui_customisation." + button_id + "_button_font_size"))));
        button.setForeground(ControlPanel.deserializeColor((String)CrashAssistantConfig.get((String)("gui_customisation." + button_id + "_button_foreground_color")), button.getForeground()));
    }

    public static Color deserializeColor(String colorString, Color fallbackColor) {
        if (colorString.equalsIgnoreCase("default")) {
            return fallbackColor;
        }
        try {
            int[] rgb = Arrays.stream(colorString.split("_")).mapToInt(Integer::parseInt).toArray();
            if (rgb.length != 3) {
                throw new NumberFormatException();
            }
            return new Color(rgb[0], rgb[1], rgb[2]);
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.error("Failed to deserialize color: " + colorString + "\nExpected 3 numbers separated by underscores.", (Throwable)e);
            return fallbackColor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateModListInfo() {
        ModListDiff modListDiff = ModListDiff.getDiff((boolean)true);
        if (!CrashAssistantConfig.getBoolean((String)"modpack_modlist.enabled")) {
            return;
        }
        if (CrashAssistantConfig.getBoolean((String)"modpack_modlist.add_modlist_txt_as_log")) {
            Path modListTxtPath = Paths.get("logs", "modlist.txt");
            try {
                Mod.writeModlistTxt((Path)modListTxtPath, (Collection)modListDiff.getCurrentMods());
                Class<KnownCrashReasonMessage> clazz = KnownCrashReasonMessage.class;
                synchronized (KnownCrashReasonMessage.class) {
                    LogsList.addIfExistsAndModified(new Log(LogType.MOD_LIST, modListTxtPath), false, false);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                CrashAssistantApp.LOGGER.error("Error while saving modlist.txt", (Throwable)e);
            }
        }
        {
            Object labelMsg = "<html><div style='white-space:nowrap;'>";
            if (modListDiff.isEmpty()) {
                labelMsg = (String)labelMsg + LanguageProvider.get((String)"gui.modlist_not_changed_label") + ":";
                this.showModListButton.setEnabled(false);
                this.showModListButton.setToolTipText(LanguageProvider.get((String)"gui.modlist_not_changed_label"));
            } else {
                labelMsg = (String)labelMsg + LanguageProvider.get((String)"gui.modlist_changed_label").replace("$ADDED_MODS_COUNT$", "<span style='color:green;'>" + modListDiff.getAddedMods().size() + "</span>").replace("$REMOVED_MODS_COUNT$", "<span style='color:red;'>" + modListDiff.getRemovedMods().size() + "</span>").replace("$UPDATED_MODS_COUNT$", "<span style='color:blue;'>" + modListDiff.getUpdatedMods().size() + "</span>");
                this.showModListButton.setEnabled(true);
                this.showModListButton.setToolTipText(null);
            }
            labelMsg = (String)labelMsg + "</div></html>";
            this.modListLabel.setText((String)labelMsg);
            this.modListLabel.setMaximumSize(this.modListLabel.getPreferredSize());
            new Thread(() -> {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Class<KnownCrashReasonMessage> clazz = KnownCrashReasonMessage.class;
                synchronized (KnownCrashReasonMessage.class) {
                    SwingUtilities.invokeLater(CrashAssistantGUI::addMissingLogs);
                    // ** MonitorExit[var0_1] (shouldn't be in output)
                    return;
                }
            }).start();
            return;
        }
    }

    public JPanel getPanel() {
        return panel;
    }

    public void requestHelp() {
        try {
            stopMovingToTop = true;
            ControlPanel.validateIsDomainTrustedAndOpenInBrowser(PlatformHelp.getActualHelpLink());
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.error("Failed to open help_link in browser: ", (Throwable)e);
        }
    }

    public static void validateIsDomainTrustedAndOpenInBrowser(String link) throws URISyntaxException, IOException {
        int result;
        URI uri = new URI(link);
        if (TrustedDomainsHelper.isTrustedTopDomain(uri)) {
            Desktop.getDesktop().browse(new URI(link));
            return;
        }
        Object creatorWarning = "";
        if (CrashAssistantConfig.getModpackCreators().contains(ModListUtils.getCurrentUsername())) {
            creatorWarning = "\n\n<b>The next text is seen only by modpack creators</b>:\nIf you think your domain(" + TrustedDomainsHelper.getTopDomainName(uri) + ") should be in trusted domains,\nplease contact us on <a href =https://github.com/KostromDan/Crash-Assistant/blob/1.19.2-1.20.1/app/src/main/java/dev/kostromdan/mods/crash_assistant/app/utils/TrustedDomainsHelper.java>GitHub</a>.";
        }
        if ((result = JOptionPane.showConfirmDialog(null, CrashAssistantGUI.getEditorPane(LanguageProvider.get((String)"gui.untrusted_domain_question") + "\n<a href =" + link + ">" + link + "</a>" + (String)creatorWarning, false), LanguageProvider.get((String)"gui.untrusted_domain_title"), 0, 2)) != 0) {
            return;
        }
        Desktop.getDesktop().browse(new URI(link));
    }

    private void showModList() {
        stopMovingToTop = true;
        JTextPane textPane = new JTextPane();
        textPane.setEditable(false);
        textPane.setContentType("text/html");
        ModListDiff modListDiff = ModListDiff.getDiff((boolean)true);
        textPane.setText(modListDiff.generateDiffMsg(false).toHtml());
        textPane.setCaretPosition(0);
        JScrollPane scrollPane = new JScrollPane(textPane);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setPreferredSize(new Dimension(Math.min(scrollPane.getPreferredSize().width + 15, 700), 300));
        JOptionPane.showMessageDialog(null, scrollPane, LanguageProvider.get((String)"gui.modlist_diff_dialog_name"), 1);
    }

    private void uploadAllFiles() {
        stopMovingToTop = true;
        this.uploadAllButton.setEnabled(false);
        new Thread(() -> {
            int n;
            if (this.generatedMsg == null) {
                this.uploadAllButton.setText(LanguageProvider.get((String)"gui.uploading"));
                for (FilePanel filePanel : this.fileListPanel.filePanelList) {
                    while (!filePanel.isUploadButtonEnabled() && (filePanel.getLastError() != null || filePanel.isWaiting())) {
                        if (filePanel.isWaiting()) {
                            filePanel.setWaiting(false);
                            filePanel.setUploadButtonEnabled(true);
                            continue;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    filePanel.uploadFile(false);
                }
                block6: while (!this.fileListPanel.filePanelList.isEmpty()) {
                    int successCounter = 0;
                    for (FilePanel filePanel : this.fileListPanel.filePanelList) {
                        Log log = filePanel.getLog();
                        if (!(filePanel.getLastError() == null || filePanel.getLastError() instanceof UploadException && filePanel.getLastError().getMessage().startsWith("Crash Assistant log"))) {
                            Object message = LanguageProvider.get((String)"gui.failed_to_upload_file") + " \"" + String.valueOf(log.getPath()) + "\": " + String.valueOf(filePanel.getLastError());
                            if (filePanel.getLastError() instanceof DeclinedException) {
                                message = filePanel.getLastError().getMessage();
                            }
                            JOptionPane.showMessageDialog(panel, message, LanguageProvider.get((String)"gui.failed_to_upload_file") + "!", 0);
                            this.uploadAllButton.setText(LanguageProvider.get((String)"gui.error"));
                            CrashAssistantGUI.highlightButton(this.uploadAllButton, new Color(255, 100, 100), 2600L);
                            new Timer().schedule(new TimerTask(){

                                @Override
                                public void run() {
                                    ControlPanel.this.uploadAllButton.setText(LanguageProvider.get((String)"gui.upload_all_button"));
                                    ControlPanel.this.uploadAllButton.setEnabled(true);
                                }
                            }, 3000L);
                            return;
                        }
                        if (log.getLinkToUploadedFirstLines() != null) {
                            ++successCounter;
                        }
                        if (successCounter == this.fileListPanel.filePanelList.size()) break block6;
                        try {
                            TimeUnit.MILLISECONDS.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                this.generateMsg();
            }
            String warningMsg = CrashAssistantConfig.get((String)"generated_message.warning_after_upload_all_button_press", (boolean)true);
            ClipboardUtils.copy(this.generatedMsg);
            int n2 = 3000;
            if (!uploadAllButtonWarningShown && !warningMsg.isEmpty()) {
                n = 4500;
                ControlPanel.showUploadAllButtonWarning(warningMsg);
                ClipboardUtils.copy(this.generatedMsg);
            }
            this.uploadAllButton.setText(LanguageProvider.get((String)"gui.copied"));
            CrashAssistantGUI.highlightButton(this.uploadAllButton, new Color(100, 255, 100), n - 400);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    ControlPanel.this.uploadAllButton.setText(LanguageProvider.get((String)"gui.upload_all_finished_button"));
                    ControlPanel.this.uploadAllButton.setEnabled(true);
                }
            }, n);
        }).start();
    }

    public void generateMsg() {
        Optional<HsErrParsingResult> optional;
        StringBuilder sb = new StringBuilder();
        sb.append(CrashAssistantGUI.getTitleCrashedText(true)).append(LanguageProvider.getMsgLang((String)"msg.crashed").replace("$UPLOAD_TO$", CrashAssistantGUI.getUploadToLink())).append("\n");
        if (!CrashAssistantConfig.get((String)"generated_message.text_under_crashed").toString().isEmpty()) {
            sb.append(CrashAssistantConfig.get((String)"generated_message.text_under_crashed", (boolean)true)).append("\n");
        }
        boolean kubeJSPosted = false;
        ArrayList<Log> kubeJSPanelList = new ArrayList<Log>();
        for (FilePanel filePanel : this.fileListPanel.filePanelList) {
            Log log = filePanel.getLog();
            if (!log.getName().startsWith("KubeJS: ")) continue;
            if (log.getLinkToUploadedLastLines() != null) {
                kubeJSPanelList.clear();
                break;
            }
            kubeJSPanelList.add(log);
        }
        ArrayList<Object> logs = new ArrayList<Object>();
        for (FilePanel panel : this.fileListPanel.filePanelList) {
            Log log = panel.getLog();
            if (log.getName().startsWith("KubeJS: ")) {
                if (kubeJSPosted) continue;
                if (!kubeJSPanelList.isEmpty()) {
                    kubeJSPosted = true;
                    logs.add("KubeJS: " + kubeJSPanelList.stream().map(kubeJSLog -> "[" + kubeJSLog.getFileName() + "](<" + kubeJSLog.getLinkToUploadedFirstLines() + ">)").collect(Collectors.joining(" / ")));
                    continue;
                }
            }
            if (log.getType() == LogType.CRASH_ASSISTANT && !KnownCrashReasonMessage.getAllMessages().isEmpty() && !CrashAssistantConfig.getBoolean((String)"generated_message.put_analysis_result_to_message")) {
                logs.add(ControlPanel.formatSingleLogMessage(log) + LanguageProvider.getMsgLang((String)"msg.found_potential_crash_reason").replaceAll("\\$COUNT\\$", Integer.toString(KnownCrashReasonMessage.getUniqueMessages().size())));
                continue;
            }
            if (log.getLinkToUploadedLastLines() == null) {
                logs.add(ControlPanel.formatSingleLogMessage(log));
                continue;
            }
            logs.add(panel.getMessageWithBothLinks(true));
        }
        if (!LogsList.isLauncherLogExist() && FileUtils.isCurseForgeEnv()) {
            logs.add(LanguageProvider.getMsgLang((String)"msg.skip_launcher"));
        }
        try {
            if (CrashAssistantConfig.getBoolean((String)"generated_message.intel_corrupted_notification") && IntelCorruptedProcessorChecker.isAffectedProcessor()) {
                String string = IntelCorruptedProcessorChecker.extractModel();
                logs.add("[" + string + LanguageProvider.getMsgLang((String)"msg.intel_corrupted_notification") + "](<" + LinksProvider.INTEL_CHIP_BUG_FAQ.getLink() + ">)");
            }
        }
        catch (Exception exception) {
            CrashAssistantApp.LOGGER.error("Error while checking IntelCorruptedProcessor", (Throwable)exception);
        }
        sb.append(ModListDiff.getFilePrefix());
        if (CrashAssistantConfig.getBoolean((String)"generated_message.one_line_logs")) {
            sb.append(String.join((CharSequence)"   |   ", logs));
        } else {
            sb.append(String.join((CharSequence)("\n" + ModListDiff.getFilePrefix()), logs));
        }
        sb.append("\n");
        if (CrashAssistantConfig.getBoolean((String)"generated_message.put_problematic_frame_to_message") && (optional = HsErrParser.getCachedHsErrParsingResult()).isPresent() && optional.get().getProblematicFrameFullString().isPresent()) {
            sb.append("```java\n");
            sb.append(optional.get().getProblematicFrameFullString().get());
            sb.append("\n```");
        }
        if (!KnownCrashReasonMessage.getAllMessages().isEmpty() && CrashAssistantConfig.getBoolean((String)"generated_message.put_analysis_result_to_message")) {
            ModListDiffStringBuilder modListDiffStringBuilder = new ModListDiffStringBuilder();
            HashMap<KnownCrashReason, List<Log>> reasonToLogs = KnownCrashReasonMessage.getUniqueMessages();
            if (!sb.toString().endsWith("\n")) {
                sb.append("\n");
            }
            modListDiffStringBuilder.append(LanguageProvider.getMsgLang((String)"msg.found_analysis_1"), false);
            modListDiffStringBuilder.append(Integer.toString(reasonToLogs.size()), "blue", false);
            modListDiffStringBuilder.append(LanguageProvider.getMsgLang((String)"msg.found_analysis_2"));
            for (Map.Entry entry : reasonToLogs.entrySet()) {
                modListDiffStringBuilder.append(((KnownCrashReason)entry.getKey()).getClass().getSimpleName(), "blue", false);
                modListDiffStringBuilder.append(LanguageProvider.getMsgLang((String)"msg.found_analysis_in") + ((List)entry.getValue()).stream().map(Log::getFileName).collect(Collectors.joining(", ")));
                if (!(entry.getKey() instanceof OutOfMemoryError)) continue;
                modListDiffStringBuilder.append(LanguageProvider.getMsgLang((String)"warnings_common.memory_args").replace("$CURRENT_MEMORY_ARGS$", ""), false);
                modListDiffStringBuilder.append("Xms: ", false);
                modListDiffStringBuilder.append(CrashAssistantApp.parentXms, "red", false);
                modListDiffStringBuilder.append(", Xmx: ", false);
                modListDiffStringBuilder.append(CrashAssistantApp.parentXmx, "green", false);
                modListDiffStringBuilder.append(", systemRAM: ", false);
                modListDiffStringBuilder.append(CrashAssistantApp.systemRAM, "blue");
                modListDiffStringBuilder.append("");
            }
            sb.append(modListDiffStringBuilder.toAnsi(true).trim());
        }
        if (CrashAssistantConfig.getBoolean((String)"modpack_modlist.enabled")) {
            sb.append("\n");
            ModListDiff modListDiff = ModListDiff.getDiff((boolean)true);
            ModListDiffStringBuilder diffStringBuilder = modListDiff.generateDiffMsg(true);
            String modlistDIff = diffStringBuilder.toText();
            String string = diffStringBuilder.toAnsi();
            int lineCount = modlistDIff.length() - modlistDIff.replace("\n", "").length();
            if (sb.length() + string.length() >= 1650 || lineCount > 15 || PlatformHelp.isLinkDefault() && PlatformHelp.platform == PlatformHelp.FORGE && lineCount > 3) {
                try {
                    String link = ControlPanel.uploadModlistDiff(modlistDIff);
                    sb.append(ModListDiff.getFilePrefix());
                    sb.append(ModListDiff.getFirstString((boolean)true, (boolean)true, (String)link));
                    sb.append("\n```");
                    if (CrashAssistantConfig.getBoolean((String)"generated_message.color_message")) {
                        sb.append("ansi\n");
                        sb.append(LanguageProvider.getMsgLang((String)"gui.modlist_changed_label_msg").replace("$ADDED_MODS_COUNT$", AnsiColor.GREEN.getColorPrefix() + modListDiff.getAddedMods().size() + "\u001b[0m").replace("$REMOVED_MODS_COUNT$", AnsiColor.RED.getColorPrefix() + modListDiff.getRemovedMods().size() + "\u001b[0m").replace("$UPDATED_MODS_COUNT$", AnsiColor.BLUE.getColorPrefix() + modListDiff.getUpdatedMods().size() + "\u001b[0m"));
                    } else {
                        sb.append("\n");
                        sb.append(LanguageProvider.getMsgLang((String)"gui.modlist_changed_label_msg").replace("$ADDED_MODS_COUNT$", Integer.toString(modListDiff.getAddedMods().size())).replace("$REMOVED_MODS_COUNT$", Integer.toString(modListDiff.getRemovedMods().size())).replace("$UPDATED_MODS_COUNT$", Integer.toString(modListDiff.getUpdatedMods().size())));
                    }
                    sb.append("\n```");
                }
                catch (UploadException | InterruptedException | ExecutionException e) {
                    CrashAssistantApp.LOGGER.error("Failed to upload modlist diff message", (Throwable)e);
                    sb.append(string);
                }
            } else {
                sb.append(string);
            }
        }
        this.generatedMsg = sb.toString();
    }

    public static String formatSingleLogMessage(Log log) {
        return log.getParentName() + "[" + log.getFileName() + "](<" + log.getLinkToUploadedFirstLines() + ">)";
    }

    public static void showUploadAllButtonWarning(String warningMsg) {
        JEditorPane commentPane = CrashAssistantGUI.getEditorPane(warningMsg, false);
        JOptionPane optionPane = new JOptionPane(commentPane, 1, -1);
        dialog = optionPane.createDialog(panel, LanguageProvider.get((String)"gui.upload_all_button_warning_title"));
        uploadAllButtonWarningShown = true;
        dialog.setVisible(true);
    }

    public static String uploadModlistDiff(String diff) throws ExecutionException, InterruptedException, UploadException {
        UploadLogResponse response = ApiProvider.getMcLogsClient().uploadLog(diff).get();
        response.setClient(ApiProvider.getMcLogsClient());
        if (response.isSuccess()) {
            return CrashAssistantGUI.transformLink(response.getUrl());
        }
        throw new UploadException("An error occurred when uploading modlist diff: " + response.getError());
    }

    public static String getCurrentMemoryArgsString() {
        return "Xms: " + CrashAssistantApp.parentXms + ", Xmx: " + CrashAssistantApp.parentXmx;
    }

    public static String getCurrentMemoryAgsMessage() {
        return LanguageProvider.getMsgLang((String)"warnings_common.memory_args").replace("$CURRENT_MEMORY_ARGS$", ControlPanel.getCurrentMemoryArgsString());
    }
}

