/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entity.potion;

import java.util.List;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.network.PacketDistributor;
import reliquary.network.SpawnThrownPotionImpactParticlesPayload;
import reliquary.util.LogHelper;

public abstract class ThrownPotionBase
extends ThrowableProjectile
implements ItemSupplier {
    private static final EntityDataAccessor<ItemStack> ITEM = SynchedEntityData.defineId(ThrownPotionBase.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);

    <T extends ThrownPotionBase> ThrownPotionBase(EntityType<T> entityType, Level level, ItemStack thrownStack) {
        super(entityType, level);
        this.setItem(thrownStack);
    }

    <T extends ThrownPotionBase> ThrownPotionBase(EntityType<T> entityType, Level level, Player player, ItemStack thrownStack) {
        super(entityType, (LivingEntity)player, level);
        this.setItem(thrownStack);
    }

    <T extends ThrownPotionBase> ThrownPotionBase(EntityType<T> entityType, Level level, double x, double y, double z, ItemStack thrownStack) {
        super(entityType, x, y, z, level);
        this.setItem(thrownStack);
    }

    private void setItem(ItemStack thrownStack) {
        this.entityData.set(ITEM, (Object)thrownStack);
    }

    protected double getDefaultGravity() {
        return 0.05;
    }

    protected void onHit(HitResult result) {
        if (!this.level().isClientSide) {
            this.spawnParticles();
            this.doSplashEffect();
            this.discard();
        }
    }

    abstract boolean hasLivingEntityEffect();

    private void doSplashEffect() {
        this.doGroundSplashEffect();
        if (!this.hasLivingEntityEffect()) {
            return;
        }
        AABB bb = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        List eList = this.level().getEntitiesOfClass(LivingEntity.class, bb);
        eList.forEach(this::doLivingSplashEffect);
    }

    abstract void doGroundSplashEffect();

    private void spawnParticles() {
        if (this.level().isClientSide) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItem()), this.getX(), this.getY(), this.getZ(), this.random.nextGaussian() * 0.15, this.random.nextDouble() * 0.2, this.random.nextGaussian() * 0.15);
        }
        this.level().playSound(null, this.blockPosition(), SoundEvents.GLASS_BREAK, SoundSource.BLOCKS, 1.0f, this.level().random.nextFloat() * 0.1f + 0.9f);
        PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new SpawnThrownPotionImpactParticlesPayload(this.getColor(), this.getX(), this.getY(), this.getZ()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    abstract void doLivingSplashEffect(LivingEntity var1);

    abstract int getColor();

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ITEM, (Object)ItemStack.EMPTY);
    }

    public ItemStack getItem() {
        ItemStack stack = (ItemStack)this.getEntityData().get(ITEM);
        if (stack.getItem() != Items.SPLASH_POTION && stack.getItem() != Items.LINGERING_POTION) {
            LogHelper.error("EntityThrownPotion entity {} has no item?!", this.getId());
            return new ItemStack((ItemLike)Items.SPLASH_POTION);
        }
        return stack;
    }
}

