/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower;

import java.util.function.Supplier;
import mcjty.lib.datagen.DataGen;
import mcjty.lib.modules.IModule;
import mcjty.lib.modules.Modules;
import mcjty.rftoolsbase.api.infoscreen.CapabilityInformationScreenInfo;
import mcjty.rftoolsbase.api.infoscreen.IInformationScreenInfo;
import mcjty.rftoolsbase.api.machineinfo.CapabilityMachineInformation;
import mcjty.rftoolsbase.api.machineinfo.IMachineInformation;
import mcjty.rftoolspower.modules.blazing.BlazingModule;
import mcjty.rftoolspower.modules.dimensionalcell.DimensionalCellModule;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellTileEntity;
import mcjty.rftoolspower.modules.endergenic.EndergenicModule;
import mcjty.rftoolspower.modules.endergenic.blocks.EndergenicTileEntity;
import mcjty.rftoolspower.modules.generator.CoalGeneratorModule;
import mcjty.rftoolspower.modules.monitor.MonitorModule;
import mcjty.rftoolspower.modules.powercell.PowerCellModule;
import mcjty.rftoolspower.modules.powercell.blocks.PowerCellTileEntity;
import mcjty.rftoolspower.setup.Config;
import mcjty.rftoolspower.setup.ModSetup;
import mcjty.rftoolspower.setup.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.IBlockCapabilityProvider;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

@Mod(value="rftoolspower")
public class RFToolsPower {
    public static final String MODID = "rftoolspower";
    public static final ModSetup setup = new ModSetup();
    private final Modules modules = new Modules();
    public static RFToolsPower instance;

    public RFToolsPower(ModContainer mod, IEventBus bus, Dist dist) {
        instance = this;
        this.setupModules(bus, dist);
        Config.register(mod, bus, this.modules);
        Registration.register(bus);
        bus.addListener(setup::init);
        bus.addListener(arg_0 -> ((Modules)this.modules).init(arg_0));
        bus.addListener(this::onDataGen);
        bus.addListener(setup.getBlockCapabilityRegistrar(Registration.RBLOCKS));
        bus.addListener(this::onRegisterCapabilities);
        if (dist.isClient()) {
            bus.addListener(arg_0 -> ((Modules)this.modules).initClient(arg_0));
        }
    }

    public static <T extends Item> Supplier<T> tab(Supplier<T> supplier) {
        return setup.tab(supplier);
    }

    private void onDataGen(GatherDataEvent event) {
        DataGen datagen = new DataGen(MODID, event);
        this.modules.datagen(datagen, event.getLookupProvider());
        datagen.generate();
    }

    private void setupModules(IEventBus bus, Dist dist) {
        this.modules.register((IModule)new BlazingModule(bus));
        this.modules.register((IModule)new DimensionalCellModule(bus));
        this.modules.register((IModule)new EndergenicModule(bus, dist));
        this.modules.register((IModule)new CoalGeneratorModule(bus));
        this.modules.register((IModule)new MonitorModule(bus, dist));
        this.modules.register((IModule)new PowerCellModule(bus, dist));
    }

    private void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlock(CapabilityMachineInformation.MACHINE_INFORMATION_CAPABILITY, (IBlockCapabilityProvider)new IBlockCapabilityProvider<IMachineInformation, Direction>(this){

            @Nullable
            public IMachineInformation getCapability(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity be, Direction direction) {
                if (be instanceof EndergenicTileEntity) {
                    EndergenicTileEntity te = (EndergenicTileEntity)be;
                    return te.getInfoHandler();
                }
                if (be instanceof DimensionalCellTileEntity) {
                    DimensionalCellTileEntity te = (DimensionalCellTileEntity)be;
                    return te.getInfoHandler();
                }
                return null;
            }
        }, new Block[]{(Block)EndergenicModule.ENDERGENIC.block().get(), (Block)DimensionalCellModule.DIMENSIONAL_CELL.block().get(), (Block)DimensionalCellModule.DIMENSIONAL_CELL_ADVANCED.block().get(), (Block)DimensionalCellModule.DIMENSIONAL_CELL_SIMPLE.block().get(), (Block)DimensionalCellModule.DIMENSIONAL_CELL_CREATIVE.block().get()});
        event.registerBlock(CapabilityInformationScreenInfo.INFORMATION_SCREEN_INFO_CAPABILITY, (IBlockCapabilityProvider)new IBlockCapabilityProvider<IInformationScreenInfo, Direction>(this){

            @Nullable
            public IInformationScreenInfo getCapability(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity be, Direction direction) {
                if (be instanceof PowerCellTileEntity) {
                    PowerCellTileEntity te = (PowerCellTileEntity)be;
                    return te.getInfoScreenInfo();
                }
                if (be instanceof DimensionalCellTileEntity) {
                    DimensionalCellTileEntity te = (DimensionalCellTileEntity)be;
                    return te.getInfoScreenInfo();
                }
                return null;
            }
        }, new Block[]{(Block)PowerCellModule.CELL1.block().get(), (Block)PowerCellModule.CELL2.block().get(), (Block)PowerCellModule.CELL3.block().get(), (Block)DimensionalCellModule.DIMENSIONAL_CELL.block().get(), (Block)DimensionalCellModule.DIMENSIONAL_CELL_ADVANCED.block().get(), (Block)DimensionalCellModule.DIMENSIONAL_CELL_SIMPLE.block().get(), (Block)DimensionalCellModule.DIMENSIONAL_CELL_CREATIVE.block().get()});
        event.registerBlock(Capabilities.EnergyStorage.BLOCK, (IBlockCapabilityProvider)new IBlockCapabilityProvider<IEnergyStorage, Direction>(this){

            @Nullable
            public IEnergyStorage getCapability(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity be, Direction direction) {
                if (be instanceof PowerCellTileEntity) {
                    PowerCellTileEntity te = (PowerCellTileEntity)be;
                    return te.getEnergyStorage(direction);
                }
                if (be instanceof DimensionalCellTileEntity) {
                    DimensionalCellTileEntity te = (DimensionalCellTileEntity)be;
                    return te.getEnergyStorage(direction);
                }
                return null;
            }
        }, new Block[]{(Block)PowerCellModule.CELL1.block().get(), (Block)PowerCellModule.CELL2.block().get(), (Block)PowerCellModule.CELL3.block().get(), (Block)DimensionalCellModule.DIMENSIONAL_CELL.block().get(), (Block)DimensionalCellModule.DIMENSIONAL_CELL_ADVANCED.block().get(), (Block)DimensionalCellModule.DIMENSIONAL_CELL_SIMPLE.block().get(), (Block)DimensionalCellModule.DIMENSIONAL_CELL_CREATIVE.block().get()});
    }
}

