/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.util.holder;

import com.github.minecraftschurlimods.bibliocraft.util.holder.GroupingDeferredHolder;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ColoredDeferredHolder<R, T extends R>
implements GroupingDeferredHolder<R, T> {
    private final Map<DyeColor, DeferredHolder<R, T>> map = new LinkedHashMap<DyeColor, DeferredHolder<R, T>>();

    public ColoredDeferredHolder(DeferredRegister<R> register, String suffix, Function<DyeColor, ? extends T> creator) {
        for (DyeColor type : DyeColor.values()) {
            this.map.put(type, register.register(type.getName() + "_" + suffix, () -> creator.apply(type)));
        }
    }

    public DeferredHolder<R, T> holder(DyeColor color) {
        return this.map.get(color);
    }

    public T get(DyeColor color) {
        return (T)this.map.get(color).get();
    }

    public ResourceLocation id(DyeColor color) {
        return this.map.get(color).getId();
    }

    public Map<DyeColor, DeferredHolder<R, T>> map() {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public Collection<DeferredHolder<R, T>> holders() {
        return this.map.values();
    }

    @Override
    public Collection<T> values() {
        return this.map.values().stream().map(DeferredHolder::get).toList();
    }

    @Override
    public Collection<ResourceLocation> ids() {
        return this.map.values().stream().map(DeferredHolder::getId).toList();
    }
}

