/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.slottedbook;

import com.github.minecraftschurlimods.bibliocraft.content.slottedbook.SlottedBookContainer;
import com.github.minecraftschurlimods.bibliocraft.init.BCItems;
import com.github.minecraftschurlimods.bibliocraft.init.BCMenus;
import com.github.minecraftschurlimods.bibliocraft.util.slot.ViewSlot;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SlottedBookMenu
extends AbstractContainerMenu {
    private final InteractionHand hand;

    public SlottedBookMenu(int id, Inventory inventory, InteractionHand hand) {
        super(BCMenus.SLOTTED_BOOK.get(), id);
        int i;
        this.hand = hand;
        ItemStack stack = inventory.player.getItemInHand(hand);
        SlottedBookContainer container = new SlottedBookContainer(stack);
        this.addSlot(new SlottedBookSlot((Container)container, 0, 80, 34));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                int slot = i * 9 + j + 9;
                if (inventory.getItem(slot).is((Item)BCItems.SLOTTED_BOOK.get())) {
                    this.addSlot(new ViewSlot((Container)inventory, slot, 8 + j * 18, 141 + i * 18));
                    continue;
                }
                this.addSlot(new Slot((Container)inventory, slot, 8 + j * 18, 141 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            if (inventory.getItem(i).is((Item)BCItems.SLOTTED_BOOK.get())) {
                this.addSlot(new ViewSlot((Container)inventory, i, 8 + i * 18, 199));
                continue;
            }
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 199));
        }
    }

    public SlottedBookMenu(int id, Inventory inventory, FriendlyByteBuf buf) {
        this(id, inventory, (InteractionHand)buf.readEnum(InteractionHand.class));
    }

    public ItemStack quickMoveStack(Player player, int index) {
        int slotCount = 1;
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = slot.getItem();
        ItemStack originalStack = stack.copy();
        if (index < slotCount) {
            if (!this.moveItemStackTo(slot.getItem(), slotCount, slotCount + 36, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < slotCount + 9) {
            if (!this.moveItemStackTo(stack, 0, slotCount, false)) {
                return ItemStack.EMPTY;
            }
            if (!this.moveItemStackTo(stack, slotCount + 9, slotCount + 36, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < slotCount + 36) {
            if (!this.moveItemStackTo(stack, 0, slotCount, false)) {
                return ItemStack.EMPTY;
            }
            if (!this.moveItemStackTo(stack, slotCount, slotCount + 9, false)) {
                return ItemStack.EMPTY;
            }
        }
        if (stack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        return originalStack;
    }

    public boolean stillValid(Player player) {
        return player.getItemInHand(this.hand).is((Item)BCItems.SLOTTED_BOOK.get());
    }

    public static class SlottedBookSlot
    extends Slot {
        public SlottedBookSlot(Container container, int slot, int x, int y) {
            super(container, slot, x, y);
        }

        public boolean mayPlace(ItemStack stack) {
            return !stack.is(BCItems.SLOTTED_BOOK) && super.mayPlace(stack);
        }
    }
}

