/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.client.widget;

import com.github.minecraftschurlimods.bibliocraft.util.ClientUtil;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ExperienceBarButton
extends Button {
    private final ResourceLocation backgroundTexture;
    private final ResourceLocation progressTexture;
    private final IntSupplier levelGetter;
    private final Supplier<Float> progressGetter;

    public ExperienceBarButton(Component message, int x, int y, int width, int height, ResourceLocation backgroundTexture, ResourceLocation progressTexture, IntSupplier levelGetter, Supplier<Float> progressGetter, Button.OnPress onPress) {
        super(new Button.Builder(message, onPress).bounds(x, y, width, height).tooltip(Tooltip.create((Component)message)));
        this.backgroundTexture = backgroundTexture;
        this.progressTexture = progressTexture;
        this.levelGetter = levelGetter;
        this.progressGetter = progressGetter;
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.blitSprite(this.backgroundTexture, this.getWidth(), this.getHeight(), 0, 0, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        graphics.blitSprite(this.progressTexture, this.getWidth(), this.getHeight(), 0, 0, this.getX(), this.getY(), (int)((float)this.getWidth() * this.progressGetter.get().floatValue()), this.getHeight());
        ClientUtil.renderXpText("" + this.levelGetter.getAsInt(), graphics, this.getX() + this.getWidth() / 2, this.getY() - 4);
    }
}

