/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.item.miscellaneous;

import com.aetherteam.aether.api.registers.MoaType;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.passive.Moa;
import com.aetherteam.aether.mixin.mixins.common.accessor.BaseSpawnerAccessor;
import com.google.common.collect.Iterables;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class MoaEggItem
extends Item {
    private static final Map<ResourceKey<MoaType>, MoaEggItem> BY_ID = new IdentityHashMap<ResourceKey<MoaType>, MoaEggItem>();
    private final ResourceKey<MoaType> moaType;
    private final int color;

    public MoaEggItem(ResourceKey<MoaType> moaType, int shellColor, Item.Properties properties) {
        super(properties);
        this.moaType = moaType;
        this.color = shellColor;
        BY_ID.put(moaType, this);
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack itemStack = context.getItemInHand();
        Player player = context.getPlayer();
        if (player != null && player.isCreative()) {
            BlockEntity blockEntity;
            Level level = context.getLevel();
            if (!(level instanceof ServerLevel)) {
                return InteractionResult.SUCCESS;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos blockPos = context.getClickedPos();
            Direction direction = context.getClickedFace();
            BlockState blockState = level.getBlockState(blockPos);
            if (blockState.is(Blocks.SPAWNER) && (blockEntity = level.getBlockEntity(blockPos)) instanceof SpawnerBlockEntity) {
                SpawnerBlockEntity spawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
                BaseSpawnerAccessor baseSpawnerAccessor = (BaseSpawnerAccessor)spawnerBlockEntity.getSpawner();
                EntityType entityType = (EntityType)AetherEntityTypes.MOA.get();
                spawnerBlockEntity.setEntityId(entityType, level.getRandom());
                baseSpawnerAccessor.aether$getNextSpawnData().getEntityToSpawn().putString("MoaType", this.getMoaType().location().toString());
                baseSpawnerAccessor.aether$getNextSpawnData().getEntityToSpawn().putBoolean("PlayerGrown", true);
                blockEntity.setChanged();
                level.sendBlockUpdated(blockPos, blockState, blockState, 3);
                itemStack.shrink(1);
                return InteractionResult.CONSUME;
            }
            BlockPos relativePos = blockState.getCollisionShape((BlockGetter)level, blockPos).isEmpty() ? blockPos : blockPos.relative(direction);
            if (((EntityType)AetherEntityTypes.MOA.get()).spawn(serverLevel, this.getStackWithTags(serverLevel, itemStack, player, false, this.getMoaType(), false, true), relativePos, MobSpawnType.SPAWN_EGG, true, !Objects.equals(blockPos, relativePos) && direction == Direction.UP) != null) {
                level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, blockPos);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        if (player.isCreative()) {
            BlockHitResult hitResult = MoaEggItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            if (hitResult.getType() != HitResult.Type.BLOCK) {
                return InteractionResultHolder.pass((Object)heldStack);
            }
            if (!(level instanceof ServerLevel)) {
                return InteractionResultHolder.fail((Object)heldStack);
            }
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos blockpos = hitResult.getBlockPos();
            if (!(level.getBlockState(blockpos).getBlock() instanceof LiquidBlock)) {
                return InteractionResultHolder.pass((Object)heldStack);
            }
            if (level.mayInteract(player, blockpos) && player.mayUseItemAt(blockpos, hitResult.getDirection(), heldStack)) {
                if (((EntityType)AetherEntityTypes.MOA.get()).spawn(serverLevel, this.getStackWithTags(serverLevel, heldStack, player, false, this.getMoaType(), false, true), blockpos, MobSpawnType.SPAWN_EGG, false, false) == null) {
                    return InteractionResultHolder.pass((Object)heldStack);
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, blockpos);
                return InteractionResultHolder.consume((Object)heldStack);
            }
            return InteractionResultHolder.fail((Object)heldStack);
        }
        return InteractionResultHolder.fail((Object)heldStack);
    }

    public Consumer<Moa> getStackWithTags(ServerLevel serverLevel, ItemStack stack, Player player, boolean isBaby, ResourceKey<MoaType> moaType, boolean isHungry, boolean isPlayerGrown) {
        ItemStack itemStack = stack.copy();
        return EntityType.appendDefaultStackConfig(consumerEntity -> {
            consumerEntity.setBaby(isBaby);
            consumerEntity.setMoaTypeByKey(moaType);
            consumerEntity.setHungry(isHungry);
            consumerEntity.setPlayerGrown(isPlayerGrown);
        }, (ServerLevel)serverLevel, (ItemStack)itemStack, (Player)player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColor() {
        return this.color;
    }

    public ResourceKey<MoaType> getMoaType() {
        return this.moaType;
    }

    @Nullable
    public static MoaEggItem byId(ResourceKey<MoaType> moaType) {
        if (moaType != null) {
            for (ResourceKey<MoaType> key : BY_ID.keySet()) {
                if (!moaType.equals(key)) continue;
                return BY_ID.get(key);
            }
        }
        return null;
    }

    public static Iterable<MoaEggItem> moaEggs() {
        return Iterables.unmodifiableIterable(BY_ID.values());
    }
}

