/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.block.miscellaneous;

import com.aetherteam.aether.block.Floatable;
import com.aetherteam.aether.entity.block.FloatingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class FloatingBlock
extends Block
implements Floatable {
    private final boolean powered;

    public FloatingBlock(boolean powered, BlockBehaviour.Properties properties) {
        super(properties);
        this.powered = powered;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        level.scheduleTick(pos, (Block)this, this.getDelayAfterPlace());
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        level.scheduleTick(pos, (Block)this, this.getDelayAfterPlace());
        return super.updateShape(state, direction, facingState, level, pos, facingPos);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.tick(state, level, pos, random);
        if ((this.powered && level.hasNeighborSignal(pos) || !this.powered && pos.getY() <= level.getMaxBuildHeight()) && FloatingBlock.isFree(level.getBlockState(pos.above()))) {
            FloatingBlockEntity floatingBlockEntity = new FloatingBlockEntity((Level)level, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, level.getBlockState(pos));
            if (this.powered) {
                floatingBlockEntity.setNatural(false);
            }
            level.addFreshEntity((Entity)floatingBlockEntity);
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            this.floating(floatingBlockEntity);
        } else {
            level.scheduleTick(pos, (Block)this, this.getDelayAfterPlace());
        }
    }

    protected void floating(FloatingBlockEntity entity) {
    }

    public static boolean isFree(BlockState state) {
        return state.isAir() || state.is(BlockTags.FIRE) || state.liquid() || state.canBeReplaced();
    }

    protected int getDelayAfterPlace() {
        return 2;
    }
}

