/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.enderdrives.items;

import appeng.api.config.FuzzyMode;
import appeng.api.implementations.menuobjects.IMenuItem;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.stacks.AEKeyType;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.items.contents.CellConfig;
import appeng.menu.locator.ItemMenuHostLocator;
import appeng.util.ConfigInventory;
import com.sts15.enderdrives.client.ClientTapeCache;
import com.sts15.enderdrives.config.serverConfig;
import com.sts15.enderdrives.db.TapeDBManager;
import com.sts15.enderdrives.network.NetworkHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TapeDiskItem
extends Item
implements ICellWorkbenchItem,
IMenuItem {
    private static final Map<UUID, Long> lastRequest = new HashMap<UUID, Long>();
    private static final String TAPE_ID_KEY = "tape_disk_id";
    private final Supplier<Integer> typeLimit;
    private static final ThreadLocal<ByteArrayOutputStream> LOCAL_BAOS = ThreadLocal.withInitial(() -> new ByteArrayOutputStream(512));
    private static final ThreadLocal<DataOutputStream> LOCAL_DOS = ThreadLocal.withInitial(() -> new DataOutputStream(LOCAL_BAOS.get()));

    public TapeDiskItem(Item.Properties props, Supplier<Integer> typeLimit) {
        super(props.stacksTo(1));
        this.typeLimit = typeLimit;
    }

    public static boolean isDisabled(ItemStack stack) {
        return (Boolean)serverConfig.TAPE_DISK_TOGGLE.get() == false;
    }

    public int getTypeLimit() {
        return this.typeLimit.get();
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> lines, @NotNull TooltipFlag advancedTooltips) {
        if (TapeDiskItem.isDisabled(stack)) {
            lines.add((Component)Component.literal((String)"\u00a7cThis item is disabled on the server."));
            return;
        }
        this.addCellInformationToTooltip(stack, lines);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addCellInformationToTooltip(ItemStack stack, List<Component> lines) {
        UUID id = TapeDiskItem.getTapeId(stack);
        int limitColor = 8809980;
        int goodColor = 0x55FF55;
        int warnColor = 0xFFAA00;
        int fullColor = 0xFF5555;
        int labelColor = 0xAAAAAA;
        lines.add((Component)Component.literal((String)"Ideal for tools, armor, and NBT-heavy items.").withStyle(s -> s.withColor(labelColor).withItalic(Boolean.valueOf(true))));
        if (id != null) {
            int typeColor;
            int bytePercent;
            long last;
            long now = System.currentTimeMillis();
            if (now - (last = lastRequest.getOrDefault(id, 0L).longValue()) > 1000L) {
                NetworkHandler.sendToServer(id);
                lastRequest.put(id, now);
            }
            int typeCount = ClientTapeCache.getTypeCount(id);
            long byteCount = ClientTapeCache.getByteCount(id);
            int typeLimit = this.getTypeLimit(stack);
            long byteLimit = TapeDBManager.getByteLimit(id);
            int typePercent = typeLimit == 0 ? 0 : typeCount * 100 / typeLimit;
            int n = bytePercent = byteLimit == 0L ? 0 : (int)(byteCount * 100L / byteLimit);
            int n2 = typePercent >= 99 ? fullColor : (typeColor = typePercent >= 75 ? warnColor : goodColor);
            int byteColor = bytePercent >= 99 ? fullColor : (bytePercent >= 75 ? warnColor : goodColor);
            lines.add((Component)Component.translatable((String)"tooltip.enderdrives.tape.bytes", (Object[])new Object[]{Component.literal((String)String.valueOf(byteCount)).withStyle(s -> s.withColor(byteColor)), Component.literal((String)String.valueOf(byteLimit)).withStyle(s -> s.withColor(limitColor))}).withStyle(s -> s.withColor(labelColor)));
            lines.add((Component)Component.translatable((String)"tooltip.enderdrives.tape.types", (Object[])new Object[]{Component.literal((String)String.valueOf(typeCount)).withStyle(s -> s.withColor(typeColor)), Component.literal((String)String.valueOf(typeLimit)).withStyle(s -> s.withColor(limitColor))}).withStyle(s -> s.withColor(labelColor)));
            lines.add((Component)Component.literal((String)("Tape ID: " + id.toString().substring(0, 8))).withStyle(s -> s.withColor(labelColor)));
            ConfigInventory config = CellConfig.create(Set.of(AEKeyType.items()), (ItemStack)stack);
            int partitionCount = config.keySet().size();
            if (partitionCount > 0) {
                String plural = partitionCount == 1 ? "" : "s";
                lines.add((Component)Component.translatable((String)"tooltip.enderdrives.partitioned", (Object[])new Object[]{partitionCount, plural}));
            }
        } else {
            int typeLimit = this.getTypeLimit(stack);
            long byteLimit = ((Integer)serverConfig.TAPE_DISK_BYTE_LIMIT.get()).intValue();
            int typeColor = 0x55FF55;
            int byteColor = 0x55FF55;
            lines.add((Component)Component.translatable((String)"tooltip.enderdrives.tape.bytes", (Object[])new Object[]{Component.literal((String)"0").withStyle(s -> s.withColor(byteColor)), Component.literal((String)String.valueOf(byteLimit)).withStyle(s -> s.withColor(limitColor))}).withStyle(s -> s.withColor(labelColor)));
            lines.add((Component)Component.translatable((String)"tooltip.enderdrives.tape.types", (Object[])new Object[]{Component.literal((String)"0").withStyle(s -> s.withColor(typeColor)), Component.literal((String)String.valueOf(typeLimit)).withStyle(s -> s.withColor(limitColor))}).withStyle(s -> s.withColor(labelColor)));
            ConfigInventory config = CellConfig.create(Set.of(AEKeyType.items()), (ItemStack)stack);
            int partitionCount = config.keySet().size();
            if (partitionCount > 0) {
                String plural = partitionCount == 1 ? "" : "s";
                lines.add((Component)Component.translatable((String)"tooltip.enderdrives.partitioned", (Object[])new Object[]{partitionCount, plural}));
            }
        }
    }

    @Nullable
    public static UUID getTapeId(ItemStack stack) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data == null) {
            return null;
        }
        CompoundTag tag = data.copyTag();
        if (!tag.contains(TAPE_ID_KEY)) {
            return null;
        }
        try {
            return UUID.fromString(tag.getString(TAPE_ID_KEY));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static UUID getOrCreateTapeId(ItemStack stack) {
        UUID id = TapeDiskItem.getTapeId(stack);
        if (id != null) {
            return id;
        }
        UUID newId = UUID.randomUUID();
        stack.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, oldData -> {
            CompoundTag tag = oldData.copyTag();
            tag.putString(TAPE_ID_KEY, newId.toString());
            return CustomData.of((CompoundTag)tag);
        });
        return newId;
    }

    public void onCraftedBy(ItemStack stack, Level level, Player player) {
        TapeDiskItem.getOrCreateTapeId(stack);
        super.onCraftedBy(stack, level, player);
    }

    public int getTypeLimit(ItemStack stack) {
        return this.typeLimit.get();
    }

    public ConfigInventory getConfigInventory(ItemStack stack) {
        return CellConfig.create(Set.of(AEKeyType.items()), (ItemStack)stack);
    }

    public FuzzyMode getFuzzyMode(ItemStack stack) {
        return FuzzyMode.IGNORE_ALL;
    }

    public void setFuzzyMode(ItemStack stack, FuzzyMode mode) {
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    @Nullable
    public ItemMenuHost<?> getMenuHost(Player player, ItemMenuHostLocator locator, @Nullable BlockHitResult hitResult) {
        return null;
    }

    public static byte[] serializeItemStackToBytes(ItemStack stack) {
        try {
            RegistryAccess.Frozen provider = ServerLifecycleHooks.getCurrentServer().registryAccess();
            CompoundTag tag = (CompoundTag)stack.save((HolderLookup.Provider)provider);
            if (tag == null) {
                return new byte[0];
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (DataOutputStream dos = new DataOutputStream(baos);){
                NbtIo.write((CompoundTag)tag, (DataOutput)dos);
            }
            return baos.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    public static ItemStack deserializeItemStackFromBytes(byte[] data) {
        CompoundTag tag;
        if (data == null || data.length == 0) {
            return ItemStack.EMPTY;
        }
        try (DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));){
            tag = NbtIo.read((DataInput)dis);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ItemStack.EMPTY;
        }
        RegistryAccess.Frozen provider = ServerLifecycleHooks.getCurrentServer().registryAccess();
        try {
            ItemStack result = ItemStack.parse((HolderLookup.Provider)provider, (Tag)tag).orElse(ItemStack.EMPTY);
            if (!result.isEmpty() && result.getCount() > 99) {
                result.setCount(99);
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                ItemStack fallback;
                if (tag.contains("tag", 10)) {
                    CompoundTag tagTag = tag.getCompound("tag");
                    for (String key : List.of("Enchantments", "StoredEnchantments", "AttributeModifiers", "CustomModelData")) {
                        if (!tagTag.contains(key)) continue;
                        tagTag.remove(key);
                    }
                    if (tagTag.contains("apotheosis") || tagTag.contains("tetra")) {
                        tagTag.remove("apotheosis");
                        tagTag.remove("tetra");
                    }
                }
                if (!(fallback = ItemStack.parse((HolderLookup.Provider)provider, (Tag)tag).orElse(ItemStack.EMPTY)).isEmpty() && fallback.getCount() > 99) {
                    fallback.setCount(99);
                }
                return fallback;
            }
            catch (Exception recoveryException) {
                recoveryException.printStackTrace();
                return ItemStack.EMPTY;
            }
        }
    }
}

