/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.command;

import com.cazsius.solcarrot.lib.Localization;
import com.cazsius.solcarrot.tracking.CapabilityHandler;
import com.cazsius.solcarrot.tracking.FoodList;
import com.cazsius.solcarrot.tracking.ProgressInfo;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

@EventBusSubscriber(modid="solcarrot")
public final class FoodListCommand {
    private static final String name = "foodlist";
    static final DynamicCommandExceptionType ERROR_NO_PERMISSION = new DynamicCommandExceptionType(object -> (Component)object);

    @SubscribeEvent
    public static void register(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)name).then(FoodListCommand.withPlayerArgumentOrSender(Commands.literal((String)"size"), FoodListCommand::showFoodListSize))).then(FoodListCommand.withPlayerArgumentOrSender(Commands.literal((String)"sync"), FoodListCommand::syncFoodList))).then(FoodListCommand.withPlayerArgumentOrSender(Commands.literal((String)"clear"), FoodListCommand::clearFoodList)));
    }

    static ArgumentBuilder<CommandSourceStack, ?> withPlayerArgumentOrSender(ArgumentBuilder<CommandSourceStack, ?> base, CommandWithPlayer command) {
        String target = "target";
        return base.executes(context -> command.run((CommandContext<CommandSourceStack>)context, (Player)((CommandSourceStack)context.getSource()).getPlayerOrException())).then(Commands.argument((String)target, (ArgumentType)EntityArgument.player()).executes(context -> command.run((CommandContext<CommandSourceStack>)context, (Player)EntityArgument.getPlayer((CommandContext)context, (String)target))));
    }

    static int showFoodListSize(CommandContext<CommandSourceStack> context, Player target) {
        ProgressInfo progressInfo = FoodList.get(target).getProgressInfo();
        MutableComponent progressDesc = FoodListCommand.localizedQuantityComponent("size.desc.foods_eaten", progressInfo.foodsEaten);
        FoodListCommand.sendFeedback((CommandSourceStack)context.getSource(), progressDesc);
        MutableComponent milestoneDesc = progressInfo.hasReachedMax() ? FoodListCommand.localizedComponent("size.desc.milestone.max", new Object[0]) : FoodListCommand.localizedComponent("size.desc.milestone.more", progressInfo.foodsUntilNextMilestone());
        FoodListCommand.sendFeedback((CommandSourceStack)context.getSource(), milestoneDesc);
        return 1;
    }

    static int syncFoodList(CommandContext<CommandSourceStack> context, Player target) {
        CapabilityHandler.syncFoodList(target);
        FoodListCommand.sendFeedback((CommandSourceStack)context.getSource(), FoodListCommand.localizedComponent("sync.success", new Object[0]));
        return 1;
    }

    static int clearFoodList(CommandContext<CommandSourceStack> context, Player target) throws CommandSyntaxException {
        boolean isOp = ((CommandSourceStack)context.getSource()).hasPermission(2);
        boolean isTargetingSelf = FoodListCommand.isTargetingSelf(context, target);
        if (!isOp && !isTargetingSelf) {
            throw ERROR_NO_PERMISSION.create((Object)FoodListCommand.localizedComponent("no_permissions", new Object[0]));
        }
        FoodList.get(target).clearFood();
        CapabilityHandler.syncFoodList(target);
        MutableComponent feedback = FoodListCommand.localizedComponent("clear.success", new Object[0]);
        FoodListCommand.sendFeedback((CommandSourceStack)context.getSource(), feedback);
        if (!isTargetingSelf) {
            target.displayClientMessage((Component)FoodListCommand.applyFeedbackStyle(feedback), true);
        }
        return 1;
    }

    static void sendFeedback(CommandSourceStack source, MutableComponent message) {
        source.sendSuccess(() -> FoodListCommand.applyFeedbackStyle(message), true);
    }

    private static MutableComponent applyFeedbackStyle(MutableComponent text) {
        return text.withStyle(ChatFormatting.DARK_AQUA);
    }

    static boolean isTargetingSelf(CommandContext<CommandSourceStack> context, Player target) {
        return target.is(Objects.requireNonNull(((CommandSourceStack)context.getSource()).getEntity()));
    }

    static MutableComponent localizedComponent(String path, Object ... args) {
        return Localization.localizedComponent("command", FoodListCommand.localizationPath(path), args);
    }

    static MutableComponent localizedQuantityComponent(String path, int number) {
        return Localization.localizedQuantityComponent("command", FoodListCommand.localizationPath(path), number);
    }

    static String localizationPath(String path) {
        return "foodlist." + path;
    }

    @FunctionalInterface
    private static interface CommandWithPlayer {
        public int run(CommandContext<CommandSourceStack> var1, Player var2) throws CommandSyntaxException;
    }
}

