/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.entity;

import com.teammetallurgy.aquaculture.entity.FishType;
import com.teammetallurgy.aquaculture.entity.ai.goal.FollowTypeSchoolLeaderGoal;
import com.teammetallurgy.aquaculture.init.AquaSounds;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.FollowFlockLeaderGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;

public class AquaFishEntity
extends AbstractSchoolingFish {
    private final FishType fishType;

    public AquaFishEntity(EntityType<? extends AbstractSchoolingFish> entityType, Level world, FishType fishType) {
        super(entityType, world);
        this.fishType = fishType;
    }

    public FishType getFishType() {
        return this.fishType;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.availableGoals.forEach(prioritizedGoal -> {
            if (prioritizedGoal.getGoal().getClass() == FollowFlockLeaderGoal.class) {
                this.goalSelector.removeGoal(prioritizedGoal.getGoal());
            }
        });
        this.goalSelector.addGoal(5, (Goal)new FollowTypeSchoolLeaderGoal(this));
    }

    public ItemStack getPickedResult(HitResult target) {
        return this.getBucketItemStack();
    }

    @Nonnull
    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)(String.valueOf(BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.getType())) + "_bucket"))));
    }

    @Nonnull
    protected SoundEvent getFlopSound() {
        if (this.getFishType() == FishType.JELLYFISH) {
            return (SoundEvent)AquaSounds.JELLYFISH_FLOP.get();
        }
        return (SoundEvent)AquaSounds.FISH_FLOP.get();
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AquaSounds.FISH_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AquaSounds.FISH_DEATH.get();
    }

    protected SoundEvent getHurtSound(@Nonnull DamageSource damageSource) {
        return (SoundEvent)AquaSounds.FISH_HURT.get();
    }

    public void playerTouch(@Nonnull Player player) {
        super.playerTouch(player);
        if (Objects.equals(BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.getType()), ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"jellyfish")) && this.isAlive() && this.distanceToSqr((Entity)player) < 1.0 && player.hurt(this.damageSources().mobAttack((LivingEntity)this), 0.5f)) {
            this.playSound((SoundEvent)AquaSounds.JELLYFISH_COLLIDE.get(), 0.5f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        }
    }

    public void stopFollowing() {
        if (this.leader != null) {
            super.stopFollowing();
        }
    }

    private static boolean isSourceBlock(LevelAccessor world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        return state.getBlock() instanceof LiquidBlock && world.getBlockState(pos).is(Blocks.WATER) && (Integer)state.getValue((Property)LiquidBlock.LEVEL) == 0;
    }
}

