/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.inventory.container;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.inventory.InventoryLocationPlayer;
import org.cyclops.cyclopscore.inventory.ItemLocation;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.part.PartTypeConnectorOmniDirectional;
import org.cyclops.integratedterminals.RegistryEntries;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.api.terminalstorage.location.ITerminalStorageLocation;
import org.cyclops.integratedterminals.core.terminalstorage.location.TerminalStorageLocations;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.cyclops.integratedterminals.inventory.container.TerminalStorageState;
import org.cyclops.integratedterminals.item.ItemTerminalStoragePortable;

public class ContainerTerminalStorageItem
extends ContainerTerminalStorageBase<ItemLocation> {
    private final ItemLocation itemLocation;

    public ContainerTerminalStorageItem(int id, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(id, playerInventory, ItemLocation.readFromPacketBuffer((FriendlyByteBuf)packetBuffer), packetBuffer.readBoolean() ? Optional.of(ContainerTerminalStorageBase.InitTabData.readFromPacketBuffer(packetBuffer)) : Optional.empty(), TerminalStorageState.readFromPacketBuffer(packetBuffer));
        this.getGuiState().setDirtyMarkListener(this::sendGuiStateToServer);
    }

    public ContainerTerminalStorageItem(int id, Inventory playerInventory, ItemLocation itemLocation, Optional<ContainerTerminalStorageBase.InitTabData> initTabData, TerminalStorageState terminalStorageState) {
        this((MenuType)RegistryEntries.CONTAINER_PART_TERMINAL_STORAGE_ITEM.get(), id, playerInventory, itemLocation, initTabData, terminalStorageState);
    }

    public ContainerTerminalStorageItem(@Nullable MenuType<?> type, int id, Inventory playerInventory, ItemLocation itemLocation, Optional<ContainerTerminalStorageBase.InitTabData> initTabData, TerminalStorageState terminalStorageState) {
        super(type, id, playerInventory, initTabData, terminalStorageState, ContainerTerminalStorageItem.getNetworkFromItem(itemLocation.getItemStack(playerInventory.player)), ContainerTerminalStorageItem.getVariableInventoryFromItem(itemLocation.getItemStack(playerInventory.player)));
        this.itemLocation = itemLocation;
    }

    public static Optional<INetwork> getNetworkFromItem(ItemStack itemStack) {
        if (MinecraftHelpers.isClientSideThread()) {
            return Optional.empty();
        }
        int groupId = ItemTerminalStoragePortable.getGroupId(itemStack);
        if (groupId < 0) {
            return Optional.empty();
        }
        for (PartPos pos : PartTypeConnectorOmniDirectional.LOADED_GROUPS.getPositions(groupId)) {
            Optional network = NetworkHelpers.getNetwork((PartPos)pos);
            if (!network.isPresent()) continue;
            return network.map(a -> a);
        }
        return Optional.empty();
    }

    public static Optional<ITerminalStorageTabCommon.IVariableInventory> getVariableInventoryFromItem(ItemStack itemStack) {
        return Optional.of(ItemTerminalStoragePortable.getVariableInventory(itemStack));
    }

    public ItemStack getItemStack(Player player) {
        return this.itemLocation.getItemStack(player);
    }

    public boolean stillValid(Player playerIn) {
        ItemStack item = this.getItemStack(this.player);
        return item != null && item.getItem() == RegistryEntries.ITEM_TERMINAL_STORAGE_PORTABLE.get();
    }

    @Override
    public ITerminalStorageLocation<ItemLocation> getLocation() {
        return TerminalStorageLocations.ITEM;
    }

    @Override
    public ItemLocation getLocationInstance() {
        return this.itemLocation;
    }

    @Override
    public void onVariableContentsUpdated(INetwork network, IVariable<?> variable) {
    }

    protected Slot createNewSlot(Container inventory, int index, int x, int y) {
        return new Slot(inventory, index, x, y){

            public boolean mayPickup(Player playerIn) {
                return super.mayPickup(playerIn) && (ContainerTerminalStorageItem.this.itemLocation.inventoryLocation() != InventoryLocationPlayer.getInstance() || ContainerTerminalStorageItem.this.itemLocation.slot() != this.index);
            }
        };
    }
}

