/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.client.gui.container;

import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.inventory.container.ContainerExtended;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.client.gui.container.component.GuiCraftingPlan;
import org.cyclops.integratedterminals.client.gui.container.component.GuiCraftingPlanFlat;
import org.cyclops.integratedterminals.client.gui.container.component.GuiCraftingPlanToggler;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalCraftingJobsPlan;
import org.cyclops.integratedterminals.network.packet.CancelCraftingJobPacket;
import org.cyclops.integratedterminals.network.packet.OpenCraftingJobsGuiPacket;

public class ContainerScreenTerminalCraftingJobsPlan
extends ContainerScreenExtended<ContainerTerminalCraftingJobsPlan> {
    private final Player player;
    private GuiCraftingPlanToggler guiCraftingPlanToggler;
    @Nullable
    private GuiCraftingPlan guiCraftingPlan;
    @Nullable
    private GuiCraftingPlanFlat guiCraftingPlanFlat;
    private boolean craftingPlanInitialized = false;
    private boolean craftingPlanFlatInitialized = false;

    public ContainerScreenTerminalCraftingJobsPlan(ContainerTerminalCraftingJobsPlan container, Inventory inventory, Component title) {
        super((ContainerExtended)container, inventory, title);
        this.player = inventory.player;
        this.guiCraftingPlanToggler = new GuiCraftingPlanToggler(() -> ((ContainerTerminalCraftingJobsPlan)this.getMenu()).getCraftingPlan().orElse(null), () -> ((ContainerTerminalCraftingJobsPlan)this.getMenu()).getCraftingPlanFlat().orElse(null), () -> {
            GuiCraftingPlan previousGuiCraftingPlan = this.guiCraftingPlan;
            this.guiCraftingPlan = new GuiCraftingPlan((AbstractContainerScreen)this, ((ContainerTerminalCraftingJobsPlan)this.getMenu()).getCraftingPlan().get(), this.leftPos, this.topPos, 9, 18, 10);
            if (previousGuiCraftingPlan != null) {
                this.guiCraftingPlan.inheritVisualizationState(previousGuiCraftingPlan);
            }
            this.addRenderableWidget((GuiEventListener)this.guiCraftingPlan);
            this.guiCraftingPlanFlat = null;
            if (((ContainerTerminalCraftingJobsPlan)this.getMenu()).getCraftingPlanFlat().isPresent()) {
                this.addRenderableWidget((GuiEventListener)new ButtonText(this.leftPos + 8, this.topPos + 198, 80, 20, (Component)Component.translatable((String)"gui.integratedterminals.craftingplan.view.flat"), (Component)Component.translatable((String)"gui.integratedterminals.craftingplan.view.flat").withStyle(ChatFormatting.ITALIC), b -> {
                    this.guiCraftingPlanToggler.setCraftingPlanDisplayMode(GuiCraftingPlanToggler.CraftingPlanDisplayMode.FLAT);
                    this.init();
                }, true));
            }
        }, () -> {
            GuiCraftingPlanFlat previousGuiCraftingPlan = this.guiCraftingPlanFlat;
            this.guiCraftingPlanFlat = new GuiCraftingPlanFlat((AbstractContainerScreen)this, ((ContainerTerminalCraftingJobsPlan)this.getMenu()).getCraftingPlanFlat().get(), this.leftPos, this.topPos, 9, 18, 10);
            if (previousGuiCraftingPlan != null) {
                this.guiCraftingPlanFlat.inheritVisualizationState(previousGuiCraftingPlan);
            }
            this.addRenderableWidget((GuiEventListener)this.guiCraftingPlanFlat);
            this.guiCraftingPlan = null;
            if (((ContainerTerminalCraftingJobsPlan)this.getMenu()).getCraftingPlan().isPresent()) {
                this.addRenderableWidget((GuiEventListener)new ButtonText(this.leftPos + 8, this.topPos + 198, 80, 20, (Component)Component.translatable((String)"gui.integratedterminals.craftingplan.view.tree"), (Component)Component.translatable((String)"gui.integratedterminals.craftingplan.view.tree").withStyle(ChatFormatting.ITALIC), b -> {
                    this.guiCraftingPlanToggler.setCraftingPlanDisplayMode(GuiCraftingPlanToggler.CraftingPlanDisplayMode.TREE);
                    this.init();
                }, true));
            }
        }, () -> {
            this.guiCraftingPlan = null;
            this.guiCraftingPlanFlat = null;
        });
    }

    protected ResourceLocation constructGuiTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"integratedterminals", (String)"textures/gui/crafting_plan.png");
    }

    public ResourceLocation getGuiTexture() {
        return this.guiCraftingPlanToggler.getCraftingPlanDisplayMode() == GuiCraftingPlanToggler.CraftingPlanDisplayMode.FLAT ? ResourceLocation.fromNamespaceAndPath((String)"integratedterminals", (String)"textures/gui/crafting_plan_flat.png") : super.getGuiTexture();
    }

    public int getBaseXSize() {
        return 256;
    }

    public int getBaseYSize() {
        return 222;
    }

    public void init() {
        super.init();
        this.renderables.clear();
        this.children().clear();
        this.guiCraftingPlanToggler.init();
        if (this.guiCraftingPlan != null || this.guiCraftingPlanFlat != null) {
            this.addRenderableWidget((GuiEventListener)new ButtonText(this.leftPos + 221 + 10 - 100, this.topPos + 198, 100, 20, (Component)Component.translatable((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.cancel"), (Component)Component.translatable((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.cancel"), b -> this.cancelCraftingJob(), true));
        }
    }

    public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
        if (typedChar == 256) {
            this.returnToOverview();
            return true;
        }
        return super.keyPressed(typedChar, keyCode, modifiers);
    }

    private void returnToOverview() {
        PartPos center = ((PartTarget)((ContainerTerminalCraftingJobsPlan)this.getMenu()).getTarget().get()).getCenter();
        OpenCraftingJobsGuiPacket.send(center.getPos().getBlockPos(), center.getSide());
    }

    private void cancelCraftingJob() {
        IntegratedTerminals._instance.getPacketHandler().sendToServer((PacketBase)new CancelCraftingJobPacket(((ContainerTerminalCraftingJobsPlan)this.getMenu()).getCraftingJobGuiData()));
        this.returnToOverview();
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        if (this.guiCraftingPlan != null) {
            this.guiCraftingPlan.drawGuiContainerBackgroundLayer(guiGraphics, partialTicks, mouseX, mouseY);
        } else if (this.guiCraftingPlanFlat != null) {
            this.guiCraftingPlanFlat.drawGuiContainerBackgroundLayer(guiGraphics, partialTicks, mouseX, mouseY);
        } else {
            guiGraphics.drawCenteredString(this.font, L10NHelpers.localize((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.empty", (Object[])new Object[0]), this.leftPos + this.getBaseXSize() / 2, this.topPos + 23, 0xFFFFFF);
        }
    }

    protected void drawCurrentScreen(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.drawCurrentScreen(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.guiCraftingPlan != null) {
            this.guiCraftingPlan.render(guiGraphics, mouseX, mouseY, partialTicks);
        } else if (this.guiCraftingPlanFlat != null) {
            this.guiCraftingPlanFlat.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.guiCraftingPlan != null) {
            this.guiCraftingPlan.drawGuiContainerForegroundLayer(guiGraphics, mouseX, mouseY);
        } else if (this.guiCraftingPlanFlat != null) {
            this.guiCraftingPlanFlat.drawGuiContainerForegroundLayer(guiGraphics, mouseX, mouseY);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double mouseZ, double delta) {
        if (this.guiCraftingPlan != null) {
            return this.guiCraftingPlan.mouseScrolled(mouseX, mouseY, mouseZ, delta);
        }
        if (this.guiCraftingPlanFlat != null) {
            return this.guiCraftingPlanFlat.mouseScrolled(mouseX, mouseY, mouseZ, delta);
        }
        return super.mouseScrolled(mouseX, mouseY, mouseZ, delta);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double mouseXPrev, double mouseYPrev) {
        if (this.guiCraftingPlan != null) {
            return this.guiCraftingPlan.mouseDragged(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev);
        }
        if (this.guiCraftingPlanFlat != null) {
            return this.guiCraftingPlanFlat.mouseDragged(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev);
        }
        return super.mouseDragged(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev);
    }

    public void onUpdate(int valueId, CompoundTag value) {
        super.onUpdate(valueId, value);
        if (((ContainerTerminalCraftingJobsPlan)this.getMenu()).getCraftingPlanNotifierId() == valueId || ((ContainerTerminalCraftingJobsPlan)this.getMenu()).getCraftingPlanFlatNotifierId() == valueId) {
            if (!this.craftingPlanInitialized || !this.craftingPlanFlatInitialized) {
                this.guiCraftingPlanToggler.setCraftingPlanDisplayMode(null);
            }
            this.init();
        }
        if (((ContainerTerminalCraftingJobsPlan)this.getMenu()).getCraftingPlanNotifierId() == valueId) {
            this.craftingPlanInitialized = true;
        }
        if (((ContainerTerminalCraftingJobsPlan)this.getMenu()).getCraftingPlanFlatNotifierId() == valueId) {
            this.craftingPlanFlatInitialized = true;
        }
    }
}

