/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.setup;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.silentchaos512.gems.block.OreBlockSG;
import net.silentchaos512.gems.block.teleporter.TeleporterAnchorBlock;
import net.silentchaos512.gems.setup.GemsItems;
import net.silentchaos512.gems.util.Gems;

public final class GemsBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"silentgems");
    public static final DeferredBlock<TeleporterAnchorBlock> TELEPORTER_ANCHOR;
    public static final DeferredBlock<OreBlockSG> CHAOS_ORE;
    public static final DeferredBlock<OreBlockSG> DEEPSLATE_CHAOS_ORE;
    public static final DeferredBlock<OreBlockSG> SILVER_ORE;
    public static final DeferredBlock<OreBlockSG> DEEPSLATE_SILVER_ORE;
    public static final DeferredBlock<Block> CHAOS_ESSENCE_BLOCK;
    public static final DeferredBlock<Block> SILVER_BLOCK;

    private GemsBlocks() {
    }

    private static <T extends Block> DeferredBlock<T> registerNoItem(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    private static <T extends Block> DeferredBlock<T> register(String name, Supplier<T> block) {
        return GemsBlocks.register(name, block, GemsBlocks::defaultItem);
    }

    private static <T extends Block> DeferredBlock<T> register(String name, Supplier<T> block, Function<DeferredBlock<T>, Supplier<? extends BlockItem>> item) {
        DeferredBlock<T> ret = GemsBlocks.registerNoItem(name, block);
        GemsItems.ITEMS.register(name, item.apply(ret));
        return ret;
    }

    private static <T extends Block> Supplier<BlockItem> defaultItem(DeferredBlock<T> block) {
        return () -> new BlockItem((Block)block.get(), new Item.Properties());
    }

    private static OreBlockSG getSilverOre(BlockBehaviour.Properties properties) {
        return new OreBlockSG((ItemLike)GemsItems.RAW_SILVER, 2, (IntProvider)ConstantInt.of((int)0), properties);
    }

    private static OreBlockSG getChaosOre(BlockBehaviour.Properties properties) {
        return new OreBlockSG((ItemLike)GemsItems.CHAOS_ESSENCE, 3, (IntProvider)UniformInt.of((int)3, (int)7), properties);
    }

    static {
        Gems.registerBlocks();
        TELEPORTER_ANCHOR = GemsBlocks.register("teleporter_anchor", () -> new TeleporterAnchorBlock(BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(5.0f, 3.0f)));
        CHAOS_ORE = GemsBlocks.register("chaos_ore", () -> GemsBlocks.getChaosOre(BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(5.0f, 3.0f)));
        DEEPSLATE_CHAOS_ORE = GemsBlocks.register("deepslate_chaos_ore", () -> GemsBlocks.getChaosOre(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)CHAOS_ORE.get())).strength(6.0f, 3.0f).sound(SoundType.DEEPSLATE)));
        SILVER_ORE = GemsBlocks.register("silver_ore", () -> GemsBlocks.getSilverOre(BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(3.0f)));
        DEEPSLATE_SILVER_ORE = GemsBlocks.register("deepslate_silver_ore", () -> GemsBlocks.getSilverOre(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SILVER_ORE.get())).strength(4.5f, 3.0f).sound(SoundType.DEEPSLATE)));
        CHAOS_ESSENCE_BLOCK = GemsBlocks.register("chaos_essence_block", () -> new Block(BlockBehaviour.Properties.of().strength(4.0f, 30.0f).sound(SoundType.METAL)));
        SILVER_BLOCK = GemsBlocks.register("silver_block", () -> new Block(BlockBehaviour.Properties.of().strength(4.0f, 30.0f).sound(SoundType.METAL)));
    }
}

