/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block.teleporter;

import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.silentchaos512.gems.block.teleporter.TeleporterBlockEntity;
import net.silentchaos512.gems.item.TeleporterLinker;
import net.silentchaos512.lib.util.DimPos;
import net.silentchaos512.lib.util.TeleportUtils;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTeleporterBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty TRIGGERED = BlockStateProperties.TRIGGERED;
    private final MapCodec<? extends AbstractTeleporterBlock> codec;

    public AbstractTeleporterBlock(BlockBehaviour.Properties properties, Function<BlockBehaviour.Properties, ? extends AbstractTeleporterBlock> constructor) {
        super(properties);
        this.codec = AbstractTeleporterBlock.simpleCodec(constructor);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return this.codec;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TeleporterBlockEntity(pos, state);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (this.playerHoldingLinker(player)) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TeleporterBlockEntity) {
            DimPos destination;
            TeleporterBlockEntity teleporterBlockEntity = (TeleporterBlockEntity)blockEntity;
            if (player instanceof ServerPlayer && (destination = teleporterBlockEntity.getDestination()) != null) {
                this.teleportEntity(level, (Entity)player, destination);
                this.playTeleportSound(level, player.blockPosition().above());
                this.playTeleportSound(level, destination);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean playerHoldingLinker(Player player) {
        return player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof TeleporterLinker || player.getItemInHand(InteractionHand.OFF_HAND).getItem() instanceof TeleporterLinker;
    }

    protected void teleportEntity(Level level, Entity entity, DimPos destination) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            TeleportUtils.teleport((Player)player, (DimPos)destination, null);
        } else {
            TeleportUtils.teleportEntity((Entity)entity, (DimPos)destination, null);
        }
    }

    protected void playTeleportSound(Level level, BlockPos pos) {
        level.playSound(null, pos, SoundEvents.PLAYER_TELEPORT, SoundSource.BLOCKS, 0.7f, 1.2f);
    }

    protected void playTeleportSound(Level level, DimPos destination) {
        MinecraftServer server = level.getServer();
        if (server == null) {
            return;
        }
        ServerLevel destinationLevel = server.getLevel(destination.dimension());
        if (destinationLevel == null) {
            return;
        }
        this.playTeleportSound((Level)destinationLevel, destination.getPos());
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, TRIGGERED});
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }
}

