/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.extradisks.content.chemical;

import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageBlockProvider;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceFactory;
import com.refinedmods.refinedstorage.mekanism.ChemicalResourceFactory;
import com.refinedmods.refinedstorage.mekanism.ChemicalResourceType;
import com.refinedmods.refinedstorage.mekanism.content.Menus;
import de.melanx.extradisks.ModConfig;
import de.melanx.extradisks.Registration;
import de.melanx.extradisks.content.chemical.ExtraChemicalStorageVariant;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class ExtraChemicalStorageBlockProvider
implements StorageBlockProvider {
    private final ExtraChemicalStorageVariant variant;
    private final Component displayName;

    public ExtraChemicalStorageBlockProvider(ExtraChemicalStorageVariant variant) {
        this.variant = variant;
        this.displayName = Component.translatable((String)("block.extradisks." + variant.getName() + "_chemical_storage_block"));
    }

    @Nonnull
    public SerializableStorage createStorage(@Nonnull Runnable runnable) {
        return ChemicalResourceType.STORAGE_TYPE.create(this.variant.getCapacity(), runnable);
    }

    @Nonnull
    public Component getDisplayName() {
        return this.displayName;
    }

    public long getEnergyUsage() {
        return switch (this.variant) {
            default -> throw new MatchException(null, null);
            case ExtraChemicalStorageVariant.TIER_5_CHEMICAL -> ((Integer)ModConfig.chemical_tier5usage.get()).intValue();
            case ExtraChemicalStorageVariant.TIER_6_CHEMICAL -> ((Integer)ModConfig.chemical_tier6usage.get()).intValue();
            case ExtraChemicalStorageVariant.TIER_7_CHEMICAL -> ((Integer)ModConfig.chemical_tier7usage.get()).intValue();
            case ExtraChemicalStorageVariant.TIER_8_CHEMICAL -> ((Integer)ModConfig.chemical_tier8usage.get()).intValue();
            case ExtraChemicalStorageVariant.TIER_9_CHEMICAL -> ((Integer)ModConfig.chemical_tier9usage.get()).intValue();
        };
    }

    @Nonnull
    public ResourceFactory getResourceFactory() {
        return ChemicalResourceFactory.INSTANCE;
    }

    @Nonnull
    public BlockEntityType<?> getBlockEntityType() {
        return (BlockEntityType)Registration.CHEMICAL_STORAGE_TILE.get((Object)this.variant).get();
    }

    @Nonnull
    public MenuType<?> getMenuType() {
        return Menus.getChemicalStorage();
    }
}

