/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.blueflame.cap;

import cy.jdkdigital.blueflame.network.FirePacket;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.UnknownNullability;

public class BlueFlameHandler
implements INBTSerializable<CompoundTag> {
    private boolean isOnFire = false;

    public void sync(Entity entity) {
        if (!entity.level().isClientSide()) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)new FirePacket(entity.getId(), this.serializeNBT((HolderLookup.Provider)entity.level().registryAccess())), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean isOnFire() {
        return this.isOnFire;
    }

    public void setOnFire(Entity entity) {
        this.isOnFire = true;
        this.sync(entity);
    }

    public void unsetOnFire(Entity entity) {
        this.isOnFire = false;
        this.sync(entity);
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("isOnFire", this.isOnFire);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        this.isOnFire = tag.getBoolean("isOnFire");
    }
}

