/*
 * Decompiled with CFR 0.152.
 */
package observable;

import com.mojang.brigadier.CommandDispatcher;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.architectury.utils.GameInstance;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.DeserializationStrategy;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.Commands;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import observable.Observable;
import observable.client.Overlay;
import observable.client.ProfileScreen;
import observable.net.BetterChannel;
import observable.net.C2SPacket;
import observable.net.S2CPacket;
import observable.server.CommandsKt;
import observable.server.Profiler;
import observable.server.ProfilingData;
import observable.server.ServerSettingsKt;
import observable.shadow.kotlinx.serialization.protobuf.ProtoBuf;
import observable.util.Marker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u000b\u0010\u0003R\u0017\u0010\r\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0015\u001a\n \u0012*\u0004\u0018\u00010\u00110\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0017\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001c\u001a\u00020\u001b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u001b\u0010#\u001a\u00020\u001e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R\u001b\u0010(\u001a\u00020$8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010 \u001a\u0004\b&\u0010'R\u001b\u0010-\u001a\u00020)8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010 \u001a\u0004\b+\u0010,R$\u0010/\u001a\u0004\u0018\u00010.8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b/\u00100\u001a\u0004\b1\u00102\"\u0004\b3\u00104\u00a8\u00065"}, d2={"Lobservable/Observable;", "", "<init>", "()V", "", "clientInit", "Lnet/minecraft/world/entity/player/Player;", "player", "", "hasPermission", "(Lnet/minecraft/world/entity/player/Player;)Z", "init", "Lobservable/net/BetterChannel;", "CHANNEL", "Lobservable/net/BetterChannel;", "getCHANNEL", "()Lobservable/net/BetterChannel;", "Lnet/minecraft/client/gui/components/ChatComponent;", "kotlin.jvm.PlatformType", "getCLIENT_CHAT", "()Lnet/minecraft/client/gui/components/ChatComponent;", "CLIENT_CHAT", "Lorg/apache/logging/log4j/Logger;", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "getLOGGER", "()Lorg/apache/logging/log4j/Logger;", "", "MOD_ID", "Ljava/lang/String;", "Lobservable/server/Profiler;", "PROFILER$delegate", "Lkotlin/Lazy;", "getPROFILER", "()Lobservable/server/Profiler;", "PROFILER", "Lnet/minecraft/client/KeyMapping;", "PROFILE_KEYBIND$delegate", "getPROFILE_KEYBIND", "()Lnet/minecraft/client/KeyMapping;", "PROFILE_KEYBIND", "Lobservable/client/ProfileScreen;", "PROFILE_SCREEN$delegate", "getPROFILE_SCREEN", "()Lobservable/client/ProfileScreen;", "PROFILE_SCREEN", "Lobservable/server/ProfilingData;", "RESULTS", "Lobservable/server/ProfilingData;", "getRESULTS", "()Lobservable/server/ProfilingData;", "setRESULTS", "(Lobservable/server/ProfilingData;)V", "observable"})
@SourceDebugExtension(value={"SMAP\nObservable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Observable.kt\nobservable/Observable\n+ 2 BetterChannel.kt\nobservable/net/BetterChannel\n+ 3 Overlay.kt\nobservable/client/Overlay\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,177:1\n69#2,3:178\n69#2,3:181\n69#2,3:184\n69#2,3:187\n69#2,3:190\n69#2,3:193\n69#2,3:196\n184#3:199\n1#4:200\n*S KotlinDebug\n*F\n+ 1 Observable.kt\nobservable/Observable\n*L\n63#1:178,3\n75#1:181,3\n88#1:184,3\n93#1:187,3\n97#1:190,3\n102#1:193,3\n125#1:196,3\n160#1:199\n160#1:200\n*E\n"})
public final class Observable {
    @NotNull
    public static final Observable INSTANCE = new Observable();
    @NotNull
    public static final String MOD_ID = "observable";
    @NotNull
    private static final Lazy PROFILE_KEYBIND$delegate = LazyKt.lazy((Function0)PROFILE_KEYBIND.2.INSTANCE);
    @NotNull
    private static final BetterChannel CHANNEL;
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    private static final Lazy PROFILER$delegate;
    @Nullable
    private static ProfilingData RESULTS;
    @NotNull
    private static final Lazy PROFILE_SCREEN$delegate;

    private Observable() {
    }

    @NotNull
    public final KeyMapping getPROFILE_KEYBIND() {
        Lazy lazy = PROFILE_KEYBIND$delegate;
        return (KeyMapping)lazy.getValue();
    }

    private final ChatComponent getCLIENT_CHAT() {
        return GameInstance.getClient().gui.getChat();
    }

    @NotNull
    public final BetterChannel getCHANNEL() {
        return CHANNEL;
    }

    @NotNull
    public final Logger getLOGGER() {
        return LOGGER;
    }

    @NotNull
    public final Profiler getPROFILER() {
        Lazy lazy = PROFILER$delegate;
        return (Profiler)lazy.getValue();
    }

    @Nullable
    public final ProfilingData getRESULTS() {
        return RESULTS;
    }

    public final void setRESULTS(@Nullable ProfilingData profilingData) {
        RESULTS = profilingData;
    }

    @NotNull
    public final ProfileScreen getPROFILE_SCREEN() {
        Lazy lazy = PROFILE_SCREEN$delegate;
        return (ProfileScreen)((Object)lazy.getValue());
    }

    public final boolean hasPermission(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (ServerSettingsKt.getServerSettings().getAllPlayersAllowed()) {
            return true;
        }
        if (ServerSettingsKt.getServerSettings().getAllowedPlayers().contains(player.getGameProfile().getId().toString())) {
            return true;
        }
        MinecraftServer minecraftServer = GameInstance.getServer();
        if (!(minecraftServer != null && (minecraftServer = minecraftServer.getPlayerList()) != null ? !minecraftServer.isOp(player.getGameProfile()) : false)) {
            return true;
        }
        MinecraftServer minecraftServer2 = GameInstance.getServer();
        return minecraftServer2 != null ? minecraftServer2.isSingleplayer() : false;
    }

    @JvmStatic
    public static final void init() {
        BetterChannel this_$iv;
        BetterChannel betterChannel = CHANNEL;
        Function2 consumer$iv = init.1.INSTANCE;
        boolean $i$f$register = false;
        Map<String, Function2<byte[], NetworkManager.PacketContext, Unit>> map = this_$iv.getHandlers();
        String string = C2SPacket.InitTPSProfile.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = string;
        Object object = new Function2<byte[], NetworkManager.PacketContext, Unit>(consumer$iv){
            final /* synthetic */ Function2 $consumer;
            {
                this.$consumer = $consumer;
                super(2);
            }

            public final void invoke(@NotNull byte[] buf, @NotNull NetworkManager.PacketContext ctx) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                BinaryFormat $this$decodeFromByteArray$iv = ProtoBuf.Default;
                boolean $i$f$decodeFromByteArray = false;
                $this$decodeFromByteArray$iv.getSerializersModule();
                this.$consumer.invoke($this$decodeFromByteArray$iv.decodeFromByteArray((DeserializationStrategy)C2SPacket.InitTPSProfile.Companion.serializer(), buf), (Object)ctx);
            }
        };
        map.put(string2, (Function2<byte[], NetworkManager.PacketContext, Unit>)object);
        BetterChannel.Companion.getLOGGER().info("Registered " + C2SPacket.InitTPSProfile.class);
        this_$iv = CHANNEL;
        consumer$iv = init.2.INSTANCE;
        $i$f$register = false;
        map = this_$iv.getHandlers();
        String string3 = C2SPacket.RequestAvailability.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        string2 = string3;
        object = new Function2<byte[], NetworkManager.PacketContext, Unit>(consumer$iv){
            final /* synthetic */ Function2 $consumer;
            {
                this.$consumer = $consumer;
                super(2);
            }

            public final void invoke(@NotNull byte[] buf, @NotNull NetworkManager.PacketContext ctx) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                BinaryFormat $this$decodeFromByteArray$iv = ProtoBuf.Default;
                boolean $i$f$decodeFromByteArray = false;
                $this$decodeFromByteArray$iv.getSerializersModule();
                this.$consumer.invoke($this$decodeFromByteArray$iv.decodeFromByteArray((DeserializationStrategy)C2SPacket.RequestAvailability.INSTANCE.serializer(), buf), (Object)ctx);
            }
        };
        map.put(string2, (Function2<byte[], NetworkManager.PacketContext, Unit>)object);
        BetterChannel.Companion.getLOGGER().info("Registered " + C2SPacket.RequestAvailability.class);
        this_$iv = CHANNEL;
        consumer$iv = init.3.INSTANCE;
        $i$f$register = false;
        map = this_$iv.getHandlers();
        String string4 = S2CPacket.ProfilingStarted.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
        string2 = string4;
        object = new Function2<byte[], NetworkManager.PacketContext, Unit>(consumer$iv){
            final /* synthetic */ Function2 $consumer;
            {
                this.$consumer = $consumer;
                super(2);
            }

            public final void invoke(@NotNull byte[] buf, @NotNull NetworkManager.PacketContext ctx) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                BinaryFormat $this$decodeFromByteArray$iv = ProtoBuf.Default;
                boolean $i$f$decodeFromByteArray = false;
                $this$decodeFromByteArray$iv.getSerializersModule();
                this.$consumer.invoke($this$decodeFromByteArray$iv.decodeFromByteArray((DeserializationStrategy)S2CPacket.ProfilingStarted.Companion.serializer(), buf), (Object)ctx);
            }
        };
        map.put(string2, (Function2<byte[], NetworkManager.PacketContext, Unit>)object);
        BetterChannel.Companion.getLOGGER().info("Registered " + S2CPacket.ProfilingStarted.class);
        this_$iv = CHANNEL;
        consumer$iv = init.4.INSTANCE;
        $i$f$register = false;
        map = this_$iv.getHandlers();
        String string5 = S2CPacket.ProfilingCompleted.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
        string2 = string5;
        object = new Function2<byte[], NetworkManager.PacketContext, Unit>(consumer$iv){
            final /* synthetic */ Function2 $consumer;
            {
                this.$consumer = $consumer;
                super(2);
            }

            public final void invoke(@NotNull byte[] buf, @NotNull NetworkManager.PacketContext ctx) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                BinaryFormat $this$decodeFromByteArray$iv = ProtoBuf.Default;
                boolean $i$f$decodeFromByteArray = false;
                $this$decodeFromByteArray$iv.getSerializersModule();
                this.$consumer.invoke($this$decodeFromByteArray$iv.decodeFromByteArray((DeserializationStrategy)S2CPacket.ProfilingCompleted.INSTANCE.serializer(), buf), (Object)ctx);
            }
        };
        map.put(string2, (Function2<byte[], NetworkManager.PacketContext, Unit>)object);
        BetterChannel.Companion.getLOGGER().info("Registered " + S2CPacket.ProfilingCompleted.class);
        this_$iv = CHANNEL;
        consumer$iv = init.5.INSTANCE;
        $i$f$register = false;
        map = this_$iv.getHandlers();
        String string6 = S2CPacket.ProfilerInactive.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getName(...)");
        string2 = string6;
        object = new Function2<byte[], NetworkManager.PacketContext, Unit>(consumer$iv){
            final /* synthetic */ Function2 $consumer;
            {
                this.$consumer = $consumer;
                super(2);
            }

            public final void invoke(@NotNull byte[] buf, @NotNull NetworkManager.PacketContext ctx) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                BinaryFormat $this$decodeFromByteArray$iv = ProtoBuf.Default;
                boolean $i$f$decodeFromByteArray = false;
                $this$decodeFromByteArray$iv.getSerializersModule();
                this.$consumer.invoke($this$decodeFromByteArray$iv.decodeFromByteArray((DeserializationStrategy)S2CPacket.ProfilerInactive.INSTANCE.serializer(), buf), (Object)ctx);
            }
        };
        map.put(string2, (Function2<byte[], NetworkManager.PacketContext, Unit>)object);
        BetterChannel.Companion.getLOGGER().info("Registered " + S2CPacket.ProfilerInactive.class);
        this_$iv = CHANNEL;
        consumer$iv = init.6.INSTANCE;
        $i$f$register = false;
        map = this_$iv.getHandlers();
        String string7 = S2CPacket.ProfilingResult.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getName(...)");
        string2 = string7;
        object = new Function2<byte[], NetworkManager.PacketContext, Unit>(consumer$iv){
            final /* synthetic */ Function2 $consumer;
            {
                this.$consumer = $consumer;
                super(2);
            }

            public final void invoke(@NotNull byte[] buf, @NotNull NetworkManager.PacketContext ctx) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                BinaryFormat $this$decodeFromByteArray$iv = ProtoBuf.Default;
                boolean $i$f$decodeFromByteArray = false;
                $this$decodeFromByteArray$iv.getSerializersModule();
                this.$consumer.invoke($this$decodeFromByteArray$iv.decodeFromByteArray((DeserializationStrategy)S2CPacket.ProfilingResult.Companion.serializer(), buf), (Object)ctx);
            }
        };
        map.put(string2, (Function2<byte[], NetworkManager.PacketContext, Unit>)object);
        BetterChannel.Companion.getLOGGER().info("Registered " + S2CPacket.ProfilingResult.class);
        this_$iv = CHANNEL;
        consumer$iv = init.7.INSTANCE;
        $i$f$register = false;
        map = this_$iv.getHandlers();
        String string8 = S2CPacket.Availability.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getName(...)");
        string2 = string8;
        object = new Function2<byte[], NetworkManager.PacketContext, Unit>(consumer$iv){
            final /* synthetic */ Function2 $consumer;
            {
                this.$consumer = $consumer;
                super(2);
            }

            public final void invoke(@NotNull byte[] buf, @NotNull NetworkManager.PacketContext ctx) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                BinaryFormat $this$decodeFromByteArray$iv = ProtoBuf.Default;
                boolean $i$f$decodeFromByteArray = false;
                $this$decodeFromByteArray$iv.getSerializersModule();
                this.$consumer.invoke($this$decodeFromByteArray$iv.decodeFromByteArray((DeserializationStrategy)S2CPacket.Availability.Companion.serializer(), buf), (Object)ctx);
            }
        };
        map.put(string2, (Function2<byte[], NetworkManager.PacketContext, Unit>)object);
        BetterChannel.Companion.getLOGGER().info("Registered " + S2CPacket.Availability.class);
        LifecycleEvent.SERVER_STARTED.register(Observable::init$lambda$0);
        CommandRegistrationEvent.EVENT.register(Observable::init$lambda$1);
    }

    @JvmStatic
    public static final void clientInit() {
        KeyMappingRegistry.register((KeyMapping)INSTANCE.getPROFILE_KEYBIND());
        ClientTickEvent.CLIENT_POST.register(Observable::clientInit$lambda$2);
        ClientLifecycleEvent.CLIENT_LEVEL_LOAD.register(Observable::clientInit$lambda$3);
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(Observable::clientInit$lambda$4);
    }

    private static final void init$lambda$0(MinecraftServer it) {
        Thread thread = Thread.currentThread();
        Profiler profiler = INSTANCE.getPROFILER();
        Intrinsics.checkNotNull((Object)thread);
        profiler.setServerThread(thread);
        LOGGER.info("Registered thread " + thread.getName());
    }

    private static final void init$lambda$1(CommandDispatcher dispatcher, CommandBuildContext commandBuildContext, Commands.CommandSelection commandSelection) {
        dispatcher.register(CommandsKt.getOBSERVABLE_COMMAND());
    }

    private static final void clientInit$lambda$2(Minecraft it) {
        if (INSTANCE.getPROFILE_KEYBIND().consumeClick()) {
            it.setScreen((Screen)INSTANCE.getPROFILE_SCREEN());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void clientInit$lambda$3(ClientLevel level) {
        Overlay this_$iv = Overlay.INSTANCE;
        boolean $i$f$loadSync = false;
        Overlay overlay = this_$iv;
        synchronized (overlay) {
            boolean bl = false;
            this_$iv.load(level);
            Unit unit = Unit.INSTANCE;
        }
        new Marker("observable_announce").mark((Function0<Unit>)((Function0)clientInit.2.1.INSTANCE));
    }

    private static final void clientInit$lambda$4(LocalPlayer it) {
        RESULTS = null;
        INSTANCE.getPROFILE_SCREEN().setAction(ProfileScreen.Action.Companion.getUNAVAILABLE());
    }

    public static final /* synthetic */ ChatComponent access$getCLIENT_CHAT(Observable $this) {
        return $this.getCLIENT_CHAT();
    }

    static {
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"channel");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
        CHANNEL = new BetterChannel(resourceLocation);
        Logger logger = LogManager.getLogger((String)"Observable");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
        PROFILER$delegate = LazyKt.lazy((Function0)PROFILER.2.INSTANCE);
        PROFILE_SCREEN$delegate = LazyKt.lazy((Function0)PROFILE_SCREEN.2.INSTANCE);
    }
}

