/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.network;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.permutated.pylons.Pylons;
import net.permutated.pylons.machines.base.AbstractPylonTile;
import net.permutated.pylons.util.ResourceUtil;

public record PacketButtonClicked(ButtonType buttonType, BlockPos blockPos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketButtonClicked> TYPE = new CustomPacketPayload.Type(ResourceUtil.prefix("button_clicked"));
    public static final StreamCodec<FriendlyByteBuf, PacketButtonClicked> STREAM_CODEC = StreamCodec.of(PacketButtonClicked::encode, PacketButtonClicked::decode);

    private static void encode(FriendlyByteBuf buf, PacketButtonClicked packetButtonClicked) {
        buf.writeEnum((Enum)packetButtonClicked.buttonType);
        buf.writeBlockPos(packetButtonClicked.blockPos);
    }

    private static PacketButtonClicked decode(FriendlyByteBuf buf) {
        return new PacketButtonClicked((ButtonType)buf.readEnum(ButtonType.class), buf.readBlockPos());
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(PacketButtonClicked event, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            BlockEntity be;
            ServerLevel serverLevel;
            Level patt0$temp = ctx.player().getCommandSenderWorld();
            if (patt0$temp instanceof ServerLevel && (serverLevel = (ServerLevel)patt0$temp).isLoaded(event.blockPos) && (be = serverLevel.getBlockEntity(event.blockPos)) instanceof AbstractPylonTile) {
                AbstractPylonTile pylonTile = (AbstractPylonTile)be;
                switch (event.buttonType.ordinal()) {
                    case 0: {
                        pylonTile.handleRangePacket();
                        break;
                    }
                    case 1: {
                        pylonTile.handleWorkPacket();
                        break;
                    }
                    default: {
                        Pylons.LOGGER.error("PacketButtonClicked called with invalid button type!");
                    }
                }
            }
        });
    }

    public static enum ButtonType {
        RANGE,
        WORK;

    }
}

