/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.neoforge;

import com.mojang.authlib.GameProfile;
import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.QpEntity;
import com.yogpc.qp.machine.QuarryFakePlayerCommon;
import com.yogpc.qp.machine.advquarry.AdvQuarryEntity;
import com.yogpc.qp.machine.misc.BlockBreakEventResult;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

final class MiningNeoForge
implements PlatformAccess.Mining {
    MiningNeoForge() {
    }

    @Override
    public BlockBreakEventResult checkBreakEvent(QpEntity miningEntity, Level level, ServerPlayer fakePlayer, BlockState state, BlockPos target, @Nullable BlockEntity blockEntity) {
        BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(level, target, state, (Player)fakePlayer);
        NeoForge.EVENT_BUS.post((Event)breakEvent);
        return new BlockBreakEventResult(breakEvent.isCanceled(), OptionalInt.empty(), List.of());
    }

    @Override
    public BlockBreakEventResult afterBreak(QpEntity miningEntity, Level level, ServerPlayer fakePlayer, BlockState state, BlockPos target, @Nullable BlockEntity blockEntity, List<ItemStack> drops, ItemStack pickaxe, BlockState newState) {
        QpEntity qpEntity = miningEntity;
        int n = 0;
        int updateFlag = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AdvQuarryEntity.class}, (Object)((Object)qpEntity), n)) {
            case 0 -> {
                AdvQuarryEntity ignore = (AdvQuarryEntity)qpEntity;
                yield 2;
            }
            default -> 3;
        };
        ArrayList itemDropEntities = drops.stream().map(i -> new ItemEntity(level, (double)target.getX(), (double)target.getY(), (double)target.getZ(), i)).collect(Collectors.toCollection(ArrayList::new));
        BlockDropsEvent dropEvent = new BlockDropsEvent((ServerLevel)level, target, state, blockEntity, (List)itemDropEntities, (Entity)fakePlayer, pickaxe);
        NeoForge.EVENT_BUS.post((Event)dropEvent);
        level.setBlock(target, newState, updateFlag);
        OptionalInt exp = dropEvent.isCanceled() ? OptionalInt.empty() : OptionalInt.of(dropEvent.getDroppedExperience());
        return new BlockBreakEventResult(dropEvent.isCanceled(), exp, itemDropEntities.stream().map(ItemEntity::getItem).toList());
    }

    @Override
    public ServerPlayer getQuarryFakePlayer(QpEntity miningEntity, ServerLevel level, BlockPos target) {
        Object fakePlayer = PlatformAccess.config().customPlayer() ? QuarryFakePlayerCommon.getOwnImplementation(level, s -> ServerLifecycleHooks.getCurrentServer()) : FakePlayerFactory.get((ServerLevel)level, (GameProfile)QuarryFakePlayerCommon.PROFILE);
        QuarryFakePlayerCommon.setDirection(fakePlayer, Direction.DOWN);
        return fakePlayer;
    }
}

