/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials;

import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.compat.kubejs.KubeJSProxy;
import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.materials.Material;
import aztech.modern_industrialization.materials.MaterialBuilder;
import aztech.modern_industrialization.materials.MaterialRegistry;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.materials.part.MaterialItemPart;
import aztech.modern_industrialization.materials.part.NuclearFuelPart;
import aztech.modern_industrialization.materials.part.PartEnglishNameFormatter;
import aztech.modern_industrialization.materials.part.PartKeyProvider;
import aztech.modern_industrialization.materials.property.MaterialHardness;
import aztech.modern_industrialization.materials.property.MaterialProperty;
import aztech.modern_industrialization.materials.recipe.ForgeHammerRecipes;
import aztech.modern_industrialization.materials.recipe.SmeltingRecipes;
import aztech.modern_industrialization.materials.recipe.StandardRecipes;
import aztech.modern_industrialization.materials.recipe.builder.MIRecipeBuilder;
import aztech.modern_industrialization.materials.set.MaterialBlockSet;
import aztech.modern_industrialization.materials.set.MaterialOreSet;
import aztech.modern_industrialization.materials.set.MaterialRawSet;
import aztech.modern_industrialization.materials.set.MaterialSet;
import aztech.modern_industrialization.nuclear.INeutronBehaviour;
import aztech.modern_industrialization.nuclear.IsotopeFuelParams;
import aztech.modern_industrialization.nuclear.NuclearAbsorbable;
import aztech.modern_industrialization.nuclear.NuclearConstant;
import aztech.modern_industrialization.nuclear.NuclearOrder;
import net.minecraft.util.valueproviders.UniformInt;

public class MIMaterials {
    public static final Material ALUMINUM;
    public static final Material ANNEALED_COPPER;
    public static final Material ANTIMONY;
    public static final Material BATTERY_ALLOY;
    public static final Material BAUXITE;
    public static final Material BERYLLIUM;
    public static final Material BLASTPROOF_ALLOY;
    public static final Material BRICK;
    public static final Material BRONZE;
    public static final Material CADMIUM;
    public static final Material CARBON;
    public static final Material CHROMIUM;
    public static final Material COAL;
    public static final Material COKE;
    public static final Material COPPER;
    public static final Material CUPRONICKEL;
    public static final Material DIAMOND;
    public static final Material ELECTRUM;
    public static final Material EMERALD;
    public static final Material FIRE_CLAY;
    public static final Material GOLD;
    public static final Material HE_MOX;
    public static final Material HE_URANIUM;
    public static final Material INVAR;
    public static final Material IRIDIUM;
    public static final Material IRON;
    public static final Material KANTHAL;
    public static final Material LAPIS;
    public static final Material LEAD;
    public static final Material LE_MOX;
    public static final Material LE_URANIUM;
    public static final Material LIGNITE_COAL;
    public static final Material MANGANESE;
    public static final Material MONAZITE;
    public static final Material NEODYMIUM;
    public static final Material NICKEL;
    public static final Material NUCLEAR_ALLOY;
    public static final Material PLATINUM;
    public static final Material PLUTONIUM;
    public static final Material QUARTZ;
    public static final Material REDSTONE;
    public static final Material RUBY;
    public static final Material SALT;
    public static final Material SILICON;
    public static final Material SILVER;
    public static final Material SODIUM;
    public static final Material SOLDERING_ALLOY;
    public static final Material STAINLESS_STEEL;
    public static final Material STEEL;
    public static final Material SULFUR;
    public static final Material SUPERCONDUCTOR;
    public static final Material TIN;
    public static final Material TITANIUM;
    public static final Material TUNGSTEN;
    public static final Material URANIUM;
    public static final Material URANIUM_235;
    public static final Material URANIUM_238;
    public static final Material YTTRIUM;
    public static final String commonPath = "modern_industrialization:textures/materialsets/common/";
    public static final String templatePath = "modern_industrialization:textures/template/";
    public static final String mcPath = "minecraft:textures/item/";
    public static final String miPath = "modern_industrialization:textures/item/";

    public static void init() {
    }

    public static String common(String name) {
        return commonPath + name + ".png";
    }

    public static String common(PartKeyProvider part) {
        return MIMaterials.common(part.key().key);
    }

    public static String mcitem(String name) {
        return mcPath + name + ".png";
    }

    public static String miitem(String name) {
        return miPath + name + ".png";
    }

    public static String template(String name) {
        return templatePath + name + ".png";
    }

    public static MaterialBuilder addVanillaMetal(boolean nugget, MaterialBuilder builder) {
        String n = builder.getMaterialName();
        MaterialBuilder res = builder.addMaterialItemParts(MaterialItemPart.external(MIParts.INGOT, "#c:ingots/" + n, "minecraft:" + n + "_ingot")).addMaterialItemParts(MaterialItemPart.external(MIParts.BLOCK, "#c:storage_blocks/" + n, "minecraft:" + n + "_block")).addMaterialItemParts(MaterialItemPart.external(MIParts.ORE, "#c:ores/" + n, "minecraft:" + n + "_ore")).addMaterialItemParts(MaterialItemPart.external(MIParts.ORE_DEEPSLATE, "minecraft:deepslate_" + n + "_ore")).addMaterialItemParts(MaterialItemPart.external(MIParts.RAW_METAL, "#c:raw_materials/" + n, "minecraft:raw_" + n)).addMaterialItemParts(MaterialItemPart.external(MIParts.RAW_METAL_BLOCK, "#c:storage_blocks/raw_" + n, "minecraft:raw_" + n + "_block"));
        if (nugget) {
            res.addMaterialItemParts(MaterialItemPart.external(MIParts.NUGGET, "#c:nuggets/" + n, "minecraft:" + n + "_nugget"));
        }
        res.addRecipes(ForgeHammerRecipes::apply, SmeltingRecipes::apply, StandardRecipes::apply);
        return res;
    }

    public static MaterialBuilder addVanillaGem(boolean compressor, MaterialBuilder builder) {
        return MIMaterials.addVanillaGem(compressor, builder.getMaterialName(), builder);
    }

    public static MaterialBuilder addVanillaGem(boolean compressor, String gemPath, MaterialBuilder builder) {
        String n = builder.getMaterialName();
        MaterialBuilder res = builder.addMaterialItemParts(MaterialItemPart.external(MIParts.GEM, "minecraft:" + gemPath, "minecraft:" + gemPath)).addMaterialItemParts(MaterialItemPart.external(MIParts.BLOCK, "#c:storage_blocks/" + n, "minecraft:" + n + "_block")).addMaterialItemParts(MaterialItemPart.external(MIParts.ORE, "#c:ores/" + n, "minecraft:" + n + "_ore")).addMaterialItemParts(MaterialItemPart.external(MIParts.ORE_DEEPSLATE, "minecraft:deepslate_" + n + "_ore"));
        res.addRecipes(SmeltingRecipes::apply, StandardRecipes::apply);
        if (compressor) {
            res.addRecipes(context -> new MIRecipeBuilder((MaterialBuilder.RecipeContext)context, MIMachineRecipeTypes.COMPRESSOR, n).addTaggedPartInput(MIParts.DUST, 1).addItemOutput("minecraft:" + gemPath, 1));
        }
        return res;
    }

    static {
        GOLD = MaterialRegistry.addMaterial(MIMaterials.addVanillaMetal(true, new MaterialBuilder("Gold", "gold").set(MaterialProperty.SET, MaterialSet.SHINY).set(MaterialProperty.MEAN_RGB, 16770640).set(MaterialProperty.HARDNESS, MaterialHardness.SOFT).addParts(MIParts.BOLT, MIParts.RING, MIParts.GEAR, MIParts.ROD, MIParts.CURVED_PLATE, MIParts.DOUBLE_INGOT, MIParts.DUST, MIParts.PLATE, MIParts.TINY_DUST).addParts(MIParts.DRILL_HEAD, MIParts.DRILL)));
        IRON = MaterialRegistry.addMaterial(MIMaterials.addVanillaMetal(true, new MaterialBuilder("Iron", "iron").set(MaterialProperty.SET, MaterialSet.METALLIC).set(MaterialProperty.MEAN_RGB, 0xC8C8C8).addParts(MIParts.BOLT, MIParts.RING, MIParts.GEAR, MIParts.ROD, MIParts.DOUBLE_INGOT, MIParts.DUST, MIParts.LARGE_PLATE, MIParts.PLATE, MIParts.TINY_DUST).addParts(MIParts.TANK.of(1L)).addParts(MIParts.BARREL.of(1L)).addMaterialItemParts(MaterialItemPart.external(MIParts.HAMMER, MIItem.IRON_HAMMER.getId().toString()))));
        COPPER = MaterialRegistry.addMaterial(MIMaterials.addVanillaMetal(false, new MaterialBuilder("Copper", "copper").set(MaterialProperty.SET, MaterialSet.METALLIC).set(MaterialProperty.MEAN_RGB, 15170646).set(MaterialProperty.HARDNESS, MaterialHardness.SOFT).addParts(MIParts.BOLT, MIParts.BLADE, MIParts.RING, MIParts.ROTOR, MIParts.GEAR, MIParts.ROD, MIParts.CURVED_PLATE, MIParts.DOUBLE_INGOT, MIParts.DUST, MIParts.NUGGET, MIParts.PLATE, MIParts.TINY_DUST).addParts(MIParts.WIRE).addParts(MIParts.FINE_WIRE).addParts(MIParts.CABLE.of(CableTier.LV)).addParts(MIParts.DRILL_HEAD, MIParts.DRILL)).cancelRecipes("macerator/ore_to_raw", "forge_hammer/ore_to_raw_metal", "forge_hammer/ore_to_raw_metal_with_tool", "forge_hammer/ore_to_dust_with_tool"));
        COAL = MaterialRegistry.addMaterial(MIMaterials.addVanillaGem(true, new MaterialBuilder("Coal", "coal").set(MaterialProperty.MAIN_PART, MIParts.GEM).set(MaterialProperty.SET, MaterialSet.STONE).set(MaterialProperty.MEAN_RGB, 0x282828).set(MaterialProperty.HARDNESS, MaterialHardness.SOFT).addParts(MIParts.ITEM_PURE_NON_METAL)).addRecipes(ForgeHammerRecipes::apply));
        DIAMOND = MaterialRegistry.addMaterial(MIMaterials.addVanillaGem(false, new MaterialBuilder("Diamond", "diamond").set(MaterialProperty.MAIN_PART, MIParts.GEM).set(MaterialProperty.SET, MaterialSet.SHINY).set(MaterialProperty.MEAN_RGB, 4779738).set(MaterialProperty.HARDNESS, MaterialHardness.VERY_HARD).addParts(MIParts.ITEM_PURE_NON_METAL).addParts(MIParts.PLATE, MIParts.LARGE_PLATE).addMaterialItemParts(MaterialItemPart.external(MIParts.HAMMER, MIItem.DIAMOND_HAMMER.getId().toString()))));
        EMERALD = MaterialRegistry.addMaterial(MIMaterials.addVanillaGem(false, new MaterialBuilder("Emerald", "emerald").set(MaterialProperty.MAIN_PART, MIParts.GEM).set(MaterialProperty.SET, MaterialSet.SHINY).set(MaterialProperty.MEAN_RGB, 4191109).set(MaterialProperty.HARDNESS, MaterialHardness.VERY_HARD).addParts(MIParts.ITEM_PURE_NON_METAL).addParts(MIParts.PLATE)));
        LAPIS = MaterialRegistry.addMaterial(MIMaterials.addVanillaGem(true, "lapis_lazuli", new MaterialBuilder("Lapis Lazuli", "lapis").set(MaterialProperty.MAIN_PART, MIParts.GEM).set(MaterialProperty.SET, MaterialSet.DULL).set(MaterialProperty.MEAN_RGB, 1715597).set(MaterialProperty.HARDNESS, MaterialHardness.SOFT).addParts(MIParts.ITEM_PURE_NON_METAL)).cancelRecipes("macerator/ore_to_crushed"));
        REDSTONE = MaterialRegistry.addMaterial(new MaterialBuilder("Redstone", "redstone").set(MaterialProperty.MAIN_PART, MIParts.DUST).set(MaterialProperty.SET, MaterialSet.STONE).set(MaterialProperty.MEAN_RGB, 0xD20000).set(MaterialProperty.HARDNESS, MaterialHardness.SOFT).addParts(MIParts.TINY_DUST, MIParts.CRUSHED_DUST, MIParts.BATTERY.of(CableTier.LV)).addMaterialItemParts(MaterialItemPart.external(MIParts.DUST, "minecraft:redstone", "minecraft:redstone")).addMaterialItemParts(MaterialItemPart.external(MIParts.BLOCK, "#c:storage_blocks/redstone", "minecraft:redstone_block")).addMaterialItemParts(MaterialItemPart.external(MIParts.ORE, "#c:ores/redstone", "minecraft:redstone_ore")).addMaterialItemParts(MaterialItemPart.external(MIParts.ORE_DEEPSLATE, "#c:ores/redstone", "minecraft:deepslate_redstone_ore")).addRecipes(StandardRecipes::apply, SmeltingRecipes::apply).cancelRecipes("macerator/ore_to_crushed"));
        QUARTZ = MaterialRegistry.addMaterial(new MaterialBuilder("Quartz", "quartz").set(MaterialProperty.MAIN_PART, MIParts.GEM).set(MaterialProperty.SET, MaterialSet.STONE).set(MaterialProperty.MEAN_RGB, 15789028).set(MaterialProperty.HARDNESS, MaterialHardness.SOFT).addParts(MIParts.CRUSHED_DUST, MIParts.DUST, MIParts.TINY_DUST).addParts(MIParts.ORE.of(UniformInt.of((int)2, (int)5), MaterialOreSet.QUARTZ)).addMaterialItemParts(MaterialItemPart.external(MIParts.GEM, "minecraft:quartz", "minecraft:quartz")).addRecipes(StandardRecipes::apply).cancelRecipes("macerator/ore_to_crushed").addRecipes(context -> new MIRecipeBuilder((MaterialBuilder.RecipeContext)context, MIMachineRecipeTypes.COMPRESSOR, "quartz").addTaggedPartInput(MIParts.DUST, 1).addItemOutput("minecraft:quartz", 1)));
        BRICK = MaterialRegistry.addMaterial(new MaterialBuilder("Brick", "brick").set(MaterialProperty.SET, MaterialSet.STONE).set(MaterialProperty.MEAN_RGB, 12016182).set(MaterialProperty.HARDNESS, MaterialHardness.SOFT).addParts(MIParts.DUST, MIParts.TINY_DUST).addMaterialItemParts(MaterialItemPart.external(MIParts.INGOT, "minecraft:brick", "minecraft:brick")).addRecipes(StandardRecipes::apply, SmeltingRecipes::apply));
        FIRE_CLAY = MaterialRegistry.addMaterial(new MaterialBuilder("Fire Clay", "fire_clay").set(MaterialProperty.SET, MaterialSet.STONE).set(MaterialProperty.MEAN_RGB, 12016182).set(MaterialProperty.HARDNESS, MaterialHardness.SOFT).addParts(MIParts.DUST).addMaterialItemParts(MaterialItemPart.simpleItem(MIParts.INGOT, "Fire Clay Brick", "fire_clay_brick")).addRecipes(SmeltingRecipes::apply));
        COKE = MaterialRegistry.addMaterial(new MaterialBuilder("Coke", "coke").set(MaterialProperty.MAIN_PART, MIParts.GEM).set(MaterialProperty.SET, MaterialSet.STONE).set(MaterialProperty.MEAN_RGB, 7171415).set(MaterialProperty.HARDNESS, MaterialHardness.SOFT).addParts(MIParts.DUST).addMaterialItemParts(MaterialItemPart.simpleItem(MIParts.GEM, "Coke", "coke")).addParts(MIParts.BLOCK.of(MaterialBlockSet.COAL)).addRecipes(context -> new MIRecipeBuilder((MaterialBuilder.RecipeContext)context, MIMachineRecipeTypes.COMPRESSOR, "dust").addTaggedPartInput(MIParts.DUST, 1).addPartOutput(MIParts.GEM, 1)).addRecipes(StandardRecipes::apply));
        BRONZE = MaterialRegistry.addMaterial(new MaterialBuilder("Bronze", "bronze").set(MaterialProperty.SET, MaterialSet.SHINY).set(MaterialProperty.MEAN_RGB, 0xFFCC00).set(MaterialProperty.HARDNESS, MaterialHardness.SOFT).addParts(MIParts.BOLT, MIParts.BLADE, MIParts.RING, MIParts.ROTOR, MIParts.GEAR, MIParts.ROD, MIParts.CURVED_PLATE, MIParts.DOUBLE_INGOT, MIParts.DUST, MIParts.INGOT, MIParts.NUGGET, MIParts.PLATE, MIParts.TINY_DUST).addParts(MIParts.BLOCK.of(MaterialBlockSet.COPPER)).addParts(MIParts.TANK.of(4L)).addParts(MIParts.DRILL_HEAD, MIParts.DRILL).addParts(MIParts.BARREL.of(32L)).addParts(MIParts.MACHINE_CASING.of(), MIParts.MACHINE_CASING_PIPE.of()).addParts(MIParts.MACHINE_CASING_SPECIAL.of("Bronze Plated Bricks", "bronze_plated_bricks")).addRecipes(ForgeHammerRecipes::apply, SmeltingRecipes::apply, StandardRecipes::apply));
        TIN = MaterialRegistry.addMaterial(new MaterialBuilder("Tin", "tin").set(MaterialProperty.SET, MaterialSet.DULL).set(MaterialProperty.MEAN_RGB, 12631248).set(MaterialProperty.HARDNESS, MaterialHardness.SOFT).addParts(MIParts.BOLT, MIParts.BLADE, MIParts.RING, MIParts.ROTOR, MIParts.GEAR, MIParts.ROD, MIParts.CURVED_PLATE, MIParts.DOUBLE_INGOT, MIParts.DUST, MIParts.INGOT, MIParts.NUGGET, MIParts.PLATE, MIParts.TINY_DUST).addParts(MIParts.ORE.ofAll(16, 9, 64, MaterialOreSet.IRON)).addParts(MIParts.WIRE).addParts(MIParts.RAW_METAL.ofAll(MaterialRawSet.GOLD)).addParts(MIParts.BLOCK.of(MaterialBlockSet.COPPER)).addParts(MIParts.CABLE.of(CableTier.LV)).addRecipes(ForgeHammerRecipes::apply, SmeltingRecipes::apply, StandardRecipes::apply));
        STEEL = MaterialRegistry.addMaterial(new MaterialBuilder("Steel", "steel").set(MaterialProperty.SET, MaterialSet.METALLIC).set(MaterialProperty.MEAN_RGB, 0x3F3F3F).addParts(MIParts.BOLT, MIParts.RING, MIParts.ROD, MIParts.GEAR, MIParts.CURVED_PLATE, MIParts.DOUBLE_INGOT, MIParts.DUST, MIParts.INGOT, MIParts.LARGE_PLATE, MIParts.NUGGET, MIParts.PLATE, MIParts.TINY_DUST).addParts(MIParts.ROD_MAGNETIC).addParts(MIParts.BLOCK.of(MaterialBlockSet.IRON)).addParts(MIParts.DRILL_HEAD, MIParts.DRILL).addParts(MIParts.MACHINE_CASING.of(), MIParts.MACHINE_CASING_PIPE.of()).addParts(MIParts.TANK.of(16L)).addParts(MIParts.BARREL.of(128L)).addMaterialItemParts(MaterialItemPart.external(MIParts.HAMMER, MIItem.STEEL_HAMMER.getId().toString())).addRecipes(ForgeHammerRecipes::apply, SmeltingRecipes::apply, StandardRecipes::apply));
        LIGNITE_COAL = MaterialRegistry.addMaterial(new MaterialBuilder("Lignite Coal", "lignite_coal").set(MaterialProperty.MAIN_PART, MIParts.GEM).set(MaterialProperty.SET, MaterialSet.STONE).set(MaterialProperty.MEAN_RGB, 0x644646).set(MaterialProperty.HARDNESS, MaterialHardness.SOFT).addParts(MIParts.ITEM_PURE_NON_METAL).addParts(MIParts.BLOCK.of(MaterialBlockSet.COAL)).addParts(MIParts.GEM).addParts(MIParts.ORE.ofAll(UniformInt.of((int)0, (int)2), 25, 17, 256, MaterialOreSet.COAL)).addRecipes(ForgeHammerRecipes::apply, SmeltingRecipes::apply, StandardRecipes::apply).cancelRecipes("macerator/crushed_dust").addRecipes(context -> new MIRecipeBuilder((MaterialBuilder.RecipeContext)context, MIMachineRecipeTypes.COMPRESSOR, "lignite_coal").addTaggedPartInput(MIParts.DUST, 1).addPartOutput(MIParts.GEM, 1)));
        ALUMINUM = MaterialRegistry.addMaterial(new MaterialBuilder("Aluminum", "aluminum").set(MaterialProperty.SET, MaterialSet.METALLIC).set(MaterialProperty.MEAN_RGB, 4180735).addParts(MIParts.BOLT, MIParts.BLADE, MIParts.RING, MIParts.ROTOR, MIParts.GEAR, MIParts.ROD, MIParts.CURVED_PLATE, MIParts.DOUBLE_INGOT, MIParts.DUST, MIParts.INGOT, MIParts.LARGE_PLATE, MIParts.NUGGET, MIParts.PLATE, MIParts.TINY_DUST).addParts(MIParts.WIRE).addParts(MIParts.BLOCK.of(MaterialBlockSet.GOLD)).addParts(MIParts.MACHINE_CASING.of("Advanced Machine Casing", "advanced_machine_casing")).addParts(MIParts.DRILL_HEAD, MIParts.DRILL).addParts(MIParts.MACHINE_CASING_SPECIAL.of("Frostproof Machine Casing", "frostproof_machine_casing")).addParts(MIParts.TANK.of(64L)).addParts(MIParts.BARREL.of(512L)).addParts(MIParts.CABLE.of(CableTier.HV)).addRecipes(StandardRecipes::apply).addRecipes(SmeltingRecipes::applyBlastFurnace));
        BAUXITE = MaterialRegistry.addMaterial(new MaterialBuilder("Bauxite", "bauxite").set(MaterialProperty.MAIN_PART, MIParts.DUST).set(MaterialProperty.SET, MaterialSet.DULL).set(MaterialProperty.MEAN_RGB, 13132800).set(MaterialProperty.HARDNESS, MaterialHardness.SOFT).addParts(MIParts.ITEM_PURE_NON_METAL).addParts(MIParts.BLOCK.of(MaterialBlockSet.LAPIS)).addParts(MIParts.ORE.ofAll(UniformInt.of((int)1, (int)4), 24, 7, 32, MaterialOreSet.REDSTONE)).addRecipes(StandardRecipes::apply));
        LEAD = MaterialRegistry.addMaterial(new MaterialBuilder("Lead", "lead").set(MaterialProperty.SET, MaterialSet.DULL).set(MaterialProperty.MEAN_RGB, 6977212).addParts(MIParts.DOUBLE_INGOT, MIParts.DUST, MIParts.INGOT, MIParts.NUGGET, MIParts.PLATE, MIParts.TINY_DUST).addParts(MIParts.BLOCK.of(MaterialBlockSet.COPPER)).addParts(MIParts.ORE.ofAll(32, 8, 64, MaterialOreSet.IRON)).addParts(MIParts.RAW_METAL.ofAll(MaterialRawSet.IRON)).addRecipes(StandardRecipes::apply, SmeltingRecipes::apply).cancelRecipes("macerator/raw_metal"));
        BATTERY_ALLOY = MaterialRegistry.addMaterial(new MaterialBuilder("Battery Alloy", "battery_alloy").set(MaterialProperty.SET, MaterialSet.DULL).set(MaterialProperty.MEAN_RGB, 10255520).set(MaterialProperty.HARDNESS, MaterialHardness.SOFT).addParts(MIParts.TINY_DUST, MIParts.DUST, MIParts.INGOT, MIParts.DOUBLE_INGOT, MIParts.PLATE, MIParts.CURVED_PLATE, MIParts.NUGGET).addParts(MIParts.BLOCK.of(MaterialBlockSet.IRON)).addRecipes(StandardRecipes::apply, SmeltingRecipes::apply));
        INVAR = MaterialRegistry.addMaterial(new MaterialBuilder("Invar", "invar").set(MaterialProperty.SET, MaterialSet.METALLIC).set(MaterialProperty.MEAN_RGB, 14474390).addParts(MIParts.MACHINE_CASING_SPECIAL.of("Heatproof Machine Casing", "heatproof_machine_casing")).addParts(MIParts.TINY_DUST, MIParts.DUST, MIParts.INGOT, MIParts.ROD, MIParts.DOUBLE_INGOT, MIParts.RING, MIParts.BOLT, MIParts.PLATE, MIParts.NUGGET, MIParts.GEAR).addParts(MIParts.LARGE_PLATE.withRegister((partContext, part, itemPath, itemId, itemTag, englishName) -> NuclearAbsorbable.of(englishName, itemPath, 3200, -0.009000000000000001, INeutronBehaviour.of(NuclearConstant.ScatteringType.MEDIUM, NuclearConstant.INVAR, 2.0), 20480000, SortOrder.NUCLEAR.create(NuclearOrder.LARGE_PLATE)))).addParts(MIParts.BLOCK.of(MaterialBlockSet.IRON)).addRecipes(StandardRecipes::apply, SmeltingRecipes::apply));
        CUPRONICKEL = MaterialRegistry.addMaterial(new MaterialBuilder("Cupronickel", "cupronickel").set(MaterialProperty.SET, MaterialSet.METALLIC).set(MaterialProperty.MEAN_RGB, 14915201).set(MaterialProperty.HARDNESS, MaterialHardness.SOFT).addParts(MIParts.TINY_DUST, MIParts.DUST, MIParts.INGOT, MIParts.DOUBLE_INGOT, MIParts.PLATE, MIParts.WIRE, MIParts.NUGGET, MIParts.WIRE_MAGNETIC).addParts(MIParts.COIL).addParts(MIParts.BLOCK.of(MaterialBlockSet.COPPER)).addParts(MIParts.CABLE.of(CableTier.MV)).addRecipes(StandardRecipes::apply, SmeltingRecipes::apply));
        ANTIMONY = MaterialRegistry.addMaterial(new MaterialBuilder("Antimony", "antimony").set(MaterialProperty.SET, MaterialSet.SHINY).set(MaterialProperty.MEAN_RGB, 14474480).set(MaterialProperty.HARDNESS, MaterialHardness.SOFT).addParts(MIParts.ITEM_PURE_METAL).addParts(MIParts.RAW_METAL.ofAll(MaterialRawSet.COPPER)).addParts(MIParts.BLOCK.of(MaterialBlockSet.IRON)).addParts(MIParts.ORE.ofAll(20, 5, 64, MaterialOreSet.REDSTONE)).addRecipes(StandardRecipes::apply, SmeltingRecipes::apply));
        NICKEL = MaterialRegistry.addMaterial(new MaterialBuilder("Nickel", "nickel").set(MaterialProperty.SET, MaterialSet.METALLIC).set(MaterialProperty.MEAN_RGB, 16448200).addParts(MIParts.DOUBLE_INGOT, MIParts.DUST, MIParts.INGOT, MIParts.NUGGET, MIParts.PLATE, MIParts.TINY_DUST).addParts(MIParts.RAW_METAL.ofAll(MaterialRawSet.IRON)).addParts(MIParts.BLOCK.of(MaterialBlockSet.IRON)).addParts(MIParts.ORE.ofAll(14, 6, 64, MaterialOreSet.IRON)).addRecipes(StandardRecipes::apply, SmeltingRecipes::apply));
        SILVER = MaterialRegistry.addMaterial(new MaterialBuilder("Silver", "silver").set(MaterialProperty.SET, MaterialSet.SHINY).set(MaterialProperty.MEAN_RGB, 0xDCDCFF).set(MaterialProperty.HARDNESS, MaterialHardness.SOFT).addParts(MIParts.RAW_METAL.ofAll(MaterialRawSet.GOLD)).addParts(MIParts.CABLE.of(CableTier.LV)).addParts(MIParts.DOUBLE_INGOT, MIParts.DUST, MIParts.INGOT, MIParts.NUGGET, MIParts.PLATE, MIParts.TINY_DUST, MIParts.WIRE).addParts(MIParts.BLOCK.of(MaterialBlockSet.GOLD)).addRecipes(StandardRecipes::apply, SmeltingRecipes::apply));
        SODIUM = MaterialRegistry.addMaterial(new MaterialBuilder("Sodium", "sodium").set(MaterialProperty.MAIN_PART, MIParts.DUST).set(MaterialProperty.SET, MaterialSet.STONE).set(MaterialProperty.MEAN_RGB, 466104).set(MaterialProperty.HARDNESS, MaterialHardness.SOFT).addParts(MIParts.TINY_DUST, MIParts.DUST).addParts(MIParts.BLOCK.of(MaterialBlockSet.LAPIS)).addParts(MIParts.BATTERY.of(CableTier.HV)).addRecipes(StandardRecipes::apply, SmeltingRecipes::apply));
        SALT = MaterialRegistry.addMaterial(new MaterialBuilder("Salt", "salt").set(MaterialProperty.MAIN_PART, MIParts.DUST).set(MaterialProperty.SET, MaterialSet.STONE).set(MaterialProperty.MEAN_RGB, 13096645).set(MaterialProperty.HARDNESS, MaterialHardness.SOFT).addParts(MIParts.ITEM_PURE_NON_METAL).addParts(MIParts.BLOCK.of(MaterialBlockSet.REDSTONE)).addParts(MIParts.ORE.ofAll(UniformInt.of((int)1, (int)3), 6, 6, 64, MaterialOreSet.COAL)).addRecipes(StandardRecipes::apply));
        TITANIUM = MaterialRegistry.addMaterial(new MaterialBuilder("Titanium", "titanium").set(MaterialProperty.SET, MaterialSet.METALLIC).set(MaterialProperty.MEAN_RGB, 14459120).set(MaterialProperty.HARDNESS, MaterialHardness.HARD).addParts(MIParts.BOLT, MIParts.BLADE, MIParts.RING, MIParts.ROTOR, MIParts.GEAR, MIParts.ROD, MIParts.CURVED_PLATE, MIParts.DOUBLE_INGOT, MIParts.DUST, MIParts.INGOT, MIParts.LARGE_PLATE, MIParts.NUGGET, MIParts.PLATE, MIParts.TINY_DUST).addParts(MIParts.BLOCK.of(MaterialBlockSet.NETHERITE)).addParts(MIParts.RAW_METAL.ofAll(MaterialRawSet.COPPER)).addParts(MIParts.HOT_INGOT).addParts(MIParts.MACHINE_CASING.of("Highly Advanced Machine Casing", "highly_advanced_machine_casing")).addParts(MIParts.DRILL_HEAD, MIParts.DRILL).addParts(MIParts.MACHINE_CASING_PIPE.of()).addParts(MIParts.MACHINE_CASING_SPECIAL.of("Solid Titanium Machine Casing", "solid_titanium_machine_casing")).addParts(MIParts.ORE.of(MaterialOreSet.IRON)).addParts(MIParts.TANK.of(1024L)).addParts(MIParts.BARREL.of(8192L)).addRecipes(StandardRecipes::apply).addRecipes(ctx -> SmeltingRecipes.applyBlastFurnace(ctx, true, 128, 400)).cancelRecipes("macerator/raw_metal"));
        ELECTRUM = MaterialRegistry.addMaterial(new MaterialBuilder("Electrum", "electrum").set(MaterialProperty.SET, MaterialSet.SHINY).set(MaterialProperty.MEAN_RGB, 0xFFFF64).set(MaterialProperty.HARDNESS, MaterialHardness.SOFT).addParts(MIParts.DOUBLE_INGOT, MIParts.DUST, MIParts.INGOT, MIParts.NUGGET, MIParts.PLATE, MIParts.TINY_DUST).addParts(MIParts.BLOCK.of(MaterialBlockSet.GOLD)).addParts(MIParts.WIRE, MIParts.FINE_WIRE).addParts(MIParts.CABLE.of(CableTier.MV)).addRecipes(StandardRecipes::apply, SmeltingRecipes::apply));
        SILICON = MaterialRegistry.addMaterial(new MaterialBuilder("Silicon", "silicon").set(MaterialProperty.SET, MaterialSet.METALLIC).set(MaterialProperty.MEAN_RGB, 3947600).set(MaterialProperty.HARDNESS, MaterialHardness.SOFT).addParts(MIParts.ITEM_PURE_METAL).addParts(MIParts.BLOCK.of(MaterialBlockSet.IRON)).addParts(MIParts.N_DOPED_PLATE, MIParts.P_DOPED_PLATE).addParts(MIParts.PLATE, MIParts.DOUBLE_INGOT, MIParts.BATTERY.of(CableTier.MV)).addRecipes(StandardRecipes::apply, SmeltingRecipes::apply));
        STAINLESS_STEEL = MaterialRegistry.addMaterial(new MaterialBuilder("Stainless Steel", "stainless_steel").set(MaterialProperty.SET, MaterialSet.SHINY).set(MaterialProperty.MEAN_RGB, 0xC8C8DC).set(MaterialProperty.HARDNESS, MaterialHardness.HARD).addParts(MIParts.BLOCK.of(MaterialBlockSet.IRON)).addParts(MIParts.BOLT, MIParts.BLADE, MIParts.RING, MIParts.ROTOR, MIParts.GEAR, MIParts.ROD, MIParts.CURVED_PLATE, MIParts.DOUBLE_INGOT, MIParts.DUST, MIParts.INGOT, MIParts.LARGE_PLATE, MIParts.NUGGET, MIParts.PLATE, MIParts.TINY_DUST).addParts(MIParts.HOT_INGOT).addParts(MIParts.DRILL_HEAD, MIParts.DRILL).addParts(MIParts.MACHINE_CASING.of("Turbo Machine Casing", "turbo_machine_casing")).addParts(MIParts.MACHINE_CASING_PIPE.of()).addParts(MIParts.MACHINE_CASING_SPECIAL.of("Clean Stainless Steel Machine Casing", "clean_stainless_steel_machine_casing")).addParts(MIParts.ROD_MAGNETIC).addParts(MIParts.TANK.of(256L)).addParts(MIParts.BARREL.of(2048L)).addRecipes(StandardRecipes::apply).addRecipes(ctx -> SmeltingRecipes.applyBlastFurnace(ctx, true, 32, 400)).cancelRecipes("polarizer/rod_magnetic"));
        RUBY = MaterialRegistry.addMaterial(new MaterialBuilder("Ruby", "ruby").set(MaterialProperty.SET, MaterialSet.SHINY).set(MaterialProperty.MEAN_RGB, 13697055).set(MaterialProperty.HARDNESS, MaterialHardness.HARD).addParts(MIParts.DUST, MIParts.TINY_DUST).addRecipes(StandardRecipes::apply));
        CARBON = MaterialRegistry.addMaterial(new MaterialBuilder("Carbon", "carbon").set(MaterialProperty.SET, MaterialSet.DULL).set(MaterialProperty.MEAN_RGB, 0x444444).set(MaterialProperty.HARDNESS, MaterialHardness.SOFT).addParts(MIParts.DUST, MIParts.TINY_DUST, MIParts.PLATE).addParts(MIParts.LARGE_PLATE.withRegister((partContext, part, itemPath, itemId, itemTag, englishName) -> NuclearAbsorbable.of(englishName, itemPath, 2500, 0.02, INeutronBehaviour.of(NuclearConstant.ScatteringType.MEDIUM, NuclearConstant.CARBON, 2.0), 20480000, SortOrder.NUCLEAR.create(NuclearOrder.LARGE_PLATE)))).addRecipes(context -> new MIRecipeBuilder((MaterialBuilder.RecipeContext)context, MIMachineRecipeTypes.COMPRESSOR, "dust").addTaggedPartInput(MIParts.DUST, 1).addPartOutput(MIParts.PLATE, 1)).addRecipes(StandardRecipes::apply));
        CHROMIUM = MaterialRegistry.addMaterial(new MaterialBuilder("Chromium", "chromium").set(MaterialProperty.SET, MaterialSet.SHINY).set(MaterialProperty.MEAN_RGB, 0xFFE6E6).addParts(MIParts.CRUSHED_DUST).addParts(MIParts.BLOCK.of(MaterialBlockSet.GOLD)).addParts(MIParts.ITEM_PURE_METAL).addParts(MIParts.HOT_INGOT).addParts(MIParts.PLATE, MIParts.DOUBLE_INGOT).addRecipes(StandardRecipes::apply).addRecipes(ctx -> SmeltingRecipes.applyBlastFurnace(ctx, true, 32, 400)).cancelRecipes("macerator/crushed_dust"));
        MANGANESE = MaterialRegistry.addMaterial(new MaterialBuilder("Manganese", "manganese").set(MaterialProperty.SET, MaterialSet.DULL).set(MaterialProperty.MEAN_RGB, 0xC1C1C1).addParts(MIParts.DUST, MIParts.TINY_DUST, MIParts.CRUSHED_DUST).addRecipes(StandardRecipes::apply).cancelRecipes("macerator/crushed_dust"));
        BERYLLIUM = MaterialRegistry.addMaterial(new MaterialBuilder("Beryllium", "beryllium").set(MaterialProperty.SET, MaterialSet.SHINY).set(MaterialProperty.MEAN_RGB, 0x64B464).set(MaterialProperty.HARDNESS, MaterialHardness.HARD).addParts(MIParts.BLOCK.of(MaterialBlockSet.NETHERITE)).addParts(MIParts.DOUBLE_INGOT, MIParts.DUST, MIParts.INGOT, MIParts.NUGGET, MIParts.PLATE, MIParts.TINY_DUST).addRecipes(StandardRecipes::apply));
        ANNEALED_COPPER = MaterialRegistry.addMaterial(new MaterialBuilder("Annealed Copper", "annealed_copper").set(MaterialProperty.SET, MaterialSet.SHINY).set(MaterialProperty.MEAN_RGB, 16749135).set(MaterialProperty.HARDNESS, MaterialHardness.SOFT).addParts(MIParts.ITEM_PURE_METAL).addParts(MIParts.BLOCK.of(MaterialBlockSet.COPPER)).addParts(MIParts.PLATE, MIParts.WIRE, MIParts.DOUBLE_INGOT, MIParts.HOT_INGOT).addParts(MIParts.CABLE.of(CableTier.EV)).addRecipes(StandardRecipes::apply).addRecipes(ctx -> SmeltingRecipes.applyBlastFurnace(ctx, false, 64)));
        URANIUM_235 = MaterialRegistry.addMaterial(new MaterialBuilder("Uranium 235", "uranium_235").set(MaterialProperty.SET, MaterialSet.SHINY).set(MaterialProperty.MEAN_RGB, 15073349).set(MaterialProperty.HARDNESS, MaterialHardness.VERY_HARD).set(MaterialProperty.ISOTOPE, new IsotopeFuelParams(0.6, 0.35, 2400, 900, 2300, 8.0, 0.5)).addParts(MIParts.BLOCK.of(MaterialBlockSet.GOLD)).addParts(MIParts.ITEM_PURE_METAL).addRecipes(StandardRecipes::apply).addRecipes(ctx -> SmeltingRecipes.applyBlastFurnace(ctx, 128)));
        URANIUM_238 = MaterialRegistry.addMaterial(new MaterialBuilder("Uranium 238", "uranium_238").set(MaterialProperty.SET, MaterialSet.DULL).set(MaterialProperty.MEAN_RGB, 5618995).set(MaterialProperty.HARDNESS, MaterialHardness.SOFT).set(MaterialProperty.ISOTOPE, new IsotopeFuelParams(0.6, 0.3, 3200, 1000, 3000, 6.0, 0.3)).addParts(MIParts.BLOCK.of(MaterialBlockSet.GOLD)).addParts(MIParts.ITEM_PURE_METAL).addRecipes(StandardRecipes::apply).addRecipes(ctx -> SmeltingRecipes.applyBlastFurnace(ctx, 128)));
        URANIUM = MaterialRegistry.addMaterial(new MaterialBuilder("Uranium", "uranium").set(MaterialProperty.SET, MaterialSet.DULL).set(MaterialProperty.MEAN_RGB, 3794432).set(MaterialProperty.ISOTOPE, IsotopeFuelParams.mix(URANIUM_238, URANIUM_235, 0.012345679012345678)).addParts(NuclearFuelPart.ofAll()).addParts(MIParts.ITEM_PURE_METAL).addParts(MIParts.ROD).addParts(MIParts.BLOCK.of(MaterialBlockSet.GOLD)).addParts(MIParts.ORE.ofAll(8, 5, 16, MaterialOreSet.COPPER)).addParts(MIParts.RAW_METAL.of(MaterialRawSet.URANIUM)).addParts(MIParts.RAW_METAL_BLOCK.of(MaterialRawSet.COPPER)).addRecipes(StandardRecipes::apply).addRecipes(ctx -> SmeltingRecipes.applyBlastFurnace(ctx, 128)));
        LE_URANIUM = MaterialRegistry.addMaterial(new MaterialBuilder("LE Uranium", "le_uranium").set(MaterialProperty.SET, MaterialSet.DULL).set(MaterialProperty.MEAN_RGB, 7381820).set(MaterialProperty.HARDNESS, MaterialHardness.VERY_HARD).set(MaterialProperty.ISOTOPE, IsotopeFuelParams.mix(URANIUM_238, URANIUM_235, 0.1111111111111111)).addParts(NuclearFuelPart.ofAll()).addParts(MIParts.BLOCK.of(MaterialBlockSet.GOLD)).addParts(MIParts.ITEM_PURE_METAL).addParts(MIParts.ROD).addRecipes(StandardRecipes::apply).addRecipes(ctx -> SmeltingRecipes.applyBlastFurnace(ctx, 128)));
        HE_URANIUM = MaterialRegistry.addMaterial(new MaterialBuilder("HE Uranium", "he_uranium").set(MaterialProperty.SET, MaterialSet.DULL).set(MaterialProperty.MEAN_RGB, 11200568).set(MaterialProperty.HARDNESS, MaterialHardness.VERY_HARD).set(MaterialProperty.ISOTOPE, IsotopeFuelParams.mix(URANIUM_238, URANIUM_235, 0.3333333333333333)).addParts(NuclearFuelPart.ofAll()).addParts(MIParts.BLOCK.of(MaterialBlockSet.GOLD)).addParts(MIParts.ITEM_PURE_METAL).addParts(MIParts.ROD).addRecipes(StandardRecipes::apply).addRecipes(ctx -> SmeltingRecipes.applyBlastFurnace(ctx, 128)));
        PLUTONIUM = MaterialRegistry.addMaterial(new MaterialBuilder("Plutonium", "plutonium").set(MaterialProperty.SET, MaterialSet.SHINY).set(MaterialProperty.MEAN_RGB, 14090727).set(MaterialProperty.HARDNESS, MaterialHardness.VERY_HARD).set(MaterialProperty.ISOTOPE, new IsotopeFuelParams(0.9, 0.25, 2100, 600, 2000, 9.0, 0.25)).addParts(MIParts.BLOCK.of(MaterialBlockSet.GOLD)).addParts(MIParts.ITEM_PURE_METAL).addParts(MIParts.BATTERY.of(CableTier.SUPERCONDUCTOR)).addRecipes(StandardRecipes::apply).addRecipes(ctx -> SmeltingRecipes.applyBlastFurnace(ctx, 128)));
        LE_MOX = MaterialRegistry.addMaterial(new MaterialBuilder("LE Mox", "le_mox").set(MaterialProperty.SET, MaterialSet.SHINY).set(MaterialProperty.MEAN_RGB, 59365).set(MaterialProperty.HARDNESS, MaterialHardness.VERY_HARD).set(MaterialProperty.ISOTOPE, IsotopeFuelParams.mix(URANIUM_238, PLUTONIUM, 0.1111111111111111)).addParts(MIParts.BLOCK.of(MaterialBlockSet.GOLD)).addParts(NuclearFuelPart.ofAll()).addParts(MIParts.ITEM_PURE_METAL).addParts(MIParts.ROD).addRecipes(StandardRecipes::apply).addRecipes(ctx -> SmeltingRecipes.applyBlastFurnace(ctx, 128)));
        HE_MOX = MaterialRegistry.addMaterial(new MaterialBuilder("HE Mox", "he_mox").set(MaterialProperty.SET, MaterialSet.SHINY).set(MaterialProperty.MEAN_RGB, 13404154).set(MaterialProperty.HARDNESS, MaterialHardness.VERY_HARD).set(MaterialProperty.ISOTOPE, IsotopeFuelParams.mix(URANIUM_238, PLUTONIUM, 0.3333333333333333)).addParts(MIParts.BLOCK.of(MaterialBlockSet.GOLD)).addParts(NuclearFuelPart.ofAll()).addParts(MIParts.ITEM_PURE_METAL).addParts(MIParts.ROD).addRecipes(StandardRecipes::apply).addRecipes(ctx -> SmeltingRecipes.applyBlastFurnace(ctx, 128)));
        PLATINUM = MaterialRegistry.addMaterial(new MaterialBuilder("Platinum", "platinum").set(MaterialProperty.SET, MaterialSet.SHINY).set(MaterialProperty.MEAN_RGB, 16770490).addParts(MIParts.BLOCK.of(MaterialBlockSet.GOLD)).addParts(MIParts.RAW_METAL.ofAll(MaterialRawSet.GOLD)).addParts(MIParts.ORE.of(MaterialOreSet.GOLD)).addParts(MIParts.ITEM_PURE_METAL).addParts(MIParts.PLATE, MIParts.DOUBLE_INGOT, MIParts.WIRE, MIParts.FINE_WIRE, MIParts.HOT_INGOT).addParts(MIParts.CABLE.of(CableTier.EV)).addRecipes(ctx -> SmeltingRecipes.applyBlastFurnace(ctx, true, 128, 600)).addRecipes(StandardRecipes::apply).cancelRecipes("macerator/raw_metal"));
        KANTHAL = MaterialRegistry.addMaterial(new MaterialBuilder("Kanthal", "kanthal").set(MaterialProperty.SET, MaterialSet.METALLIC).set(MaterialProperty.MEAN_RGB, 13617920).set(MaterialProperty.HARDNESS, MaterialHardness.HARD).addParts(MIParts.TINY_DUST, MIParts.DUST, MIParts.PLATE, MIParts.INGOT, MIParts.NUGGET, MIParts.WIRE, MIParts.DOUBLE_INGOT, MIParts.HOT_INGOT).addParts(MIParts.COIL).addParts(MIParts.BLOCK.of(MaterialBlockSet.COPPER)).addRecipes(ctx -> SmeltingRecipes.applyBlastFurnace(ctx, true, 32, 400)).addParts(MIParts.CABLE.of(CableTier.HV)).addRecipes(StandardRecipes::apply));
        IRIDIUM = MaterialRegistry.addMaterial(new MaterialBuilder("Iridium", "iridium").set(MaterialProperty.SET, MaterialSet.SHINY).set(MaterialProperty.MEAN_RGB, 14804725).set(MaterialProperty.HARDNESS, MaterialHardness.VERY_HARD).addParts(MIParts.BLOCK.of(MaterialBlockSet.DIAMOND)).addParts(MIParts.ITEM_PURE_METAL).addParts(MIParts.CURVED_PLATE).addParts(MIParts.ORE.ofAll(10, 1, 16, MaterialOreSet.DIAMOND)).addParts(MIParts.MACHINE_CASING.of("Quantum Machine Casing", "quantum_machine_casing", 6000.0f)).addParts(MIParts.TANK.of("Quantum Tank", "quantum_tank", Integer.MAX_VALUE)).addParts(MIParts.BARREL.of("Quantum Barrel", "quantum_barrel", Integer.MAX_VALUE)).addParts(MIParts.MACHINE_CASING_SPECIAL.of(new PartEnglishNameFormatter.Default("Plasma Handling %s Machine Casing"), "plasma_handling_iridium_machine_casing", 6000.0f)).addParts(MIParts.MACHINE_CASING_PIPE.of(6000.0f)).addParts(MIParts.RAW_METAL.of(MaterialRawSet.IRIDIUM), MIParts.PLATE).addParts(MIParts.RAW_METAL_BLOCK.of(MaterialRawSet.GOLD)).addRecipes(StandardRecipes::apply).addRecipes(SmeltingRecipes::apply).cancelRecipes("compressor/main").cancelRecipes("craft/tank").cancelRecipes("craft/barrel").cancelRecipes("assembler/tank").cancelRecipes("assembler/barrel"));
        MONAZITE = MaterialRegistry.addMaterial(new MaterialBuilder("Monazite", "monazite").set(MaterialProperty.MAIN_PART, MIParts.DUST).set(MaterialProperty.SET, MaterialSet.STONE).set(MaterialProperty.MEAN_RGB, 9839758).set(MaterialProperty.HARDNESS, MaterialHardness.SOFT).addParts(MIParts.CRUSHED_DUST, MIParts.DUST, MIParts.TINY_DUST).addParts(MIParts.BLOCK.of(MaterialBlockSet.REDSTONE)).addParts(MIParts.ORE.ofAll(UniformInt.of((int)1, (int)4), 2, 3, 24, MaterialOreSet.LAPIS)).addRecipes(StandardRecipes::apply));
        CADMIUM = MaterialRegistry.addMaterial(new MaterialBuilder("Cadmium", "cadmium").set(MaterialProperty.SET, MaterialSet.DULL).set(MaterialProperty.MEAN_RGB, 9859620).set(MaterialProperty.HARDNESS, MaterialHardness.SOFT).addParts(MIParts.DUST, MIParts.TINY_DUST, MIParts.INGOT, MIParts.PLATE, MIParts.ROD, MIParts.DOUBLE_INGOT, MIParts.BATTERY.of(CableTier.EV)).addParts(MIParts.CONTROL_ROD.of(1900, 0.5, NuclearConstant.ScatteringType.HEAVY, NuclearConstant.CADMIUM, 1.0)).addRecipes(StandardRecipes::apply, SmeltingRecipes::apply));
        NEODYMIUM = MaterialRegistry.addMaterial(new MaterialBuilder("Neodymium", "neodymium").set(MaterialProperty.MAIN_PART, MIParts.DUST).set(MaterialProperty.SET, MaterialSet.STONE).set(MaterialProperty.MEAN_RGB, 1918214).set(MaterialProperty.HARDNESS, MaterialHardness.SOFT).addParts(MIParts.BLOCK.of(MaterialBlockSet.REDSTONE)).addParts(MIParts.DUST, MIParts.TINY_DUST).addRecipes(StandardRecipes::apply));
        YTTRIUM = MaterialRegistry.addMaterial(new MaterialBuilder("Yttrium", "yttrium").set(MaterialProperty.MAIN_PART, MIParts.DUST).set(MaterialProperty.SET, MaterialSet.STONE).set(MaterialProperty.MEAN_RGB, 1266022).set(MaterialProperty.HARDNESS, MaterialHardness.SOFT).addParts(MIParts.BLOCK.of(MaterialBlockSet.REDSTONE)).addParts(MIParts.DUST, MIParts.TINY_DUST).addRecipes(StandardRecipes::apply));
        SUPERCONDUCTOR = MaterialRegistry.addMaterial(new MaterialBuilder("Superconductor", "superconductor").set(MaterialProperty.SET, MaterialSet.SHINY).set(MaterialProperty.MEAN_RGB, 8840172).set(MaterialProperty.HARDNESS, MaterialHardness.HARD).addParts(MIParts.TINY_DUST, MIParts.DUST, MIParts.PLATE, MIParts.INGOT, MIParts.NUGGET, MIParts.WIRE, MIParts.DOUBLE_INGOT, MIParts.HOT_INGOT).addParts(MIParts.COIL).addParts(MIParts.CABLE.of(CableTier.SUPERCONDUCTOR)).addRecipes(StandardRecipes::apply).cancelRecipes("craft/cable", "packer/cable", "assembler/cable_synthetic_rubber", "assembler/cable_styrene_rubber"));
        TUNGSTEN = MaterialRegistry.addMaterial(new MaterialBuilder("Tungsten", "tungsten").set(MaterialProperty.SET, MaterialSet.METALLIC).set(MaterialProperty.MEAN_RGB, 8872109).set(MaterialProperty.HARDNESS, MaterialHardness.VERY_HARD).addParts(MIParts.RAW_METAL.ofAll(MaterialRawSet.COPPER)).addParts(MIParts.TINY_DUST, MIParts.DUST, MIParts.PLATE, MIParts.INGOT, MIParts.NUGGET, MIParts.LARGE_PLATE, MIParts.DOUBLE_INGOT).addParts(MIParts.BLOCK.of(MaterialBlockSet.NETHERITE)).addParts(MIParts.ORE.ofAll(6, 5, 20, MaterialOreSet.IRON)).addRecipes(StandardRecipes::apply));
        BLASTPROOF_ALLOY = MaterialRegistry.addMaterial(new MaterialBuilder("Blastproof Alloy", "blastproof_alloy").set(MaterialProperty.SET, MaterialSet.METALLIC).set(MaterialProperty.MEAN_RGB, 5393466).set(MaterialProperty.HARDNESS, MaterialHardness.VERY_HARD).addParts(MIParts.INGOT, MIParts.PLATE, MIParts.LARGE_PLATE, MIParts.CURVED_PLATE).addParts(MIParts.MACHINE_CASING_SPECIAL.of("Blastproof Casing", "blastproof_casing", 6000.0f)).addRecipes(StandardRecipes::apply));
        NUCLEAR_ALLOY = MaterialRegistry.addMaterial(new MaterialBuilder("Nuclear Alloy", "nuclear_alloy").set(MaterialProperty.SET, MaterialSet.METALLIC).set(MaterialProperty.MEAN_RGB, 4017458).set(MaterialProperty.HARDNESS, MaterialHardness.VERY_HARD).addParts(MIParts.PLATE, MIParts.LARGE_PLATE).addParts(MIParts.MACHINE_CASING_SPECIAL.of(new PartEnglishNameFormatter.Default("%s Casing"), "nuclear_casing", 6000.0f)).addParts(MIParts.MACHINE_CASING_PIPE.of(6000.0f)).addRecipes(StandardRecipes::apply));
        SOLDERING_ALLOY = MaterialRegistry.addMaterial(new MaterialBuilder("Soldering Alloy", "soldering_alloy").set(MaterialProperty.MAIN_PART, MIParts.DUST).set(MaterialProperty.SET, MaterialSet.DULL).set(MaterialProperty.MEAN_RGB, 11257023).set(MaterialProperty.HARDNESS, MaterialHardness.SOFT).addParts(MIParts.DUST, MIParts.TINY_DUST).addParts(MIParts.BLOCK.of(MaterialBlockSet.REDSTONE)).addRecipes(StandardRecipes::apply));
        SULFUR = MaterialRegistry.addMaterial(new MaterialBuilder("Sulfur", "sulfur").set(MaterialProperty.MAIN_PART, MIParts.DUST).set(MaterialProperty.SET, MaterialSet.DULL).set(MaterialProperty.MEAN_RGB, 14530068).set(MaterialProperty.HARDNESS, MaterialHardness.SOFT).addParts(MIParts.DUST, MIParts.TINY_DUST).addParts(MIParts.BLOCK.of(MaterialBlockSet.REDSTONE)).addRecipes(StandardRecipes::apply));
        KubeJSProxy.instance.fireAddMaterialsEvent();
    }
}

