/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.multiblocks;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.machines.multiblocks.HatchType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class HatchTypes {
    private static final Map<ResourceLocation, HatchType> registeredHatches = new HashMap<ResourceLocation, HatchType>();
    public static final HatchType ITEM_INPUT = HatchTypes.register(MI.id("item_input"), MIText.ItemInputHatch);
    public static final HatchType ITEM_OUTPUT = HatchTypes.register(MI.id("item_output"), MIText.ItemOutputHatch);
    public static final HatchType FLUID_INPUT = HatchTypes.register(MI.id("fluid_input"), MIText.FluidInputHatch);
    public static final HatchType FLUID_OUTPUT = HatchTypes.register(MI.id("fluid_output"), MIText.FluidOutputHatch);
    public static final HatchType ENERGY_INPUT = HatchTypes.register(MI.id("energy_input"), MIText.EnergyInputHatch);
    public static final HatchType ENERGY_OUTPUT = HatchTypes.register(MI.id("energy_output"), MIText.EnergyOutputHatch);
    public static final HatchType NUCLEAR_ITEM = HatchTypes.register(MI.id("nuclear_item"), MI.id("nuclear_item_hatch"));
    public static final HatchType NUCLEAR_FLUID = HatchTypes.register(MI.id("nuclear_fluid"), MI.id("nuclear_fluid_hatch"));
    public static final HatchType LARGE_TANK = HatchTypes.register(MI.id("large_tank"), MI.id("large_tank_hatch"));

    public static HatchType register(ResourceLocation id, MutableComponent description) {
        if (registeredHatches.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate hatch type definition: " + String.valueOf(id));
        }
        HatchType type = new HatchType(id, (Component)description);
        registeredHatches.put(id, type);
        return type;
    }

    public static HatchType register(ResourceLocation id, MIText description) {
        return HatchTypes.register(id, description.text());
    }

    public static HatchType register(ResourceLocation id, ResourceLocation blockId) {
        if (registeredHatches.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate hatch type definition: " + String.valueOf(id));
        }
        HatchType type = new HatchType(id, blockId);
        registeredHatches.put(id, type);
        return type;
    }

    public static HatchType get(ResourceLocation id) {
        HatchType type = registeredHatches.get(id);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Hatch type \"" + String.valueOf(id) + "\" does not exist.");
    }

    public static HatchType get(String name) {
        return HatchTypes.get(ResourceLocation.isValidPath((String)name) ? MI.id(name) : ResourceLocation.parse((String)name));
    }

    public static Collection<HatchType> values() {
        return registeredHatches.values();
    }
}

