/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items;

import aztech.modern_industrialization.MIComponents;
import aztech.modern_industrialization.blocks.storage.ResourceStorage;
import aztech.modern_industrialization.items.ContainerItem;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public interface ItemContainingItemHelper
extends ContainerItem<ItemVariant> {
    default public boolean handleStackedOnOther(ItemStack stackBarrel, Slot slot, ClickAction clickType, Player player) {
        if (clickType == ClickAction.SECONDARY && slot.allowModification(player)) {
            MutableObject ref = new MutableObject((Object)slot.getItem());
            boolean result = this.handleClick(player, stackBarrel, (Mutable<ItemStack>)ref);
            slot.set((ItemStack)ref.getValue());
            return result;
        }
        return false;
    }

    default public boolean handleOtherStackedOnMe(ItemStack stackBarrel, ItemStack itemStack, Slot slot, ClickAction clickType, Player player, SlotAccess cursorStackReference) {
        if (clickType == ClickAction.SECONDARY && slot.allowModification(player)) {
            MutableObject ref = new MutableObject((Object)itemStack);
            boolean result = this.handleClick(player, stackBarrel, (Mutable<ItemStack>)ref);
            cursorStackReference.set((ItemStack)ref.getValue());
            slot.set(stackBarrel);
            return result;
        }
        return false;
    }

    default public boolean handleClick(Player player, ItemStack barrelLike, Mutable<ItemStack> otherStack) {
        ItemStack extracted;
        if (!(barrelLike.getItem() instanceof ItemContainingItemHelper)) {
            throw new AssertionError((Object)"This method should only be called on a ItemContainingItemHelper.");
        }
        ContainerItem.ItemHandler barrelHandler = new ContainerItem.ItemHandler(barrelLike, this);
        int otherCount = ((ItemStack)otherStack.getValue()).getCount();
        ItemStack leftover = barrelHandler.insertItem(0, (ItemStack)otherStack.getValue(), false);
        int insertedCount = otherCount - leftover.getCount();
        otherStack.setValue((Object)leftover);
        if (insertedCount != 0) {
            return true;
        }
        ItemStack heldStack = barrelHandler.getStackInSlot(0);
        if (!heldStack.isEmpty() && (((ItemStack)otherStack.getValue()).isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)heldStack, (ItemStack)((ItemStack)otherStack.getValue()))) && (extracted = barrelHandler.extractItem(0, heldStack.getMaxStackSize() - ((ItemStack)otherStack.getValue()).getCount(), false)).getCount() > 0) {
            extracted.grow(((ItemStack)otherStack.getValue()).getCount());
            otherStack.setValue((Object)extracted);
            return true;
        }
        return !this.isEmpty(barrelLike) || !((ItemStack)otherStack.getValue()).isEmpty();
    }

    @Override
    default public DataComponentType<ResourceStorage<ItemVariant>> getComponentType() {
        return MIComponents.ITEM_STORAGE.get();
    }

    @Override
    default public ResourceStorage<ItemVariant> getDefaultComponent() {
        return ResourceStorage.ITEM_EMPTY;
    }
}

