/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.translation;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.compat.rei.machines.MachineCategoryParams;
import aztech.modern_industrialization.compat.rei.machines.ReiMachineRecipes;
import aztech.modern_industrialization.config.MIConfigBuilder;
import aztech.modern_industrialization.datagen.tag.TagsToGenerate;
import aztech.modern_industrialization.definition.Definition;
import aztech.modern_industrialization.machines.blockentities.multiblocks.ElectricBlastFurnaceBlockEntity;
import aztech.modern_industrialization.machines.models.MachineCasings;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

public final class TranslationProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String OUTPUT_PATH = "assets/modern_industrialization/lang/en_us.json";
    private final PackOutput packOutput;
    private final Map<String, String> translationPairs = new TreeMap<String, String>();

    public TranslationProvider(PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    public void addTranslation(String key, String englishValue) {
        if (this.translationPairs.containsKey(key)) {
            throw new IllegalArgumentException(String.format("Error adding translation key %s for translation %s : already registered for translation %s", key, englishValue, this.translationPairs.get(key)));
        }
        this.translationPairs.put(key, englishValue);
    }

    private void addManualEntries() {
        this.addTranslation("block.modern_industrialization.pipe", "Pipe(s)");
        this.addTranslation("entity.minecraft.villager.modern_industrialization.industrialist", "Industrialist");
        this.addTranslation("key.categories.modern_industrialization.modern_industrialization", "Modern Industrialization");
        this.addTranslation("key.modern_industrialization.toggle_flight", "Toggle Flight");
        this.addTranslation("key.modern_industrialization.toggle_3x3", "Toggle 3x3 Mining");
        this.addTranslation("text.autoconfig.modern_industrialization.title", "Modern Industrialization Menu");
        this.addTranslation("tag.modern_industrialization.replicator_blacklist", "Replicator Blacklist");
        this.addTranslation("config.jade.plugin_modern_industrialization.overclock", "Machine Overclock");
        this.addTranslation("config.jade.plugin_modern_industrialization.pipe", "Pipe Information");
    }

    private void collectTranslationEntries() {
        this.addManualEntries();
        for (MIText entry : MIText.values()) {
            this.addTranslation(entry.getTranslationKey(), entry.getEnglishText());
            for (String additionalKey : entry.getAdditionalTranslationKey()) {
                this.addTranslation(additionalKey, entry.getEnglishText());
            }
        }
        for (Map.Entry entry : MIConfigBuilder.configTranslations.entrySet()) {
            this.addTranslation((String)entry.getKey(), (String)entry.getValue());
        }
        for (Definition definition : Definition.TRANSLATABLE_DEFINITION) {
            this.addTranslation(definition.getTranslationKey(), definition.getEnglishName());
        }
        for (Map.Entry entry : MITooltips.TOOLTIPS_ENGLISH_TRANSLATION.entrySet()) {
            this.addTranslation((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : ReiMachineRecipes.categories.entrySet()) {
            if (!((ResourceLocation)entry.getKey()).getNamespace().equals("modern_industrialization")) continue;
            this.addTranslation("rei_categories.modern_industrialization." + ((ResourceLocation)entry.getKey()).getPath(), ((MachineCategoryParams)entry.getValue()).englishName);
        }
        for (Map.Entry entry : TagsToGenerate.tagTranslations.entrySet()) {
            this.addTranslation((String)entry.getKey(), (String)entry.getValue());
        }
        for (ElectricBlastFurnaceBlockEntity.Tier tier : ElectricBlastFurnaceBlockEntity.tiers) {
            this.addTranslation(tier.getTranslationKey(), tier.englishName());
        }
        for (CableTier cableTier : CableTier.allTiers()) {
            this.addTranslation(cableTier.shortEnglishKey(), cableTier.shortEnglishName);
            this.addTranslation(cableTier.longEnglishKey(), cableTier.longEnglishName);
        }
        for (MachineCasings.CasingName casingName : MachineCasings.translations) {
            this.addTranslation(casingName.casing().getTranslationKey(), casingName.englishName());
        }
    }

    public CompletableFuture<?> run(CachedOutput output) {
        return CompletableFuture.runAsync(() -> {
            try {
                this.innerRun(output);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, Util.backgroundExecutor());
    }

    public void innerRun(CachedOutput cache) throws IOException {
        this.collectTranslationEntries();
        this.customJsonSave(cache, GSON.toJsonTree(this.translationPairs), this.packOutput.getOutputFolder().resolve(OUTPUT_PATH));
    }

    private void customJsonSave(CachedOutput cache, JsonElement jsonElement, Path path) throws IOException {
        String sortedJson = GSON.toJson(jsonElement);
        String prettyPrinted = sortedJson.replace("\\u0027", "'");
        cache.writeIfNeeded(path, prettyPrinted.getBytes(StandardCharsets.UTF_8), Hashing.sha1().hashString((CharSequence)prettyPrinted, StandardCharsets.UTF_8));
    }

    public String getName() {
        return "Translations";
    }
}

