/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.viewer.abstraction;

import java.util.List;
import net.minecraft.world.item.ItemStack;

public class ViewerPageManager {
    public final List<ItemStack> stacks;
    public final int pageSize;
    public int currentPage;

    public ViewerPageManager(List<ItemStack> stacks, int pageSize) {
        this.stacks = stacks;
        this.pageSize = pageSize;
    }

    public int totalPages() {
        return (this.stacks.size() - 1) / this.pageSize + 1;
    }

    public void scroll(int delta) {
        this.currentPage += delta;
        int totalPages = this.totalPages();
        if (this.currentPage < 0) {
            this.currentPage = totalPages - 1;
        }
        if (this.currentPage >= totalPages) {
            this.currentPage = 0;
        }
    }

    public ItemStack getStack(int index) {
        if ((index += this.pageSize * this.currentPage) < this.stacks.size()) {
            return this.stacks.get(index);
        }
        return ItemStack.EMPTY;
    }
}

