/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization;

import aztech.modern_industrialization.MIAdvancementTriggers;
import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MICapabilities;
import aztech.modern_industrialization.MIComponents;
import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MIRegistries;
import aztech.modern_industrialization.MITags;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MIVillager;
import aztech.modern_industrialization.api.datamaps.MIDataMaps;
import aztech.modern_industrialization.blocks.WrenchableBlockEntity;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelBlock;
import aztech.modern_industrialization.compat.ae2.MIAEAddon;
import aztech.modern_industrialization.compat.kubejs.KubeJSProxy;
import aztech.modern_industrialization.config.MIServerConfig;
import aztech.modern_industrialization.config.MIStartupConfig;
import aztech.modern_industrialization.datagen.MIDatagenServer;
import aztech.modern_industrialization.debug.DebugCommands;
import aztech.modern_industrialization.definition.BlockDefinition;
import aztech.modern_industrialization.definition.ItemDefinition;
import aztech.modern_industrialization.guidebook.GuidebookEvents;
import aztech.modern_industrialization.guidebook.MIGuide;
import aztech.modern_industrialization.items.DynamicToolItem;
import aztech.modern_industrialization.items.SteamDrillHooks;
import aztech.modern_industrialization.items.armor.MIArmorEffects;
import aztech.modern_industrialization.items.armor.MIArmorMaterials;
import aztech.modern_industrialization.items.armor.MIKeyMap;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.init.MultiblockHatches;
import aztech.modern_industrialization.machines.init.MultiblockMachines;
import aztech.modern_industrialization.machines.init.SingleBlockCraftingMachines;
import aztech.modern_industrialization.machines.init.SingleBlockSpecialMachines;
import aztech.modern_industrialization.machines.multiblocks.world.ChunkEventListeners;
import aztech.modern_industrialization.materials.MIMaterials;
import aztech.modern_industrialization.misc.runtime_datagen.RuntimeDataGen;
import aztech.modern_industrialization.network.MIPackets;
import aztech.modern_industrialization.nuclear.FluidNuclearComponent;
import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.proxy.CommonProxy;
import aztech.modern_industrialization.resource.GeneratedPathPackResources;
import aztech.modern_industrialization.stats.PlayerStatisticsData;
import aztech.modern_industrialization.test.framework.MIGameTests;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.BuiltInPackSource;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.RegisterGameTestsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="modern_industrialization")
public class MI {
    public static final String ID = "modern_industrialization";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Modern Industrialization");

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)path);
    }

    public MI(ModContainer modContainer, IEventBus modBus, Dist dist) {
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)MIServerConfig.SPEC);
        modContainer.registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)MIStartupConfig.SPEC);
        KubeJSProxy.checkThatKubeJsIsLoaded();
        MIAdvancementTriggers.init(modBus);
        MIComponents.init(modBus);
        MIFluids.init(modBus);
        MIBlock.init(modBus);
        MIItem.init(modBus);
        MIRegistries.init(modBus);
        MIArmorMaterials.init(modBus);
        MIMaterials.init();
        MIMachineRecipeTypes.init();
        SingleBlockCraftingMachines.init();
        SingleBlockSpecialMachines.init();
        MultiblockHatches.init();
        MultiblockMachines.init();
        KubeJSProxy.instance.fireRegisterMachinesEvent();
        MIPipes.INSTANCE.setup();
        CommonProxy.initEvents();
        ChunkEventListeners.init();
        DebugCommands.init();
        GuidebookEvents.init();
        MIGuide.init();
        MIArmorEffects.init();
        NeoForge.EVENT_BUS.addListener(PlayerEvent.PlayerChangedDimensionEvent.class, event -> MIKeyMap.clear(event.getEntity()));
        NeoForge.EVENT_BUS.addListener(PlayerEvent.PlayerLoggedOutEvent.class, event -> MIKeyMap.clear(event.getEntity()));
        NeoForge.EVENT_BUS.addListener(PlayerEvent.PlayerLoggedInEvent.class, event -> {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            MinecraftServer server = Objects.requireNonNull(player.getServer());
            PlayerStatisticsData.get(server).get((Player)player).onPlayerJoin(player);
        });
        NeoForge.EVENT_BUS.addListener(VillagerTradesEvent.class, MIVillager::init);
        NeoForge.EVENT_BUS.addListener(PlayerInteractEvent.RightClickBlock.class, event -> {
            WrenchableBlockEntity wrenchable;
            BlockEntity patt0$temp;
            if (event.getUseBlock().isFalse()) {
                return;
            }
            InteractionHand hand = event.getHand();
            BlockHitResult hitResult = event.getHitVec();
            Player player = event.getEntity();
            Level world = event.getLevel();
            if (player.isSpectator() || !event.getLevel().mayInteract(player, hitResult.getBlockPos())) {
                return;
            }
            if (player.getItemInHand(hand).is(MITags.WRENCHES) && (patt0$temp = world.getBlockEntity(hitResult.getBlockPos())) instanceof WrenchableBlockEntity && (wrenchable = (WrenchableBlockEntity)patt0$temp).useWrench(player, hand, hitResult)) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.sidedSuccess((boolean)world.isClientSide()));
            }
        });
        BarrelBlock.setupBarrelEvents();
        SteamDrillHooks.init();
        NeoForge.EVENT_BUS.addListener(AnvilUpdateEvent.class, event -> {
            if (event.getLeft().getItem() instanceof DynamicToolItem && !event.getRight().isEmpty() || !event.getLeft().isEmpty() && event.getRight().getItem() instanceof DynamicToolItem) {
                event.setCanceled(true);
                AbstractContainerMenu patt0$temp = event.getPlayer().containerMenu;
                if (patt0$temp instanceof AnvilMenu) {
                    AnvilMenu anvilMenu = (AnvilMenu)patt0$temp;
                    anvilMenu.getSlot(2).set(ItemStack.EMPTY);
                    anvilMenu.setMaximumCost(0L);
                }
            }
        });
        modBus.addListener(EntityAttributeModificationEvent.class, event -> {
            for (EntityType entityType : event.getTypes()) {
                event.add(entityType, MIRegistries.QUANTUM_ARMOR);
                event.add(entityType, MIRegistries.INFINITE_DAMAGE);
            }
        });
        NeoForge.EVENT_BUS.addListener(LivingIncomingDamageEvent.class, event -> {
            LivingEntity damager;
            Entity patt0$temp = event.getSource().getDirectEntity();
            if (patt0$temp instanceof LivingEntity && (damager = (LivingEntity)patt0$temp).getAttributeValue(MIRegistries.INFINITE_DAMAGE) > (double)1.0E-5f) {
                event.setAmount(2.1474836E9f);
            }
        });
        modBus.addListener(FMLCommonSetupEvent.class, event -> {
            MIBlock.BLOCK_DEFINITIONS.values().forEach(BlockDefinition::onRegister);
            MIItem.ITEM_DEFINITIONS.values().forEach(ItemDefinition::onRegister);
            FluidNuclearComponent.init();
        });
        modBus.addListener(GatherDataEvent.class, event -> MIDatagenServer.configure(event.getGenerator(), event.getExistingFileHelper(), event.getLookupProvider(), event.includeServer(), false));
        modBus.addListener(RegisterCapabilitiesEvent.class, MICapabilities::init);
        modBus.addListener(RegisterPayloadHandlersEvent.class, MIPackets::init);
        modBus.addListener(RegisterDataMapTypesEvent.class, event -> {
            event.register(MIDataMaps.FLUID_FUELS);
            event.register(MIDataMaps.ITEM_PIPE_UPGRADES);
            event.register(MIDataMaps.MACHINE_UPGRADES);
            event.register(MIDataMaps.ITEM_TOOLTIPS);
        });
        if (MIStartupConfig.INSTANCE.loadAe2Compat()) {
            MIAEAddon.init(modBus);
        }
        modBus.addListener(AddPackFindersEvent.class, event -> {
            if (dist == Dist.DEDICATED_SERVER && event.getPackType() == PackType.SERVER_DATA && MIStartupConfig.INSTANCE.datagenOnStartup.getAsBoolean()) {
                RuntimeDataGen.run(MIDatagenServer::configure);
            }
            if (MIStartupConfig.INSTANCE.loadRuntimeGeneratedResources.getAsBoolean()) {
                event.addRepositorySource(consumer -> consumer.accept(new Pack(new PackLocationInfo("modern_industrialization/generated", (Component)MIText.GeneratedResources.text(), PackSource.BUILT_IN, Optional.empty()), BuiltInPackSource.fixedResources((PackResources)new GeneratedPathPackResources(FMLPaths.GAMEDIR.get().resolve("modern_industrialization/generated_resources"), event.getPackType())), new Pack.Metadata((Component)MIText.GeneratedResourcesDescription.text(), PackCompatibility.COMPATIBLE, FeatureFlagSet.of(), List.of(), false), new PackSelectionConfig(true, Pack.Position.TOP, false))));
            }
        });
        modBus.addListener(RegisterGameTestsEvent.class, event -> event.register(MIGameTests.class));
        LOGGER.info("Modern Industrialization setup done!");
    }
}

