/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui.menu;

import com.simibubi.create.foundation.gui.menu.IClearableMenu;
import com.simibubi.create.foundation.gui.menu.MenuBase;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;

public abstract class GhostItemMenu<T>
extends MenuBase<T>
implements IClearableMenu {
    public ItemStackHandler ghostInventory;

    protected GhostItemMenu(MenuType<?> type, int id, Inventory inv, RegistryFriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    protected GhostItemMenu(MenuType<?> type, int id, Inventory inv, T contentHolder) {
        super(type, id, inv, contentHolder);
    }

    protected abstract ItemStackHandler createGhostInventory();

    protected abstract boolean allowRepeats();

    @Override
    protected void initAndReadInventory(T contentHolder) {
        this.ghostInventory = this.createGhostInventory();
    }

    @Override
    public void clearContents() {
        for (int i = 0; i < this.ghostInventory.getSlots(); ++i) {
            this.ghostInventory.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slotIn) {
        return slotIn.container == this.playerInventory;
    }

    public boolean canDragTo(Slot slotIn) {
        if (this.allowRepeats()) {
            return true;
        }
        return slotIn.container == this.playerInventory;
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        ItemStack insert;
        if (slotId < 36) {
            super.clicked(slotId, dragType, clickTypeIn, player);
            return;
        }
        if (clickTypeIn == ClickType.THROW) {
            return;
        }
        ItemStack held = this.getCarried();
        int slot = slotId - 36;
        if (clickTypeIn == ClickType.CLONE) {
            if (player.isCreative() && held.isEmpty()) {
                ItemStack stackInSlot = this.ghostInventory.getStackInSlot(slot).copy();
                stackInSlot.setCount(((Integer)stackInSlot.getOrDefault(DataComponents.MAX_STACK_SIZE, (Object)64)).intValue());
                this.setCarried(stackInSlot);
                return;
            }
            return;
        }
        if (held.isEmpty()) {
            insert = ItemStack.EMPTY;
        } else {
            insert = held.copy();
            insert.setCount(1);
        }
        this.ghostInventory.setStackInSlot(slot, insert);
        this.getSlot(slotId).setChanged();
    }

    protected boolean moveItemStackTo(ItemStack pStack, int pStartIndex, int pEndIndex, boolean pReverseDirection) {
        return false;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        if (index < 36) {
            ItemStack stackToInsert = this.playerInventory.getItem(index);
            for (int i = 0; i < this.ghostInventory.getSlots(); ++i) {
                ItemStack stack = this.ghostInventory.getStackInSlot(i);
                if (this.allowRepeats() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)stackToInsert)) {
                    if (!stack.isEmpty()) continue;
                    ItemStack copy = stackToInsert.copy();
                    copy.setCount(1);
                    this.ghostInventory.insertItem(i, copy, false);
                    this.getSlot(i + 36).setChanged();
                }
                break;
            }
        } else {
            this.ghostInventory.extractItem(index - 36, 1, false);
            this.getSlot(index).setChanged();
        }
        return ItemStack.EMPTY;
    }
}

