/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.util;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.lucene.ars_nouveau.util.BytesRef;

public abstract class BytesRefComparator
implements Comparator<BytesRef> {
    public static final BytesRefComparator NATURAL = new BytesRefComparator(Integer.MAX_VALUE){

        @Override
        protected int byteAt(BytesRef ref, int i) {
            if (ref.length <= i) {
                return -1;
            }
            return ref.bytes[ref.offset + i] & 0xFF;
        }

        @Override
        public int compare(BytesRef o1, BytesRef o2, int k) {
            return Arrays.compareUnsigned(o1.bytes, o1.offset + k, o1.offset + o1.length, o2.bytes, o2.offset + k, o2.offset + o2.length);
        }
    };
    final int comparedBytesCount;

    protected BytesRefComparator(int comparedBytesCount) {
        this.comparedBytesCount = comparedBytesCount;
    }

    protected abstract int byteAt(BytesRef var1, int var2);

    @Override
    public final int compare(BytesRef o1, BytesRef o2) {
        return this.compare(o1, o2, 0);
    }

    public int compare(BytesRef o1, BytesRef o2, int k) {
        for (int i = k; i < this.comparedBytesCount; ++i) {
            int b2;
            int b1 = this.byteAt(o1, i);
            if (b1 != (b2 = this.byteAt(o2, i))) {
                return b1 - b2;
            }
            if (b1 == -1) break;
        }
        return 0;
    }
}

