/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.mob_jar;

import com.hollingsworth.arsnouveau.api.mob_jar.JarBehavior;
import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class SnifferBehavior
extends JarBehavior<Sniffer> {
    @Override
    public Vec3 scaleOffset(MobJarTile pBlockEntity) {
        float scale = -0.45f;
        return new Vec3((double)scale, (double)scale, (double)scale);
    }

    @Override
    public void tick(MobJarTile tile) {
        Level level = tile.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        Sniffer sniffer = (Sniffer)this.entityFromJar(tile);
        int dropTime = Math.max(9600, (Integer)sniffer.getEntityData().get(Sniffer.DATA_DROP_SEED_AT_TICK));
        if (!this.isEntityBaby((Entity)sniffer) && dropTime <= sniffer.tickCount) {
            sniffer.getEntityData().set(Sniffer.DATA_DROP_SEED_AT_TICK, (Object)(sniffer.tickCount + 9600));
            level2.broadcastEntityEvent((Entity)sniffer, (byte)63);
            LootTable loottable = level2.getServer().reloadableRegistries().getLootTable(BuiltInLootTables.SNIFFER_DIGGING);
            LootParams lootparams = new LootParams.Builder(level2).withParameter(LootContextParams.ORIGIN, (Object)sniffer.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)sniffer).create(LootContextParamSets.GIFT);
            for (ItemStack stack : loottable.getRandomItems(lootparams)) {
                JarBehavior.insertOrCreateItem(tile, stack);
            }
            sniffer.playSound(SoundEvents.SNIFFER_DROP_SEED, 1.0f, 1.0f);
        }
        ++sniffer.tickCount;
    }
}

