/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.familiar;

import com.hollingsworth.arsnouveau.api.scrying.CompoundScryer;
import com.hollingsworth.arsnouveau.api.scrying.TagScryer;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarEntity;
import com.hollingsworth.arsnouveau.common.ritual.RitualScrying;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import java.util.Arrays;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class FamiliarStarbuncle
extends FamiliarEntity {
    public FamiliarStarbuncle(EntityType<? extends PathfinderMob> ent, Level world) {
        super(ent, world);
        this.entityData.set(COLOR, (Object)DyeColor.ORANGE.getName());
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level.isClientSide && this.level.getGameTime() % 60L == 0L && this.getOwner() != null) {
            this.getOwner().addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 600, 1, false, false, true));
            this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 600, 1, false, false, true));
        }
    }

    @Override
    @NotNull
    protected InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        if (!player.level.isClientSide && player.equals((Object)this.getOwner())) {
            ItemStack stack = player.getItemInHand(hand);
            if (stack.is(Tags.Items.NUGGETS_GOLD)) {
                if (!player.hasInfiniteMaterials()) {
                    stack.shrink(1);
                }
                RitualScrying.grantScrying((ServerPlayer)player, 3600, new CompoundScryer(new TagScryer((TagKey<Block>)Tags.Blocks.ORES_GOLD), new TagScryer((TagKey<Block>)BlockTags.GOLD_ORES)));
                return InteractionResult.SUCCESS;
            }
            if (player.getMainHandItem().is(Tags.Items.DYES)) {
                DyeColor color = DyeColor.getColor((ItemStack)stack);
                if (color == null || ((String)this.entityData.get(COLOR)).equals(color.getName()) || !Arrays.asList(Starbuncle.carbyColors).contains(color.getName())) {
                    return InteractionResult.SUCCESS;
                }
                this.setColor(color);
                return InteractionResult.SUCCESS;
            }
        }
        return super.mobInteract(player, hand);
    }

    @Override
    public PlayState walkPredicate(AnimationState<? extends FamiliarEntity> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("run"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
    }

    @Override
    public ResourceLocation getTexture() {
        ResourceLocation nameTexture = Starbuncle.TEXTURES.get(this.getName().getString());
        if (nameTexture != null) {
            return nameTexture;
        }
        String color = this.getColor();
        if (color.isEmpty()) {
            color = DyeColor.ORANGE.getName();
        }
        return Starbuncle.TEXTURES.get(color);
    }

    public ResourceLocation getModel() {
        String key = this.getName().getString();
        return Starbuncle.MODELS.getOrDefault(key, Starbuncle.MODELS.get("starbuncle"));
    }

    @NotNull
    public EntityType<?> getType() {
        return (EntityType)ModEntities.ENTITY_FAMILIAR_STARBUNCLE.get();
    }
}

