/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.google.common.collect.EvictingQueue;
import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.item.inv.ExtractedStack;
import com.hollingsworth.arsnouveau.api.item.inv.FilterSet;
import com.hollingsworth.arsnouveau.api.item.inv.FilterableItemHandler;
import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.item.inv.MultiExtractedReference;
import com.hollingsworth.arsnouveau.api.item.inv.MultiInsertReference;
import com.hollingsworth.arsnouveau.api.item.inv.SlotCache;
import com.hollingsworth.arsnouveau.api.item.inv.SlotReference;
import com.hollingsworth.arsnouveau.api.item.inv.StorageItemHandler;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.container.SortSettings;
import com.hollingsworth.arsnouveau.client.container.StorageTerminalMenu;
import com.hollingsworth.arsnouveau.client.container.StoredItemStack;
import com.hollingsworth.arsnouveau.client.particle.ColorPos;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.tile.CraftingLecternTile;
import com.hollingsworth.arsnouveau.common.block.tile.LecternInvWrapper;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.block.tile.RepositoryCatalogTile;
import com.hollingsworth.arsnouveau.common.datagen.BlockTagProvider;
import com.hollingsworth.arsnouveau.common.entity.EntityBookwyrm;
import com.hollingsworth.arsnouveau.common.entity.goal.bookwyrm.TransferTask;
import com.hollingsworth.arsnouveau.common.util.ANCodecs;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.config.ServerConfig;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class StorageLecternTile
extends ModdedTile
implements MenuProvider,
ITickable,
IWandable,
ITooltipProvider,
ICapabilityProvider<CraftingLecternTile, Direction, IItemHandler> {
    public Map<String, List<HandlerPos>> tabManagerMap = new HashMap<String, List<HandlerPos>>();
    public Map<String, Map<StoredItemStack, Long>> itemsByTab = new HashMap<String, Map<StoredItemStack, Long>>();
    public Map<Item, Long> itemCounts = new HashMap<Item, Long>();
    public Map<UUID, String> searches = new HashMap<UUID, String>();
    public boolean updateItems;
    public List<HandlerPos> handlerPosList = new ArrayList<HandlerPos>();
    public SortSettings sortSettings = new SortSettings();
    public BlockPos mainLecternPos;
    public List<UUID> bookwyrmUUIDs = new ArrayList<UUID>();
    public int backoffTicks;
    public int checkPlayerRangeTicks;
    public boolean canCreateTasks = false;
    public static final String TAB_ALL = "8f6fe318-4ca6-4b29-ab63-15ec5289f5c9";
    public boolean invalidateNextTick;
    public Queue<TransferTask> transferTasks = EvictingQueue.create((int)10);
    IItemHandler lecternInvWrapper;
    public boolean powered;

    public StorageLecternTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistry.CRAFTING_LECTERN_TILE.get(), pos, state);
    }

    public StorageLecternTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public InventoryManager getInvManager(@Nullable String tab) {
        List handlers = tab == null || tab.isEmpty() ? (List)this.tabManagerMap.getOrDefault(TAB_ALL, new ArrayList()) : (List)this.tabManagerMap.getOrDefault(tab, new ArrayList());
        ArrayList<FilterableItemHandler> itemHandlers = new ArrayList<FilterableItemHandler>();
        for (HandlerPos handler : handlers) {
            Nameable nameable;
            BlockEntity blockEntity;
            boolean isAnyTab;
            if (!this.level.isLoaded(handler.pos) || !this.isValidInv(handler.pos) || handler.handler == null || handler.handler.getCapability() == null) continue;
            boolean bl = isAnyTab = tab == null || tab.isEmpty();
            if (!isAnyTab && (!((blockEntity = this.level.getBlockEntity(handler.pos)) instanceof Nameable) || !(nameable = (Nameable)blockEntity).hasCustomName() || !nameable.getCustomName().getString().trim().equals(tab.trim()))) continue;
            itemHandlers.add(new FilterableItemHandler((IItemHandler)handler.handler.getCapability(), FilterSet.forPosition(this.level, handler.pos)).withSlotCache(handler.slotCache));
        }
        return new InventoryManager(itemHandlers);
    }

    public AbstractContainerMenu createMenu(int id, Inventory plInv, Player arg2) {
        return new StorageTerminalMenu(id, plInv, this);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"ars_nouveau.storage_lectern");
    }

    public Map<StoredItemStack, Long> getStacks(@Nullable String tabName) {
        this.updateItems = true;
        if (tabName == null || tabName.isEmpty()) {
            return this.itemsByTab.getOrDefault(TAB_ALL, new HashMap());
        }
        return this.itemsByTab.getOrDefault(tabName, this.itemsByTab.getOrDefault(TAB_ALL, new HashMap()));
    }

    public List<String> getTabNames() {
        ArrayList<String> tabNames = new ArrayList<String>();
        for (HandlerPos handlerPos : this.handlerPosList) {
            String tabName;
            Nameable provider;
            BlockPos pos = handlerPos.pos;
            BlockCapabilityCache<? extends IItemHandler, Direction> capCache = handlerPos.handler;
            BlockEntity tile = this.level.getBlockEntity(pos);
            if (capCache == null || capCache.getCapability() == null || !(tile instanceof Nameable) || !(provider = (Nameable)tile).hasCustomName() || (tabName = provider.getCustomName().getString().trim()).isEmpty()) continue;
            tabNames.add(provider.getDisplayName().getString());
        }
        return tabNames;
    }

    public StoredItemStack pullStack(StoredItemStack stack, int max, @Nullable String tabName) {
        if (stack == null || max <= 0) {
            return null;
        }
        ItemStack st = stack.getStack();
        MultiExtractedReference pulled = this.getInvManager(tabName).extractItemFromAll(st, max, true);
        if (pulled.getExtracted().isEmpty()) {
            return null;
        }
        this.addExtractTasks(pulled);
        return new StoredItemStack(pulled.getExtracted());
    }

    private void addExtractTasks(MultiExtractedReference multiSlotReference) {
        if (multiSlotReference.getExtracted().isEmpty() || !this.canCreateTasks) {
            return;
        }
        for (ExtractedStack extractedStack : multiSlotReference.getSlots()) {
            BlockPos pos = this.posFromSlotRef(extractedStack);
            if (pos == null) continue;
            this.addTransferTask(new TransferTask(pos, this.getBlockPos(), extractedStack.stack, this.level.getGameTime()));
        }
    }

    private void addInsertTasks(ItemStack stack, MultiInsertReference reference) {
        if (reference.isEmpty() || stack.isEmpty() || !this.canCreateTasks) {
            return;
        }
        for (SlotReference extractedStack : reference.getSlots()) {
            BlockPos pos = this.posFromSlotRef(extractedStack);
            if (pos == null) continue;
            this.addTransferTask(new TransferTask(this.getBlockPos(), pos, stack, this.level.getGameTime()));
        }
    }

    private BlockPos posFromSlotRef(SlotReference extractedStack) {
        for (HandlerPos handlerPos : this.handlerPosList) {
            if (handlerPos.handler == null || handlerPos.handler.getCapability() == null || !((IItemHandler)handlerPos.handler.getCapability()).equals((Object)extractedStack.getHandler())) continue;
            BlockEntity blockEntity = this.level.getBlockEntity(handlerPos.pos);
            if (blockEntity instanceof RepositoryCatalogTile) {
                RepositoryCatalogTile controllerTile = (RepositoryCatalogTile)blockEntity;
                if (controllerTile.connectedRepositories.isEmpty()) {
                    return null;
                }
                if ((double)this.level.random.nextFloat() > 0.9) {
                    return controllerTile.connectedRepositories.get((int)this.level.random.nextInt((int)controllerTile.connectedRepositories.size())).pos;
                }
            }
            return handlerPos.pos;
        }
        return null;
    }

    public void addTransferTask(TransferTask task) {
        if (!this.canCreateTasks) {
            return;
        }
        this.transferTasks.add(task);
    }

    @Nullable
    public TransferTask getTransferTask() {
        ArrayList<TransferTask> staleTasks = new ArrayList<TransferTask>();
        TransferTask task = null;
        Iterator iterator = this.transferTasks.iterator();
        if (iterator.hasNext()) {
            TransferTask transferTask = (TransferTask)iterator.next();
            if (this.level.getGameTime() - transferTask.gameTime > 200L) {
                staleTasks.add(transferTask);
            }
            task = transferTask;
            staleTasks.add(transferTask);
        }
        this.transferTasks.removeAll(staleTasks);
        return task;
    }

    public StoredItemStack pushStack(StoredItemStack stack, @Nullable String tab) {
        if (stack == null) {
            return null;
        }
        ItemStack copyStack = stack.getActualStack().copy();
        MultiInsertReference reference = this.getInvManager(tab).insertStackWithReference(stack.getActualStack());
        ItemStack remaining = reference.getRemainder();
        if (!reference.isEmpty()) {
            this.addInsertTasks(copyStack, reference);
        }
        if (remaining.isEmpty()) {
            return null;
        }
        return new StoredItemStack(remaining);
    }

    public ItemStack pushStack(ItemStack itemstack, @Nullable String tab) {
        StorageLecternTile mainLectern = this.getMainLectern();
        if (mainLectern == null) {
            return itemstack;
        }
        StoredItemStack is = mainLectern.pushStack(new StoredItemStack(itemstack), tab);
        return is == null ? ItemStack.EMPTY : is.getActualStack();
    }

    public void pushOrDrop(ItemStack st, @Nullable String tabName) {
        if (st.isEmpty()) {
            return;
        }
        StoredItemStack st0 = this.pushStack(new StoredItemStack(st), tabName);
        if (st0 != null) {
            Containers.dropItemStack((Level)this.level, (double)((float)this.worldPosition.getX() + 0.5f), (double)((float)this.worldPosition.getY() + 0.5f), (double)((float)this.worldPosition.getZ() + 0.5f), (ItemStack)st0.getActualStack());
        }
    }

    @Override
    public void onWanded(Player playerEntity) {
        this.mainLecternPos = null;
        this.updateBlock();
    }

    @Override
    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable Direction side, @Nullable LivingEntity storedEntity, Player playerEntity) {
        if (storedPos == null || this.level == null) {
            return;
        }
        BlockEntity tile = this.level.getBlockEntity(storedPos);
        if (tile instanceof StorageLecternTile) {
            StorageLecternTile newMasterLectern = (StorageLecternTile)tile;
            return;
        }
        if (!this.isValidInv(storedPos)) {
            playerEntity.sendSystemMessage((Component)Component.translatable((String)"ars_nouveau.lectern_blacklist"));
            return;
        }
        IItemHandler handler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, storedPos, (Object)side);
        if (handler == null) {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.storage.no_tile"));
            return;
        }
        if (BlockUtil.distanceFrom(storedPos, this.worldPosition) > (double)((Integer)ServerConfig.LECTERN_LINK_RANGE.get()).intValue()) {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.storage.inv_too_far", (Object[])new Object[]{ServerConfig.LECTERN_LINK_RANGE.get()}));
            return;
        }
        if (this.getBlockPos().equals((Object)storedPos)) {
            return;
        }
        if (this.handlerPosList.stream().anyMatch(handlerPos -> handlerPos.pos.equals((Object)storedPos))) {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.storage.removed"));
            this.handlerPosList.removeIf(handlerPos -> handlerPos.pos().equals((Object)storedPos));
            this.invalidateCapabilities();
        } else {
            if (!playerEntity.isCreative() && this.handlerPosList.size() >= this.getMaxConnectedInventories()) {
                PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.storage.too_many"));
                return;
            }
            this.addHandlerPos(this, storedPos);
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.storage.from_set"));
        }
        this.mainLecternPos = null;
        this.updateBlock();
        this.updateItems = true;
    }

    @Override
    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable Direction side, @Nullable LivingEntity storedEntity, Player playerEntity) {
        if (storedPos == null || storedPos.equals((Object)this.worldPosition) || this.level == null) {
            return;
        }
        BlockEntity tile = this.level.getBlockEntity(storedPos);
        if (!(tile instanceof StorageLecternTile)) {
            return;
        }
        if (BlockUtil.distanceFrom(storedPos, this.worldPosition) > (double)((Integer)ServerConfig.LECTERN_LINK_RANGE.get()).intValue()) {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.storage.lectern_too_far", (Object[])new Object[]{ServerConfig.LECTERN_LINK_RANGE.get()}));
            return;
        }
        this.mainLecternPos = storedPos.immutable();
        this.handlerPosList = new ArrayList<HandlerPos>();
        this.invalidateCapabilities();
        PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.storage.lectern_chained", (Object[])new Object[]{storedPos.getX(), storedPos.getY(), storedPos.getZ()}));
        this.updateBlock();
    }

    @Override
    public List<ColorPos> getWandHighlight(List<ColorPos> list) {
        if (this.mainLecternPos != null) {
            list.add(ColorPos.centered(this.mainLecternPos, ParticleColor.TO_HIGHLIGHT));
            return list;
        }
        for (HandlerPos pos : this.handlerPosList) {
            list.add(ColorPos.centered(pos.pos, ParticleColor.FROM_HIGHLIGHT));
        }
        for (EntityBookwyrm bookwyrm : this.getBookwyrmEntities()) {
            list.add(ColorPos.centered(bookwyrm.blockPosition(), ParticleColor.GREEN));
        }
        return list;
    }

    @Override
    public void tick() {
        if (this.level.isClientSide) {
            return;
        }
        if (this.backoffTicks > 0) {
            --this.backoffTicks;
        }
        if (!this.powered && this.backoffTicks <= 0 && this.level.getGameTime() % 20L == 0L) {
            this.insertNearbyItems();
        }
        if (this.checkPlayerRangeTicks > 0) {
            --this.checkPlayerRangeTicks;
        }
        if (this.checkPlayerRangeTicks <= 0) {
            this.checkPlayerRangeTicks = 60 + this.level.random.nextInt(5);
            this.canCreateTasks = false;
            ServerLevel serverLevel = (ServerLevel)this.level;
            for (ServerPlayer serverPlayer : serverLevel.players()) {
                if (!(BlockUtil.distanceFrom(serverPlayer.position(), this.getBlockPos()) < 40.0)) continue;
                this.canCreateTasks = true;
                break;
            }
        }
        if (this.invalidateNextTick) {
            this.invalidateCapabilities();
            this.invalidateNextTick = false;
        }
        if (this.updateItems) {
            this.updateItems();
            this.updateItems = false;
        }
    }

    public void updateItems() {
        this.itemsByTab.clear();
        this.tabManagerMap.clear();
        HashMap<String, List> mappedFilterables = new HashMap<String, List>();
        this.itemsByTab.put(TAB_ALL, new HashMap());
        for (HandlerPos handlerPos : this.handlerPosList) {
            Nameable nameable;
            IItemHandler handler;
            BlockPos pos = handlerPos.pos;
            if (!this.isValidInv(pos) || handlerPos.handler == null || (handler = (IItemHandler)handlerPos.handler.getCapability()) == null) continue;
            StorageItemHandler storageItemHandler = new StorageItemHandler(handler, FilterSet.forPosition(this.level, pos), handlerPos.slotCache);
            mappedFilterables.computeIfAbsent(TAB_ALL, s -> new ArrayList()).add(storageItemHandler);
            BlockEntity blockEntity = this.level.getBlockEntity(pos);
            if (blockEntity instanceof Nameable && (nameable = (Nameable)blockEntity).hasCustomName()) {
                String tabName = nameable.getCustomName().getString();
                mappedFilterables.computeIfAbsent(tabName, s -> new ArrayList()).add(storageItemHandler);
                this.tabManagerMap.computeIfAbsent(tabName, key -> new ArrayList()).add(handlerPos);
            }
            this.tabManagerMap.computeIfAbsent(TAB_ALL, key -> new ArrayList()).add(handlerPos);
        }
        for (String tabName : mappedFilterables.keySet()) {
            this.itemsByTab.computeIfAbsent(tabName, key -> new HashMap()).clear();
            for (FilterableItemHandler filterableItemHandler : (List)mappedFilterables.get(tabName)) {
                IItemHandler handler = filterableItemHandler.getHandler();
                if (handler == null) continue;
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    if (stack.isEmpty()) continue;
                    StoredItemStack storedItemStack = new StoredItemStack(stack);
                    this.itemsByTab.get(tabName).merge(storedItemStack, storedItemStack.getQuantity(), Long::sum);
                }
            }
        }
        this.itemCounts = new HashMap<Item, Long>();
        Map<StoredItemStack, Long> allItems = this.itemsByTab.get(TAB_ALL);
        for (StoredItemStack stack : allItems.keySet()) {
            this.itemCounts.put(stack.getStack().getItem(), allItems.get(stack));
        }
    }

    public List<EntityBookwyrm> getBookwyrmEntities() {
        ArrayList<EntityBookwyrm> bookwyrmEntities = new ArrayList<EntityBookwyrm>();
        ArrayList<UUID> staleUUIDs = new ArrayList<UUID>();
        for (UUID uuid : this.bookwyrmUUIDs) {
            Level level = this.level;
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entity = serverLevel.getEntity(uuid);
            if (entity instanceof EntityBookwyrm) {
                EntityBookwyrm bookwyrm = (EntityBookwyrm)entity;
                bookwyrmEntities.add(bookwyrm);
                continue;
            }
            staleUUIDs.add(uuid);
        }
        this.bookwyrmUUIDs.removeAll(staleUUIDs);
        return bookwyrmEntities;
    }

    public void insertNearbyItems() {
        StorageLecternTile mainLectern = this.getMainLectern();
        if (mainLectern == null) {
            return;
        }
        for (Direction dir : Direction.values()) {
            HopperBlockEntity hopperBlockEntity;
            BlockEntity blockEntity;
            IItemHandler handler;
            BlockPos pos = this.worldPosition.relative(dir);
            if (this.level.getBlockState(pos).is(BlockTagProvider.AUTOPULL_DISABLED) || !this.isValidInv(pos) || mainLectern.handlerPosList.stream().anyMatch(p -> p.pos.equals((Object)pos)) || (handler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) == null || (blockEntity = this.level.getBlockEntity(pos)) instanceof HopperBlockEntity && (hopperBlockEntity = (HopperBlockEntity)blockEntity).getBlockPos().equals((Object)this.worldPosition.below())) continue;
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack remainder;
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                ItemStack extractedStack = handler.extractItem(i, stack.getMaxStackSize(), false);
                ItemStack remaining = mainLectern.pushStack(extractedStack, null);
                if (!remaining.isEmpty() && !(remainder = handler.insertItem(i, remaining, false)).isEmpty()) {
                    Containers.dropItemStack((Level)this.level, (double)((float)this.worldPosition.getX() + 0.5f), (double)((float)this.worldPosition.getY() + 0.5f), (double)((float)this.worldPosition.getZ() + 0.5f), (ItemStack)remainder);
                }
                return;
            }
        }
        this.backoffTicks = 100 + this.level.random.nextInt(20);
    }

    public void removeBookwyrm(EntityBookwyrm bookwyrm) {
        this.bookwyrmUUIDs.remove(bookwyrm.getUUID());
        this.updateBlock();
    }

    public boolean canInteractWith(Player player) {
        return !this.isRemoved();
    }

    public boolean openMenu(Player player) {
        StorageLecternTile mainLectern = this.getMainLectern();
        if (mainLectern == null) {
            return false;
        }
        player.openMenu((MenuProvider)mainLectern);
        return true;
    }

    @Nullable
    public StorageLecternTile getMainLectern() {
        return this.getMainLectern(new ArrayList<BlockPos>());
    }

    @Nullable
    public StorageLecternTile getMainLectern(List<BlockPos> visitedPos) {
        BlockEntity blockEntity;
        if (this.mainLecternPos == null) {
            return this;
        }
        if (visitedPos.contains(this.mainLecternPos)) {
            return null;
        }
        visitedPos.add(this.mainLecternPos);
        if (this.level.isLoaded(this.mainLecternPos) && (blockEntity = this.level.getBlockEntity(this.mainLecternPos)) instanceof StorageLecternTile) {
            StorageLecternTile storageTerminalBlockEntity = (StorageLecternTile)blockEntity;
            return storageTerminalBlockEntity.getMainLectern(visitedPos);
        }
        return null;
    }

    public void setSorting(SortSettings sortSettings) {
        this.sortSettings = sortSettings;
        this.updateBlock();
    }

    public int getMaxConnectedInventories() {
        return this.getBookwyrmEntities().size() * (Integer)Config.BOOKWYRM_LIMIT.get();
    }

    @Nullable
    public EntityBookwyrm addBookwyrm() {
        if (this.level.isClientSide) {
            return null;
        }
        EntityBookwyrm bookwyrm = new EntityBookwyrm(this.level, this.getBlockPos());
        bookwyrm.setPos((double)this.getBlockPos().getX() + 0.5, this.getBlockPos().getY() + 1, (double)this.getBlockPos().getZ() + 0.5);
        this.level.addFreshEntity((Entity)bookwyrm);
        this.bookwyrmUUIDs.add(bookwyrm.getUUID());
        this.updateBlock();
        return bookwyrm;
    }

    public boolean isValidInv(BlockPos pos) {
        return !(this.level.getBlockEntity(pos) instanceof StorageLecternTile) && !this.level.getBlockState(pos).is(BlockTagProvider.LECTERN_BLACKLIST);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.saveAdditional(compound, pRegistries);
        compound.put("settings", ANCodecs.encode(SortSettings.CODEC, this.sortSettings));
        ListTag list = new ListTag();
        for (HandlerPos handlerPos : this.handlerPosList) {
            BlockPos pos = handlerPos.pos;
            CompoundTag c = new CompoundTag();
            c.putInt("x", pos.getX());
            c.putInt("y", pos.getY());
            c.putInt("z", pos.getZ());
            list.add((Object)c);
        }
        compound.put("invs", (Tag)list);
        if (this.mainLecternPos != null) {
            compound.putLong("mainLecternPos", this.mainLecternPos.asLong());
        }
        ListTag bookwyrmList = new ListTag();
        for (UUID uuid : this.bookwyrmUUIDs) {
            bookwyrmList.add((Object)NbtUtils.createUUID((UUID)uuid));
        }
        compound.put("bookwyrmUUIDs", (Tag)bookwyrmList);
        compound.putBoolean("powered", this.powered);
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        if (compound.contains("settings")) {
            this.sortSettings = ANCodecs.decode(SortSettings.CODEC, (Tag)compound.getCompound("settings"));
        }
        ListTag list = compound.getList("invs", 10);
        this.handlerPosList.clear();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag c = list.getCompound(i);
            this.handlerPosList.add(new HandlerPos(new BlockPos(c.getInt("x"), c.getInt("y"), c.getInt("z")), null));
        }
        this.mainLecternPos = null;
        if (compound.contains("mainLecternPos")) {
            this.mainLecternPos = BlockPos.of((long)compound.getLong("mainLecternPos"));
        }
        this.bookwyrmUUIDs.clear();
        if (compound.contains("bookwyrmUUIDs")) {
            ListTag bookwyrmList = compound.getList("bookwyrmUUIDs", 11);
            for (Tag tag : bookwyrmList) {
                this.bookwyrmUUIDs.add(NbtUtils.loadUUID((Tag)tag));
            }
        }
        this.updateItems = true;
        this.powered = compound.getBoolean("powered");
    }

    public void onLoad() {
        super.onLoad();
        this.initHandlerCache();
    }

    public String getLastSearch(Player player) {
        return this.searches.getOrDefault(player.getUUID(), "");
    }

    public void setLastSearch(Player sender, String string) {
        this.searches.put(sender.getUUID(), string);
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        if (this.mainLecternPos != null) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.storage.lectern_chained", (Object[])new Object[]{this.mainLecternPos.getX(), this.mainLecternPos.getY(), this.mainLecternPos.getZ()}));
        } else {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.storage.num_connected", (Object[])new Object[]{this.handlerPosList.size()}));
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.storage.num_bookwyrms", (Object[])new Object[]{this.bookwyrmUUIDs.size()}));
        }
    }

    public List<IItemHandler> getConnectedHandlers() {
        StorageLecternTile lecternTile = this.getMainLectern();
        ArrayList<IItemHandler> handlers = new ArrayList<IItemHandler>();
        if (lecternTile == null) {
            return handlers;
        }
        for (HandlerPos handlerPos : lecternTile.handlerPosList) {
            IItemHandler handler;
            if (handlerPos.handler == null || this.level.getBlockEntity(handlerPos.pos) instanceof StorageLecternTile || (handler = (IItemHandler)handlerPos.handler.getCapability()) == null) continue;
            handlers.add(handler);
        }
        return handlers;
    }

    public void addHandlerPos(StorageLecternTile tile, BlockPos pos) {
        BlockCapabilityCache capabilityCache = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)((ServerLevel)this.level), (BlockPos)pos, null, () -> !tile.isRemoved(), () -> {
            this.invalidateNextTick = true;
        });
        if (capabilityCache.getCapability() != null) {
            tile.handlerPosList.add(new HandlerPos(pos.immutable(), (BlockCapabilityCache<? extends IItemHandler, Direction>)capabilityCache));
            tile.invalidateCapabilities();
        }
    }

    public void initHandlerCache() {
        if (this.level.isClientSide) {
            return;
        }
        StorageLecternTile lecternTile = this.getMainLectern();
        if (lecternTile == null) {
            return;
        }
        for (HandlerPos handlerPos : lecternTile.handlerPosList) {
            BlockPos pos = handlerPos.pos;
            if (pos.equals((Object)this.getBlockPos())) continue;
            handlerPos.handler = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)((ServerLevel)this.level), (BlockPos)pos, null, () -> !lecternTile.isRemoved(), () -> {
                this.invalidateNextTick = true;
            });
        }
        this.invalidateCapabilities();
    }

    @Nullable
    public IItemHandler getCapability(CraftingLecternTile object, Direction context) {
        StorageLecternTile lecternTile = object.getMainLectern();
        if (lecternTile == null) {
            this.lecternInvWrapper = new LecternInvWrapper(this, new IItemHandler[0]);
            return this.lecternInvWrapper;
        }
        lecternTile.lecternInvWrapper = new LecternInvWrapper(this, this.getConnectedHandlers().toArray(new IItemHandler[0]));
        return lecternTile.lecternInvWrapper;
    }

    public static class HandlerPos {
        public BlockPos pos;
        public BlockCapabilityCache<? extends IItemHandler, Direction> handler;
        public SlotCache slotCache;

        public HandlerPos(BlockPos pos, BlockCapabilityCache<? extends IItemHandler, Direction> handler) {
            this.pos = pos;
            this.handler = handler;
            this.slotCache = new SlotCache();
        }

        public BlockPos pos() {
            return this.pos;
        }

        public BlockCapabilityCache<? extends IItemHandler, Direction> handler() {
            return this.handler;
        }

        public boolean equals(Object obj) {
            if (obj instanceof HandlerPos) {
                HandlerPos handlerPos = (HandlerPos)obj;
                return this.pos.equals((Object)handlerPos.pos);
            }
            return false;
        }
    }
}

