/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.armor;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.perk.ITickablePerk;
import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import com.hollingsworth.arsnouveau.api.perk.PerkInstance;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.client.renderer.item.ArmorRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.GenericModel;
import com.hollingsworth.arsnouveau.common.crafting.recipes.IDyeable;
import com.hollingsworth.arsnouveau.common.items.data.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.common.perk.RepairingPerk;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.MaterialRegistry;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AnimatedMagicArmor
extends ArmorItem
implements IDyeable,
GeoItem {
    public GeoModel<AnimatedMagicArmor> model;
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public AnimatedMagicArmor(Holder<ArmorMaterial> materialIn, ArmorItem.Type slot, Item.Properties builder, GeoModel<AnimatedMagicArmor> model) {
        super(materialIn, slot, builder);
        this.model = model;
    }

    public AnimatedMagicArmor(Holder<ArmorMaterial> materialIn, ArmorItem.Type slot, GeoModel<AnimatedMagicArmor> model) {
        this(materialIn, slot, ItemsRegistry.defaultItemProperties().stacksTo(1).component(DataComponentRegistry.ARMOR_PERKS, (Object)new ArmorPerkHolder()).component(DataComponents.BASE_COLOR, (Object)DyeColor.PURPLE), model);
    }

    public static AnimatedMagicArmor light(ArmorItem.Type slot) {
        return new AnimatedMagicArmor(MaterialRegistry.LIGHT, slot, ItemsRegistry.defaultItemProperties().stacksTo(1).component(DataComponentRegistry.ARMOR_PERKS, (Object)new ArmorPerkHolder()).component(DataComponents.BASE_COLOR, (Object)DyeColor.PURPLE).durability(slot.getDurability(20)), new GenericModel("light_armor", "item/light_armor").withEmptyAnim());
    }

    public static AnimatedMagicArmor medium(ArmorItem.Type slot) {
        return new AnimatedMagicArmor(MaterialRegistry.MEDIUM, slot, ItemsRegistry.defaultItemProperties().stacksTo(1).component(DataComponentRegistry.ARMOR_PERKS, (Object)new ArmorPerkHolder()).component(DataComponents.BASE_COLOR, (Object)DyeColor.PURPLE).durability(slot.getDurability(25)), new GenericModel("medium_armor", "item/medium_armor").withEmptyAnim());
    }

    public static AnimatedMagicArmor heavy(ArmorItem.Type slot) {
        return new AnimatedMagicArmor(MaterialRegistry.HEAVY, slot, ItemsRegistry.defaultItemProperties().stacksTo(1).component(DataComponentRegistry.ARMOR_PERKS, (Object)new ArmorPerkHolder()).component(DataComponents.BASE_COLOR, (Object)DyeColor.PURPLE).durability(slot.getDurability(35)), new GenericModel("heavy_armor", "item/heavy_armor").withEmptyAnim());
    }

    public boolean isEnchantable(ItemStack pStack) {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level world, @NotNull Entity player, int slotId, boolean pIsSelected) {
        super.inventoryTick(stack, world, player, slotId, pIsSelected);
        if (slotId >= 36 && slotId < 40) {
            if (world.isClientSide()) {
                return;
            }
            if (player instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)player;
                RepairingPerk.attemptRepair(stack, livingEntity);
                ArmorPerkHolder perkHolder = PerkUtil.getPerkHolder(stack);
                if (perkHolder == null) {
                    return;
                }
                for (PerkInstance instance : perkHolder.getPerkInstances(stack)) {
                    IPerk iPerk = instance.getPerk();
                    if (!(iPerk instanceof ITickablePerk)) continue;
                    ITickablePerk tickablePerk = (ITickablePerk)((Object)iPerk);
                    tickablePerk.tick(stack, world, livingEntity, instance);
                }
            }
        }
    }

    @NotNull
    public ItemAttributeModifiers getDefaultAttributeModifiers(@NotNull ItemStack stack) {
        ItemAttributeModifiers modifiers = super.getDefaultAttributeModifiers(stack);
        ArmorPerkHolder perkHolder = PerkUtil.getPerkHolder(stack);
        if (perkHolder != null) {
            for (PerkInstance instance : perkHolder.getPerkInstances(stack)) {
                modifiers = instance.getPerk().applyAttributeModifiers(modifiers, stack, instance.getSlot().value(), EquipmentSlotGroup.bySlot((EquipmentSlot)this.type.getSlot()));
            }
            modifiers = modifiers.withModifierAdded(PerkAttributes.MAX_MANA, new AttributeModifier(ArsNouveau.prefix("max_mana_armor_" + this.type.getName()), (double)(30 * (perkHolder.getTier() + 1)), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)this.type.getSlot()));
            modifiers = modifiers.withModifierAdded(PerkAttributes.MANA_REGEN_BONUS, new AttributeModifier(ArsNouveau.prefix("mana_regen_armor_" + this.type.getName()), (double)(perkHolder.getTier() + 1), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)this.type.getSlot()));
        }
        return modifiers;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, world, tooltip, flag);
        ArmorPerkHolder data = (ArmorPerkHolder)stack.get(DataComponentRegistry.ARMOR_PERKS);
        if (data != null) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.tier", (Object[])new Object[]{data.getTier() + 1}).withStyle(ChatFormatting.GOLD));
            data.appendPerkTooltip(tooltip, stack);
        }
    }

    public boolean makesPiglinsNeutral(@NotNull ItemStack stack, @NotNull LivingEntity wearer) {
        return true;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        super.createGeoRenderer(consumer);
        consumer.accept(new GeoRenderProvider(){
            private GeoArmorRenderer<?> renderer;

            @Nullable
            public <T extends LivingEntity> HumanoidModel<?> getGeoArmorRenderer(@Nullable T livingEntity, ItemStack itemStack, @Nullable EquipmentSlot equipmentSlot, @Nullable HumanoidModel<T> original) {
                if (this.renderer == null) {
                    this.renderer = new ArmorRenderer(AnimatedMagicArmor.this.getArmorModel());
                }
                return this.renderer;
            }
        });
    }

    public boolean isDamageable(ItemStack stack) {
        return !stack.has(DataComponentRegistry.UNBREAKING);
    }

    public GeoModel<AnimatedMagicArmor> getArmorModel() {
        return this.model;
    }

    @Nullable
    public ResourceLocation getArmorTexture(@NotNull ItemStack stack, @NotNull Entity entity, @NotNull EquipmentSlot slot, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull ArmorMaterial.Layer layer, boolean innerModel) {
        GenericModel genericModel = (GenericModel)this.model;
        return ArsNouveau.prefix("textures/" + genericModel.textPathRoot + "/" + genericModel.name + "_" + this.getColor(stack) + ".png");
    }

    @Deprecated(forRemoval=true)
    public String getColor(ItemStack object) {
        return ((DyeColor)object.getOrDefault(DataComponents.BASE_COLOR, (Object)DyeColor.PURPLE)).getName();
    }

    public int getMinTier() {
        return 0;
    }
}

