/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.particle;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.particle.IParticleColor;
import com.hollingsworth.arsnouveau.api.registry.ParticleColorRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;

public class ParticleColor
implements IParticleColor,
Cloneable {
    public static final MapCodec<ParticleColor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(ParticleColor::getRegistryName), (App)Codec.INT.fieldOf("r").forGetter(ParticleColor::getRedInt), (App)Codec.INT.fieldOf("g").forGetter(ParticleColor::getGreenInt), (App)Codec.INT.fieldOf("b").forGetter(ParticleColor::getBlueInt)).apply((Applicative)instance, ParticleColorRegistry::from));
    public static final StreamCodec<RegistryFriendlyByteBuf, ParticleColor> STREAM = StreamCodec.of((buf, val) -> {
        buf.writeResourceLocation(val.getRegistryName());
        buf.writeInt(val.getRedInt());
        buf.writeInt(val.getGreenInt());
        buf.writeInt(val.getBlueInt());
    }, buf -> {
        ResourceLocation id = buf.readResourceLocation();
        int r = buf.readInt();
        int g = buf.readInt();
        int b = buf.readInt();
        return ParticleColorRegistry.from(id, r, g, b);
    });
    public static final ResourceLocation ID = ArsNouveau.prefix("constant");
    public static final ParticleColor DEFAULT = new ParticleColor(255, 25, 180);
    public static final ParticleColor WHITE = new ParticleColor(255, 255, 255);
    public static final ParticleColor RED = new ParticleColor(255, 50, 50);
    public static final ParticleColor GREEN = new ParticleColor(50, 255, 50);
    public static final ParticleColor BLUE = new ParticleColor(50, 50, 255);
    public static final ParticleColor YELLOW = new ParticleColor(255, 255, 0);
    public static final ParticleColor PURPLE = new ParticleColor(255, 50, 255);
    public static final ParticleColor CYAN = new ParticleColor(50, 255, 255);
    public static final ParticleColor ORANGE = new ParticleColor(255, 128, 0);
    public static final ParticleColor MAGENTA = new ParticleColor(255, 0, 255);
    public static final ParticleColor LIGHT_BLUE = new ParticleColor(173, 216, 230);
    public static final ParticleColor LIME = new ParticleColor(0, 255, 0);
    public static final ParticleColor PINK = new ParticleColor(255, 192, 203);
    public static final ParticleColor GRAY = new ParticleColor(128, 128, 128);
    public static final ParticleColor LIGHT_GRAY = new ParticleColor(211, 211, 211);
    public static final ParticleColor BROWN = new ParticleColor(125, 42, 42);
    public static final ParticleColor BLACK = new ParticleColor(0, 0, 0);
    public static final List<ParticleColor> PRESET_COLORS = List.of(BROWN, RED, ORANGE, YELLOW, LIME, GREEN, CYAN, LIGHT_BLUE, BLUE, PURPLE, MAGENTA, PINK, WHITE, LIGHT_GRAY, GRAY, BLACK);
    public static final ParticleColor TO_HIGHLIGHT = RED;
    public static final ParticleColor FROM_HIGHLIGHT = CYAN;
    public static final Random random = new Random();
    private final float r;
    private final float g;
    private float b;
    private final int color;

    public ParticleColor(int r, int g, int b) {
        this.r = (float)Math.max(r, 1) / 255.0f;
        this.g = (float)Math.max(g, 1) / 255.0f;
        this.b = (float)Math.max(b, 1) / 255.0f;
        this.color = r << 16 | g << 8 | b;
    }

    public ParticleColor(double red, double green, double blue) {
        this((int)red, (int)green, (int)blue);
    }

    public static ParticleColor makeRandomColor(int r, int g, int b, RandomSource random) {
        return new ParticleColor(random.nextInt(r), random.nextInt(g), random.nextInt(b));
    }

    public ParticleColor(float r, float g, float b) {
        this((int)r, (int)g, (int)b);
    }

    public ParticleColor(CompoundTag compoundTag) {
        this(compoundTag.getInt("r"), compoundTag.getInt("g"), compoundTag.getInt("b"));
    }

    public static ParticleColor fromInt(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        return new ParticleColor(r, g, b);
    }

    public static ParticleColor defaultParticleColor() {
        return new ParticleColor(255, 25, 180);
    }

    @Override
    public float getRed() {
        return this.r;
    }

    @Override
    public int getRedInt() {
        return (int)((double)this.r * 255.0);
    }

    @Override
    public float getGreen() {
        return this.g;
    }

    @Override
    public int getGreenInt() {
        return (int)((double)this.g * 255.0);
    }

    @Override
    public float getBlue() {
        return this.b;
    }

    @Override
    public int getBlueInt() {
        return (int)((double)this.b * 255.0);
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return ID;
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        IntWrapper wrapper = this.toWrapper();
        tag.putInt("r", wrapper.r);
        tag.putInt("g", wrapper.g);
        tag.putInt("b", wrapper.b);
        tag.putString("type", this.getRegistryName().toString());
        return tag;
    }

    public String toString() {
        return this.r + "," + this.g + "," + this.b;
    }

    public IntWrapper toWrapper() {
        return new IntWrapper(this);
    }

    @Override
    public ParticleColor nextColor(int ticks) {
        IntWrapper wrapper = this.toWrapper();
        return new ParticleColor(random.nextInt(wrapper.r), random.nextInt(wrapper.g), random.nextInt(wrapper.b));
    }

    public double euclideanDistance(ParticleColor color) {
        return Math.sqrt(Math.pow(this.r - color.getRed(), 2.0) + Math.pow(this.g - color.getGreen(), 2.0) + Math.pow(this.b - color.getBlue(), 2.0));
    }

    public ParticleColor clone() {
        try {
            ParticleColor clone = (ParticleColor)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParticleColor that = (ParticleColor)o;
        return Objects.equals(this.getRegistryName(), that.getRegistryName()) && Float.compare(this.r, that.r) == 0 && Float.compare(this.g, that.g) == 0 && Float.compare(this.b, that.b) == 0 && this.color == that.color;
    }

    public int hashCode() {
        return Objects.hash(this.getRegistryName(), Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), this.color);
    }

    public String toHex() {
        return String.format("#%02x%02x%02x", this.getRedInt(), this.getGreenInt(), this.getBlueInt());
    }

    public static ParticleColor fromHex(String colorStr) {
        return new ParticleColor(Integer.valueOf(colorStr.substring(1, 3), 16), Integer.valueOf(colorStr.substring(3, 5), 16), Integer.valueOf(colorStr.substring(5, 7), 16));
    }

    public ParticleColor getOppositeColor() {
        double y = (299 * this.getRedInt() + 587 * this.getGreenInt() + 114 * this.getBlueInt()) / 1000;
        return y >= 128.0 ? BLACK : WHITE;
    }

    @Deprecated(forRemoval=true)
    public static class IntWrapper
    implements Cloneable {
        public int r;
        public int g;
        public int b;

        public IntWrapper(int r, int g, int b) {
            this.r = Math.max(1, r);
            this.g = Math.max(1, g);
            this.b = Math.max(1, b);
        }

        public IntWrapper(ParticleColor color) {
            this.r = Math.max(1, (int)((double)color.getRed() * 255.0));
            this.g = Math.max(1, (int)((double)color.getGreen() * 255.0));
            this.b = Math.max(1, (int)((double)color.getBlue() * 255.0));
        }

        public ParticleColor toParticleColor() {
            return new ParticleColor(this.r, this.g, this.b);
        }

        public IntWrapper clone() {
            try {
                IntWrapper clone = (IntWrapper)super.clone();
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }
    }
}

