/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.particle.configurations;

import com.hollingsworth.arsnouveau.api.particle.PropertyParticleOptions;
import com.hollingsworth.arsnouveau.api.particle.configurations.IParticleMotionType;
import com.hollingsworth.arsnouveau.api.particle.configurations.ParticleMotion;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.BaseProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.IPropertyType;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.ParticleDensityProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.ParticleTypeProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.PropMap;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.SpeedProperty;
import com.hollingsworth.arsnouveau.api.registry.ParticleMotionRegistry;
import com.hollingsworth.arsnouveau.api.registry.ParticlePropertyRegistry;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class HelixMotion
extends ParticleMotion {
    public static MapCodec<HelixMotion> CODEC = HelixMotion.buildPropCodec(HelixMotion::new);
    public static StreamCodec<RegistryFriendlyByteBuf, HelixMotion> STREAM = HelixMotion.buildStreamCodec(HelixMotion::new);

    public HelixMotion(PropMap propMap) {
        super(propMap);
        propMap.createIfMissing(new ParticleTypeProperty());
    }

    @Override
    public IParticleMotionType<?> getType() {
        return (IParticleMotionType)ParticleMotionRegistry.HELIX_TYPE.get();
    }

    @Override
    public void tick(PropertyParticleOptions particleOptions, Level level, double x, double y, double z, double prevX, double prevY, double prevZ) {
        ParticleDensityProperty densityProperty = this.getDensity(particleOptions, 100, 0.3f);
        double radius = densityProperty.radius();
        int totalParticles = this.getNumParticles(densityProperty.density());
        ParticleTypeProperty secondType = (ParticleTypeProperty)this.propertyMap.get((IPropertyType)ParticlePropertyRegistry.TYPE_PROPERTY.get());
        PropertyParticleOptions particle2 = secondType != null ? new PropertyParticleOptions(this.propertyMap) : new PropertyParticleOptions();
        for (int step = 0; step <= totalParticles; ++step) {
            double interpolatedAge;
            double t = (double)step / (double)totalParticles;
            double interpolatedX = prevX + t * (x - prevX);
            double interpolatedY = prevY + t * (y - prevY);
            double interpolatedZ = prevZ + t * (z - prevZ);
            double angle = interpolatedAge = (double)this.emitter.age + t;
            float localX = (float)(Math.sin(angle) * radius);
            float localY = (float)(Math.cos(angle) * radius);
            float localZ = 0.0f;
            Vector3f spiralOne = this.toEmitterSpace((float)interpolatedX, (float)interpolatedY, (float)interpolatedZ, localX, localY, localZ);
            Vector3f opposite = this.toEmitterSpace((float)interpolatedX, (float)interpolatedY, (float)interpolatedZ, -localX, -localY, -localZ);
            Vec3 speedOne = this.randomSpeed(particleOptions);
            Vec3 speedTwo = this.randomSpeed(particle2);
            Vector3f realSpeed = this.toEmitterSpace(0.0f, 0.0f, 0.0f, (float)speedOne.x, (float)speedOne.y, 0.0f);
            Vector3f realSpeed2 = this.toEmitterSpace(0.0f, 0.0f, 0.0f, (float)speedTwo.x, (float)speedTwo.y, 0.0f);
            level.addAlwaysVisibleParticle((ParticleOptions)particleOptions, true, (double)spiralOne.x, (double)spiralOne.y, (double)spiralOne.z, (double)realSpeed.x, (double)realSpeed.y, (double)realSpeed.z);
            level.addAlwaysVisibleParticle((ParticleOptions)particle2, true, (double)opposite.x, (double)opposite.y, (double)opposite.z, (double)realSpeed2.x, (double)realSpeed2.y, (double)realSpeed2.z);
        }
    }

    @Override
    public List<BaseProperty<?>> getProperties(PropMap propMap) {
        return List.of(propMap.createIfMissing(new ParticleTypeProperty()), this.propertyMap.createIfMissing(new ParticleTypeProperty()), propMap.createIfMissing(new ParticleDensityProperty(100, (double)0.3f, ParticleMotion.SpawnType.SPHERE)), propMap.createIfMissing(new SpeedProperty()));
    }
}

