/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.item.inv;

import com.hollingsworth.arsnouveau.api.item.inv.IFiltersetProvider;
import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public abstract class FilterSet {
    public abstract ItemScroll.SortPref getHighestPreference(ItemStack var1);

    public static FilterSet forPosition(Level level, BlockPos pos) {
        ArrayList<Function<ItemStack, ItemScroll.SortPref>> filters = new ArrayList<Function<ItemStack, ItemScroll.SortPref>>();
        IItemHandler inv = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, null);
        if (inv == null) {
            return new ListSet(filters);
        }
        IFiltersetProvider filtersetProvider = (IFiltersetProvider)level.getCapability(CapabilityRegistry.FILTERSET_CAPABILITY, pos, null);
        if (filtersetProvider != null) {
            return filtersetProvider.getFilterSet();
        }
        for (ItemFrame i : level.getEntitiesOfClass(ItemFrame.class, new AABB(pos).inflate(1.0))) {
            BlockPos attachedTo = i.blockPosition().relative(i.getDirection().getOpposite());
            if (!attachedTo.equals((Object)pos)) continue;
            ItemStack stackInFrame = i.getItem();
            if (i.getItem().isEmpty() || stackInFrame.isEmpty()) continue;
            Item item = stackInFrame.getItem();
            if (item instanceof ItemScroll) {
                ItemScroll scrollItem = (ItemScroll)item;
                filters.add(stackToStore -> scrollItem.getSortPref((ItemStack)stackToStore, stackInFrame, inv));
                continue;
            }
            filters.add(stackToStore -> stackToStore.getItem() == stackInFrame.getItem() ? ItemScroll.SortPref.HIGHEST : ItemScroll.SortPref.INVALID);
        }
        return new ListSet(filters);
    }

    public static class ListSet
    extends FilterSet {
        public List<Function<ItemStack, ItemScroll.SortPref>> filters;

        public ListSet() {
            this.filters = new ArrayList<Function<ItemStack, ItemScroll.SortPref>>();
        }

        public ListSet(List<Function<ItemStack, ItemScroll.SortPref>> filters) {
            this.filters = filters;
        }

        public boolean addFilterScroll(ItemStack scrollStack, IItemHandler itemHandler) {
            Item item = scrollStack.getItem();
            if (item instanceof ItemScroll) {
                ItemScroll itemScroll = (ItemScroll)item;
                return this.filters.add(stackIn -> itemScroll.getSortPref((ItemStack)stackIn, scrollStack, itemHandler));
            }
            return false;
        }

        @Override
        public ItemScroll.SortPref getHighestPreference(ItemStack stack) {
            ItemScroll.SortPref pref = ItemScroll.SortPref.LOW;
            for (Function<ItemStack, ItemScroll.SortPref> filter : this.filters) {
                ItemScroll.SortPref newPref = filter.apply(stack);
                if (newPref == ItemScroll.SortPref.INVALID) {
                    return ItemScroll.SortPref.INVALID;
                }
                if (newPref.ordinal() <= pref.ordinal()) continue;
                pref = newPref;
            }
            return pref;
        }
    }

    public static class Composite
    extends FilterSet {
        public List<FilterSet> filterSets;

        public Composite(List<FilterSet> filterSets) {
            this.filterSets = filterSets;
        }

        public Composite() {
            this.filterSets = new ArrayList<FilterSet>();
        }

        public Composite withFilter(FilterSet filterSet) {
            this.filterSets.add(filterSet);
            return this;
        }

        @Override
        public ItemScroll.SortPref getHighestPreference(ItemStack stack) {
            ItemScroll.SortPref pref = ItemScroll.SortPref.LOW;
            for (FilterSet filterSet : this.filterSets) {
                ItemScroll.SortPref newPref = filterSet.getHighestPreference(stack);
                if (newPref == ItemScroll.SortPref.INVALID) {
                    return ItemScroll.SortPref.INVALID;
                }
                if (newPref.ordinal() <= pref.ordinal()) continue;
                pref = newPref;
            }
            return pref;
        }
    }
}

